/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.ui.admin.action.UserSessionsAbstractAction;
import gov.va.med.esr.ui.admin.beans.UserSessionBean;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UserSessionsAction
extends UserSessionsAbstractAction {
    public static final String MSG_NO_PERMISSION_TO_VIEW_ACTIVE_SESSIONS = "error.noPermissionViewActiveSessions";
    public static final String MSG_NO_SESSION_FOUND = "error.noSessionFound";
    public static final String MSG_NO_INVALIDATE_CURRENT_SESSION = "error.noInvalidateCurrentSession";
    public static final String MSG_SESSION_INVALIDATED = "message.sessionInvalidated";
    public static final String MSG_ALL_SESSIONS_INVALIDATED = "message.allSessionsInvalidated";
    public static final String SESSION_ID_REQUEST_KEY = "id";
    public static final String USER_SESSIONS_REQUEST_KEY = "userSessionsRequestKey";
    public static final String CURRENT_USER_REQUEST_KEY = "currentUserRequestKey";
    public static final String ANONYMOUS_USER = "anonymousUser";
    public static final String UNKNOWN_USER = "[UNKNOWN]";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<UserSessionBean> sessionBeanList = new ArrayList<UserSessionBean>();
        String currentUser = UNKNOWN_USER;
        if (this.isAnyPermissionGranted(administratorPermissions)) {
            Hashtable sessionTable = this.getSessions(request);
            for (HttpSession session : sessionTable.values()) {
                UserSessionBean sessionBean = new UserSessionBean();
                sessionBean.setCreationTime(new Date(session.getCreationTime()));
                sessionBean.setLastAccessedTime(new Date(session.getLastAccessedTime()));
                sessionBean.setMaxInactiveInterval(session.getMaxInactiveInterval());
                sessionBean.setId(session.getId());
                sessionBean.setCurrentSession(this.isCurrentSession(session.getId(), request));
                Object authObject = session.getAttribute("ACEGI_SECURITY_CONTEXT");
                SecurityContext secureContext = (SecurityContext)authObject;
                if (secureContext != null) {
                    String username;
                    Authentication auth = secureContext.getAuthentication();
                    Object principalObject = auth.getPrincipal();
                    String string = username = principalObject == null ? "" : principalObject.toString();
                    if (UserPrincipal.class.isAssignableFrom(principalObject.getClass())) {
                        UserPrincipal userPrincipal = (UserPrincipal)principalObject;
                        UserCredentials userCredentials = userPrincipal.getUserCredentials();
                        username = userCredentials.getUserID();
                    }
                    sessionBean.setUsername(username);
                    WebAuthenticationDetails authDetails = (WebAuthenticationDetails)auth.getDetails();
                    sessionBean.setRemoteIpAddress(authDetails == null ? "" : authDetails.getRemoteAddress());
                } else {
                    sessionBean.setUsername("");
                    sessionBean.setRemoteIpAddress("");
                }
                if (sessionBean.isCurrentSession()) {
                    currentUser = sessionBean.getUsername();
                }
                if (!StringUtils.isNotBlank((String)sessionBean.getUsername()) || sessionBean.getUsername().equalsIgnoreCase(ANONYMOUS_USER)) continue;
                sessionBeanList.add(sessionBean);
            }
            Collections.sort(sessionBeanList);
        } else {
            this.addActionMessage(request, MSG_NO_PERMISSION_TO_VIEW_ACTIVE_SESSIONS);
        }
        request.setAttribute(USER_SESSIONS_REQUEST_KEY, sessionBeanList);
        request.setAttribute(CURRENT_USER_REQUEST_KEY, (Object)currentUser);
        return mapping.findForward("success");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.display(mapping, form, request, response);
    }

    public ActionForward invalidate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isAnyPermissionGranted(administratorPermissions)) {
            String id = request.getParameter(SESSION_ID_REQUEST_KEY);
            Validate.notEmpty((String)id, (String)"A session Id wasn't specified.");
            String currentSessionId = this.getCurrentSessionId(request);
            if (currentSessionId.equals(id)) {
                this.addActionMessage(request, MSG_NO_INVALIDATE_CURRENT_SESSION);
            } else {
                HttpSession session = this.getSessionById(request, id);
                if (session == null) {
                    this.addActionMessage(request, MSG_NO_SESSION_FOUND);
                } else {
                    session.invalidate();
                    this.addInformationMessage(request, MSG_SESSION_INVALIDATED);
                }
            }
        }
        return this.display(mapping, form, request, response);
    }

    public ActionForward invalidateAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isAnyPermissionGranted(administratorPermissions)) {
            Hashtable sessionTable = this.getSessions(request);
            ArrayList<HttpSession> sessionsToInvalidate = new ArrayList<HttpSession>();
            for (HttpSession session : sessionTable.values()) {
                String sessionId = session.getId();
                if (this.isCurrentSession(sessionId, request)) continue;
                sessionsToInvalidate.add(session);
            }
            for (HttpSession session : sessionsToInvalidate) {
                session.invalidate();
            }
            this.addInformationMessage(request, MSG_ALL_SESSIONS_INVALIDATED);
        }
        return this.display(mapping, form, request, response);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.refresh", "refresh");
        map.put("button.invalidate", "invalidate");
        map.put("button.invalidateAll", "invalidateAll");
        return map;
    }
}

