/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.ui.common.action.AbstractAction;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionContext;

public class UserSessionsAbstractAction
extends AbstractAction {
    protected static String[] administratorPermissions = new String[]{Capability.LOCAL_ADMINISTRATOR.getName(), Capability.ADMINISTRATOR.getName()};

    protected HttpSession getSessionById(HttpServletRequest request, String id) {
        Validate.notEmpty((String)id, (String)"Session Id can not be empty.");
        Hashtable sessionTable = this.getSessions(request);
        for (HttpSession session : sessionTable.values()) {
            if (!id.equals(session.getId())) continue;
            return session;
        }
        return null;
    }

    protected void sendAsyncMessage(HttpServletRequest request, String id, String message) {
        if (this.isAnyPermissionGranted(administratorPermissions)) {
            HttpSession session = this.getSessionById(request, id);
            this.addAsyncMessages(session, message);
        }
    }

    protected void broadcastAsyncMessage(HttpServletRequest request, String message) {
        if (this.isAnyPermissionGranted(administratorPermissions)) {
            Hashtable sessionTable = this.getSessions(request);
            for (HttpSession session : sessionTable.values()) {
                this.addAsyncMessages(session, message);
            }
        }
    }

    protected String getCurrentSessionId(HttpServletRequest request) {
        return request.getSession().getId();
    }

    protected boolean isCurrentSession(String id, HttpServletRequest request) {
        return id.equals(this.getCurrentSessionId(request));
    }

    protected Hashtable getSessions(HttpServletRequest request) {
        WebAppServletContext webContext = (WebAppServletContext)request.getSession().getServletContext();
        SessionContext sessionContext = webContext.getSessionContext();
        return sessionContext.getOpenSessions();
    }

    public void afterPropertiesSet() throws Exception {
    }
}

