/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.UserCapability;
import gov.va.med.esr.ui.admin.action.AbstractUserProfileForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.util.StringUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class UserProfileForm
extends AbstractUserProfileForm {
    private static final long serialVersionUID = 158788621786362850L;
    private String userId;
    private String name;
    private String functionalGroup;
    private String fullName;

    public UserProfileForm() {
        this.initialize();
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.initialize();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getFunctionalGroup() {
        return this.functionalGroup;
    }

    public void setFunctionalGroup(String functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setAssignedCapabilities(List assignedCapabilities) {
        if (assignedCapabilities != null) {
            Collections.sort(assignedCapabilities);
            for (int i = 0; i < assignedCapabilities.size(); ++i) {
                UserCapability userCapability = (UserCapability)assignedCapabilities.get(i);
                Capability capability = userCapability.getCapability();
                this.setAssignedCapabilityCode(i, capability.getCode());
                this.setAssignedCapabilityName(i, capability.getName());
                EntityKey key = userCapability.getEntityKey();
                String keyStr = key == null ? null : key.getKeyValueAsString();
                this.setAssignedUserCapabilityId(i, keyStr);
                this.setAssignedCapabilityInd(i, Boolean.TRUE);
                this.setAssignedCapabilityActiveDate(i, DateUtils.format((Date)userCapability.getActiveDate(), null));
                this.setAssignedCapabilityInactiveDate(i, DateUtils.format((Date)userCapability.getInactiveDate(), null));
                if (key != null) {
                    this.setAssignedCapabilityOldActiveDate(i, DateUtils.format((Date)userCapability.getOldActiveDate(), null));
                    this.setAssignedCapabilityOldInactiveDate(i, DateUtils.format((Date)userCapability.getOldInactiveDate(), null));
                    continue;
                }
                this.setAssignedCapabilityOldActiveDate(i, null);
                this.setAssignedCapabilityOldInactiveDate(i, null);
            }
        }
    }

    public void setAssignedCapabilitySets(List assignedCapabilitySets) {
        if (assignedCapabilitySets != null) {
            Collections.sort(assignedCapabilitySets);
            for (int i = 0; i < assignedCapabilitySets.size(); ++i) {
                CapabilitySet capabilitySet = (CapabilitySet)assignedCapabilitySets.get(i);
                this.setAssignedCapabilitySetId(i, capabilitySet.getEntityKey().getKeyValueAsString());
                this.setAssignedCapabilitySetName(i, capabilitySet.getName());
                this.setAssignedCapabilitySetInd(i, Boolean.TRUE);
                this.setAssignedCapabilitySetActiveDate(i, DateUtils.format((Date)capabilitySet.getActiveDate(), null));
                this.setAssignedCapabilitySetInactiveDate(i, DateUtils.format((Date)capabilitySet.getInactiveDate(), null));
            }
        }
    }

    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request) {
        int i;
        ActionMessages messages = this.getActionMessages(request);
        int activeDates = this.getCapabilityActiveDateList().size();
        int assignedActiveDates = this.getAssignedCapabilityActiveDateList().size();
        boolean newAssignment = true;
        for (i = 0; i < activeDates; ++i) {
            if (!Boolean.TRUE.equals(this.getCapabilityInd(i))) continue;
            this.checkActiveInactiveDates(messages, this.getCapabilityActiveDate(i), this.getCapabilityInactiveDate(i), i, "capabilityName", null, null);
        }
        for (i = 0; i < assignedActiveDates; ++i) {
            if (!Boolean.TRUE.equals(this.getAssignedCapabilityInd(i))) continue;
            newAssignment = StringUtils.isEmpty((String)this.getAssignedUserCapabilityId(i));
            this.checkActiveInactiveDates(messages, this.getAssignedCapabilityActiveDate(i), this.getAssignedCapabilityInactiveDate(i), i, "assignedCapabilityName", this.getAssignedCapabilityOldActiveDate(i), this.getAssignedCapabilityOldInactiveDate(i));
        }
        return messages;
    }

    private void checkActiveInactiveDates(ActionMessages messages, String activeDateStr, String inactiveDateStr, int index, String indexFieldName, String oldActiveDateStr, String oldInactiveDateStr) {
        if (StringUtils.isEmpty((String)activeDateStr) && StringUtils.isEmpty((String)inactiveDateStr)) {
            return;
        }
        Date current = DateUtils.getCurrentDate();
        Date activeDate = null;
        Date inactiveDate = null;
        Date oldActiveDate = this.getDate(oldActiveDateStr, null);
        Date oldInactiveDate = this.getDate(oldInactiveDateStr, null);
        if (StringUtils.isNotEmpty((String)activeDateStr)) {
            try {
                activeDate = DateUtils.getDate((String)activeDateStr);
                if ((oldActiveDate == null || !oldActiveDate.equals(activeDate)) && activeDate.before(current)) {
                    messages.add(indexFieldName + "[" + index + "]", new ActionMessage("error.activeDatePast"));
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (activeDate == null) {
                messages.add(indexFieldName + "[" + index + "]", new ActionMessage("errors.date", (Object)"Active Date"));
            }
        }
        if (StringUtils.isNotEmpty((String)inactiveDateStr)) {
            try {
                inactiveDate = DateUtils.getDate((String)inactiveDateStr);
                if ((oldInactiveDate == null || !oldInactiveDate.equals(inactiveDate)) && inactiveDate.before(current)) {
                    messages.add(indexFieldName + "[" + index + "]", new ActionMessage("error.inactiveDatePast"));
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (inactiveDate == null) {
                messages.add(indexFieldName + "[" + index + "]", new ActionMessage("errors.date", (Object)"Inactive Date"));
            }
        }
        if (activeDate != null && inactiveDate != null && activeDate.after(inactiveDate)) {
            messages.add(indexFieldName + "[" + index + "]", new ActionMessage("error.activeDate"));
        }
    }

    private Date getDate(String dateStr, Date defDate) {
        try {
            return DateUtils.getDate((String)dateStr);
        }
        catch (Exception exception) {
            return defDate;
        }
    }

    private void initialize() {
        this.userId = null;
        this.name = null;
        this.fullName = null;
        this.functionalGroup = null;
    }
}

