/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.service.UserAdminService;
import gov.va.med.esr.ui.admin.action.CapabilitySetForm;
import gov.va.med.esr.ui.admin.action.RoleForm;
import gov.va.med.esr.ui.admin.action.UserProfileForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserProfileConversionService
extends UIConversionServiceImpl {
    private UserAdminService userAdminService = null;

    @Override
    public UserAdminService getUserAdminService() {
        return this.userAdminService;
    }

    @Override
    public void setUserAdminService(UserAdminService userAdminService) {
        this.userAdminService = userAdminService;
    }

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        block8: {
            try {
                if (source instanceof CapabilitySet && target instanceof CapabilitySetForm) {
                    this.convert((CapabilitySet)source, (CapabilitySetForm)((Object)target));
                    break block8;
                }
                if (source instanceof CapabilitySetForm && target instanceof CapabilitySet) {
                    this.convert((CapabilitySetForm)((Object)source), (CapabilitySet)target);
                    break block8;
                }
                if (source instanceof ESRRolePrincipalImpl && target instanceof RoleForm) {
                    this.convert((ESRRolePrincipalImpl)source, (RoleForm)((Object)target));
                    break block8;
                }
                if (source instanceof RoleForm && target instanceof ESRRolePrincipalImpl) {
                    this.convert((RoleForm)((Object)source), (ESRRolePrincipalImpl)target);
                    break block8;
                }
                if (source instanceof ESRUserPrincipalImpl && target instanceof UserProfileForm) {
                    this.convert((ESRUserPrincipalImpl)source, (UserProfileForm)((Object)target));
                    break block8;
                }
                if (source instanceof UserProfileForm && target instanceof ESRUserPrincipalImpl) {
                    this.convert((UserProfileForm)((Object)source), (ESRUserPrincipalImpl)target);
                    break block8;
                }
                throw new Exception("Conversion is not supported");
            }
            catch (Exception e) {
                throw new ConversionServiceException("Can not convert from " + source.getClass().getName() + " to " + target.getClass().getName(), e);
            }
        }
    }

    private void convert(ESRUserPrincipalImpl user, UserProfileForm form) throws Exception {
        form.setUserId(user.getEntityKey().getKeyValueAsString());
        form.setName(user.getName());
        form.setFullName(user.getFullName());
        form.setFunctionalGroup(user.getFunctionalGroup() == null ? null : user.getFunctionalGroup().getCode());
        form.setAssignedCapabilitySets(new ArrayList(user.getCapabilitySets()));
        form.setAssignedCapabilities(new ArrayList(user.getUserCapabilities()));
        form.setAssignedRoles(new ArrayList(user.getUserRoles()));
        Set assignedCapabilities = user.getCapabilities();
        Set assignedCapabilitySets = user.getCapabilitySets();
        Set assignedRoles = user.getUserRoles();
        for (ESRRolePrincipalImpl role : assignedRoles) {
            assignedCapabilitySets.addAll(role.getCapabilitySets());
            assignedCapabilities.addAll(role.getCapabilities());
        }
        for (CapabilitySet cset : assignedCapabilitySets) {
            assignedCapabilities.addAll(cset.getCapabilities());
        }
        List availableCapabilitySets = this.getUserAdminService().getAllCapabilitySets();
        availableCapabilitySets = this.filterCapabilitySets(availableCapabilitySets, assignedCapabilitySets);
        List availableCapabilities = this.getUserAdminService().getAllCapabilities();
        availableCapabilities.removeAll(assignedCapabilities);
        List availableRoles = this.getUserAdminService().getAllRoles();
        availableRoles = this.filterRoles(availableRoles, assignedRoles);
        form.setAvailableCapabilitySets(availableCapabilitySets);
        form.setAvailableCapabilities(availableCapabilities);
        form.setAvailableRoles(availableRoles);
    }

    private void convert(UserProfileForm form, ESRUserPrincipalImpl user) throws Exception {
        FunctionalGroup fg = null;
        if (StringUtils.isNotEmpty((String)form.getFunctionalGroup())) {
            fg = (FunctionalGroup)this.getLookupCacheService().getByCodeFromCache(FunctionalGroup.class, form.getFunctionalGroup());
        }
        user.setFunctionalGroup(fg);
        this.updateUserRoles(form, user);
        this.updateUserCapabilitySets(form, user);
        this.updateUserCapabilities(form, user);
    }

    private void updateUserRoles(UserProfileForm form, ESRUserPrincipalImpl user) throws Exception {
        List indList;
        ArrayList<ESRRolePrincipalImpl> currentList = new ArrayList<ESRRolePrincipalImpl>();
        List idList = form.getAssignedRoleIdList();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                Boolean selected = form.getAssignedRoleInd(i);
                String roleId = form.getAssignedRoleId(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(roleId), ESRRolePrincipalImpl.class);
                ESRRolePrincipalImpl role = (ESRRolePrincipalImpl)this.getUserAdminService().getRoleById(entityKey);
                user.addUserRole((RolePrincipal)role);
                currentList.add(role);
            }
        }
        if ((indList = form.getRoleIndList()) != null && indList.size() > 0) {
            for (int i = 0; i < indList.size(); ++i) {
                Boolean selected = form.getRoleInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                String setId = form.getRoleId(i);
                EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(setId), ESRRolePrincipalImpl.class);
                ESRRolePrincipalImpl role = (ESRRolePrincipalImpl)this.getUserAdminService().getRoleById(entityKey);
                user.addUserRole((RolePrincipal)role);
                currentList.add(role);
            }
        }
        Set deletedSet = user.getUserRoles();
        deletedSet.removeAll(currentList);
        Iterator i = deletedSet.iterator();
        while (i.hasNext()) {
            user.removeUserRole((RolePrincipal)((ESRRolePrincipalImpl)i.next()));
        }
    }

    private void updateUserCapabilitySets(UserProfileForm form, ESRUserPrincipalImpl user) throws Exception {
        List indList;
        ArrayList<CapabilitySet> currentList = new ArrayList<CapabilitySet>();
        List idList = form.getAssignedCapabilitySetIdList();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                Boolean selected = form.getAssignedCapabilitySetInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                String setId = form.getAssignedCapabilitySetId(i);
                EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(setId), CapabilitySet.class);
                CapabilitySet capabilitySet = this.getUserAdminService().getCapabilitySetById(entityKey);
                user.addCapabilitySet(capabilitySet);
                currentList.add(capabilitySet);
            }
        }
        if ((indList = form.getCapabilitySetIndList()) != null && indList.size() > 0) {
            for (int i = 0; i < indList.size(); ++i) {
                Boolean selected = form.getCapabilitySetInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                String setId = form.getCapabilitySetId(i);
                EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(setId), CapabilitySet.class);
                CapabilitySet capabilitySet = this.getUserAdminService().getCapabilitySetById(entityKey);
                user.addCapabilitySet(capabilitySet);
                currentList.add(capabilitySet);
            }
        }
        Collection deletedSet = this.filterById(user.getCapabilitySets(), currentList);
        Iterator i = deletedSet.iterator();
        while (i.hasNext()) {
            user.removeCapabilitySet((CapabilitySet)i.next());
        }
    }

    private void updateUserCapabilities(UserProfileForm form, ESRUserPrincipalImpl user) throws Exception {
        List idList;
        ArrayList<Capability> currentList = new ArrayList<Capability>();
        List codeList = form.getAssignedCapabilityCodeList();
        if (codeList != null && codeList.size() > 0) {
            for (int i = 0; i < codeList.size(); ++i) {
                Boolean selected = form.getAssignedCapabilityInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                Capability capability = (Capability)this.getLookupCacheService().getByCodeFromCache(Capability.class, form.getAssignedCapabilityCode(i));
                Date activeDate = DateUtils.getDate((String)form.getAssignedCapabilityActiveDate(i));
                Date inactiveDate = DateUtils.getDate((String)form.getAssignedCapabilityInactiveDate(i));
                user.addCapability(capability, activeDate, inactiveDate);
                currentList.add(capability);
            }
        }
        if ((idList = form.getCapabilityIndList()) != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                Boolean selected = form.getCapabilityInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                Capability capability = (Capability)this.getLookupCacheService().getByCodeFromCache(Capability.class, form.getCapabilityCode(i));
                Date activeDate = DateUtils.getDate((String)form.getCapabilityActiveDate(i));
                Date inactiveDate = DateUtils.getDate((String)form.getCapabilityInactiveDate(i));
                user.addCapability(capability, activeDate, inactiveDate);
                currentList.add(capability);
            }
        }
        Set deletedSet = user.getCapabilities();
        deletedSet.removeAll(currentList);
        Iterator i = deletedSet.iterator();
        while (i.hasNext()) {
            user.removeCapability((Capability)i.next());
        }
    }

    private void convert(ESRRolePrincipalImpl role, RoleForm roleForm) throws Exception {
        if (role.getEntityKey() != null) {
            roleForm.setRoleId(role.getEntityKey().getKeyValueAsString());
        }
        roleForm.setName(role.getName());
        roleForm.setDescription(role.getDescription());
        roleForm.setActiveDate(DateUtils.format((Date)role.getActiveDate(), null));
        roleForm.setInactiveDate(DateUtils.format((Date)role.getInactiveDate(), null));
        Set assignedCapabilities = role.getCapabilities();
        Set assignedCapabilitySets = role.getCapabilitySets();
        roleForm.setAssignedCapabilitySets(new ArrayList(role.getCapabilitySets()));
        roleForm.setAssignedCapabilities(new ArrayList(role.getCapabilities()));
        List availableCapabilitySets = this.getUserAdminService().getAllCapabilitySets();
        ArrayList<CapabilitySet> deleteList = new ArrayList<CapabilitySet>();
        Iterator i = assignedCapabilitySets.iterator();
        while (i.hasNext()) {
            String key1 = ((CapabilitySet)i.next()).getEntityKey().getKeyValueAsString();
            for (CapabilitySet deletedSet : availableCapabilitySets) {
                String key2 = deletedSet.getEntityKey().getKeyValueAsString();
                if (!key1.equals(key2)) continue;
                deleteList.add(deletedSet);
            }
        }
        availableCapabilitySets.removeAll(deleteList);
        ArrayList assignedCapabilityList = new ArrayList();
        assignedCapabilityList.addAll(assignedCapabilities);
        Iterator i2 = assignedCapabilitySets.iterator();
        while (i2.hasNext()) {
            assignedCapabilityList.addAll(((CapabilitySet)i2.next()).getCapabilities());
        }
        List availableCapabilities = this.getUserAdminService().getAllCapabilities();
        availableCapabilities.removeAll(assignedCapabilityList);
        roleForm.setAvailableCapabilitySets(availableCapabilitySets);
        roleForm.setAvailableCapabilities(availableCapabilities);
    }

    private void convert(RoleForm form, ESRRolePrincipalImpl role) throws Exception {
        if (role.getEntityKey() == null) {
            role.setName(form.getName());
            role.setDescription(form.getDescription());
        }
        role.setActiveDate(DateUtils.getDate((String)form.getActiveDate()));
        role.setInactiveDate(DateUtils.getDate((String)form.getInactiveDate()));
        this.updateRoleCapabilitySets(form, role);
        this.updateRoleCapabilities(form, role);
    }

    private void updateRoleCapabilitySets(RoleForm form, ESRRolePrincipalImpl role) throws Exception {
        List indList;
        ArrayList<CapabilitySet> addList = new ArrayList<CapabilitySet>();
        List idList = form.getAssignedCapabilitySetIndList();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                Boolean selected = form.getAssignedCapabilitySetInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                String setId = form.getAssignedCapabilitySetId(i);
                EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(setId), CapabilitySet.class);
                CapabilitySet capabilitySet = this.getUserAdminService().getCapabilitySetById(entityKey);
                addList.add(capabilitySet);
            }
        }
        if ((indList = form.getCapabilitySetIndList()) != null && indList.size() > 0) {
            for (int i = 0; i < indList.size(); ++i) {
                Boolean selected = form.getCapabilitySetInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                String setId = form.getCapabilitySetId(i);
                EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(setId), CapabilitySet.class);
                CapabilitySet capabilitySet = this.getUserAdminService().getCapabilitySetById(entityKey);
                addList.add(capabilitySet);
            }
        }
        ArrayList deletedList = new ArrayList(role.getCapabilitySets());
        deletedList.removeAll(addList);
        Iterator i = deletedList.iterator();
        while (i.hasNext()) {
            role.removeCapabilitySet((CapabilitySet)i.next());
        }
        for (int i2 = 0; i2 < addList.size(); ++i2) {
            role.addCapabilitySet((CapabilitySet)addList.get(i2));
        }
    }

    private void updateRoleCapabilities(RoleForm form, ESRRolePrincipalImpl role) throws Exception {
        List idList;
        Boolean selected;
        ArrayList<Capability> addList = new ArrayList<Capability>();
        List codeList = form.getAssignedCapabilityCodeList();
        if (codeList != null && codeList.size() > 0) {
            for (int i = 0; i < codeList.size(); ++i) {
                Capability capability = (Capability)this.getLookupCacheService().getByCodeFromCache(Capability.class, form.getAssignedCapabilityCode(i));
                selected = form.getAssignedCapabilityInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                addList.add(capability);
            }
        }
        if ((idList = form.getCapabilityIndList()) != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                selected = form.getCapabilityInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                Capability capability = (Capability)this.getLookupCacheService().getByCodeFromCache(Capability.class, form.getCapabilityCode(i));
                addList.add(capability);
            }
        }
        ArrayList deletedList = new ArrayList(role.getCapabilities());
        deletedList.removeAll(addList);
        Iterator i = deletedList.iterator();
        while (i.hasNext()) {
            role.removeCapability((Capability)i.next());
        }
        for (int i2 = 0; i2 < addList.size(); ++i2) {
            role.addCapability((Capability)addList.get(i2));
        }
    }

    private void convert(CapabilitySet capabilitySet, CapabilitySetForm setForm) throws Exception {
        if (capabilitySet.getEntityKey() != null) {
            setForm.setCapabilitySetId(capabilitySet.getEntityKey().getKeyValueAsString());
        }
        setForm.setName(capabilitySet.getName());
        setForm.setDescription(capabilitySet.getDescription());
        setForm.setActiveDate(DateUtils.format((Date)capabilitySet.getActiveDate(), null));
        setForm.setInactiveDate(DateUtils.format((Date)capabilitySet.getInactiveDate(), null));
        List availableCapabilities = this.getUserAdminService().getAllCapabilities();
        ArrayList assignedCapabilities = new ArrayList(capabilitySet.getCapabilities());
        setForm.setAssignedCapabilities(assignedCapabilities);
        availableCapabilities.removeAll(assignedCapabilities);
        setForm.setAvailableCapabilities(availableCapabilities);
    }

    private void convert(CapabilitySetForm form, CapabilitySet set) throws Exception {
        Capability capability;
        Boolean selected;
        int i;
        if (set.getEntityKey() == null) {
            set.setName(form.getName());
            set.setDescription(form.getDescription());
        }
        set.setActiveDate(DateUtils.getDate((String)form.getActiveDate()));
        set.setInactiveDate(DateUtils.getDate((String)form.getInactiveDate()));
        ArrayList<Capability> addList = new ArrayList<Capability>();
        List idList = form.getCapabilityIndList();
        if (idList != null && idList.size() > 0) {
            for (i = 0; i < idList.size(); ++i) {
                selected = form.getCapabilityInd(i);
                if (!Boolean.TRUE.equals(selected)) continue;
                capability = (Capability)this.getLookupCacheService().getByCodeFromCache(Capability.class, form.getCapabilityCode(i));
                addList.add(capability);
            }
        }
        if ((idList = form.getAssignedCapabilityCodeList()) != null && idList.size() > 0) {
            for (i = 0; i < idList.size(); ++i) {
                selected = form.getAssignedCapabilityInd(i);
                capability = (Capability)this.getLookupCacheService().getByCodeFromCache(Capability.class, form.getAssignedCapabilityCode(i));
                if (!Boolean.TRUE.equals(selected)) continue;
                addList.add(capability);
            }
        }
        ArrayList deletedList = new ArrayList(set.getCapabilities());
        deletedList.removeAll(addList);
        Iterator i2 = deletedList.iterator();
        while (i2.hasNext()) {
            set.removeCapability((Capability)i2.next());
        }
        for (int i3 = 0; i3 < addList.size(); ++i3) {
            set.addCapability((Capability)addList.get(i3));
        }
    }

    private List filterRoles(List availableRoles, Set assignedRoles) throws ServiceException {
        UserPrincipal loggedinUser = this.getLoggedInUser();
        HashSet<String> assignedRoleNames = new HashSet<String>();
        ArrayList<ESRRolePrincipalImpl> roles = new ArrayList<ESRRolePrincipalImpl>();
        Iterator i = assignedRoles.iterator();
        while (i.hasNext()) {
            assignedRoleNames.add(((ESRRolePrincipalImpl)i.next()).getName());
        }
        Map rolePermissionMap = this.getUserAdminService().getRolePermissionMap();
        for (ESRRolePrincipalImpl role : availableRoles) {
            String requiredRoleName;
            if (assignedRoleNames.contains(role.getName()) || (requiredRoleName = (String)rolePermissionMap.get(role.getName())) != null && !loggedinUser.isPermissionGranted(requiredRoleName)) continue;
            roles.add(role);
        }
        return roles;
    }

    private List filterCapabilitySets(List availableCapabilitySets, Set assignedCapabilitySets) {
        ArrayList<CapabilitySet> deleteList = new ArrayList<CapabilitySet>();
        Iterator i = assignedCapabilitySets.iterator();
        while (i.hasNext()) {
            String key1 = ((CapabilitySet)i.next()).getEntityKey().getKeyValueAsString();
            for (CapabilitySet deletedSet : availableCapabilitySets) {
                String key2 = deletedSet.getEntityKey().getKeyValueAsString();
                if (!key1.equals(key2)) continue;
                deleteList.add(deletedSet);
            }
        }
        availableCapabilitySets.removeAll(deleteList);
        return availableCapabilitySets;
    }

    private Collection filterById(Collection src, Collection target) {
        Iterator i = src.iterator();
        while (i.hasNext()) {
            AbstractKeyedEntity srcEntity = (AbstractKeyedEntity)i.next();
            String key1 = srcEntity.getEntityKey().getKeyValueAsString();
            for (AbstractKeyedEntity targetEntity : target) {
                String key2 = targetEntity.getEntityKey().getKeyValueAsString();
                if (!key1.equals(key2) || !srcEntity.getClass().equals(targetEntity.getClass())) continue;
                i.remove();
            }
        }
        return src;
    }
}

