/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.model.security.UserCapability;
import gov.va.med.esr.service.UserAdminService;
import gov.va.med.esr.ui.admin.action.AbstractUserProfileAction;
import gov.va.med.esr.ui.admin.action.UserForm;
import gov.va.med.esr.ui.admin.action.UserProfileForm;
import gov.va.med.esr.ui.common.beans.EntityHistory;
import gov.va.med.esr.ui.common.beans.FieldHistoryInfo;
import gov.va.med.esr.ui.common.beans.FormattingTableRow;
import gov.va.med.esr.ui.common.beans.TableRow;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class UserProfileAction
extends AbstractUserProfileAction {
    public static final String EDIT_USER_PROFILE = "editUserProfile";
    public static final String SEARCH_USER_PROFILE = "searchUserProfile";
    public static final String DISPLAY_ALL_USERS = "displayAll";
    public static final String ATT_USER_PROFILE = "USER_PROFILE";
    public static final String MSG_FG_ARE_DIFFERENT = "error.functionalGroupisDifferent";
    public static final String MSG_EMPTY_RESULT_SET = "error.emptyResultSet";
    public static final String MSG_MULTIPLE_RESULTS = "error.multipleResults";
    public static final String ATT_USER_LIST = "USER_LIST";
    public static final String PAR_USER_NAME = "userName";
    public static final String MSG_CAPABILITY_REQUIRES_ROLE = "error.capabilityRequiresRole";
    private UserAdminService userAdminService = null;

    @Override
    public UserAdminService getUserAdminService() {
        return this.userAdminService;
    }

    @Override
    public void setUserAdminService(UserAdminService userAdminService) {
        this.userAdminService = userAdminService;
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearSessionData(request);
        return mapping.findForward(SEARCH_USER_PROFILE);
    }

    public ActionForward displayAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearSessionData(request);
        List list = this.getUserAdminService().findAllUsers();
        request.setAttribute(ATT_USER_LIST, (Object)list);
        return mapping.findForward(DISPLAY_ALL_USERS);
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRUserPrincipalImpl esrUser;
        this.clearSessionData(request);
        String userName = request.getParameter(PAR_USER_NAME);
        if (StringUtils.isNotEmpty((String)userName) && (esrUser = this.getUserAdminService().getUserByName(userName)) != null) {
            this.setPristineEntity(request, esrUser);
            return mapping.findForward(EDIT_USER_PROFILE);
        }
        return this.displayAll(mapping, form, request, response);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserForm userForm = form instanceof UserForm ? (UserForm)form : null;
        Validate.notNull((Object)((Object)userForm), (String)"form is not configured for User Profile Search Action");
        ActionForward forward = null;
        this.clearSessionData(request);
        UserPrincipalImpl user = new UserPrincipalImpl();
        this.convert(userForm, user);
        try {
            ESRUserPrincipalImpl esrUser = this.getUserAdminService().findUser((UserPrincipal)user);
            if (esrUser == null) {
                this.addActionMessage(request, MSG_EMPTY_RESULT_SET);
                forward = mapping.getInputForward();
            } else {
                this.setPristineEntity(request, esrUser);
                forward = mapping.findForward(EDIT_USER_PROFILE);
            }
        }
        catch (MaxRecordsExceededException mre) {
            this.addActionMessage(request, MSG_MULTIPLE_RESULTS);
            forward = mapping.getInputForward();
        }
        return forward;
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRUserPrincipalImpl esrUser = (ESRUserPrincipalImpl)this.getPristineEntity(request);
        this.setUpdatedEntity(request, null);
        if (esrUser == null) {
            return mapping.findForward(SEARCH_USER_PROFILE);
        }
        this.conversionService.convert((Object)esrUser, (Object)form);
        this.populateReferenceData(request);
        AbstractForm absForm = (AbstractForm)form;
        absForm.setReadOnly(!this.isAllowedtoEdit(esrUser));
        return mapping.findForward(EDIT_USER_PROFILE);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserProfileForm userProfileForm = (UserProfileForm)form;
        ESRUserPrincipalImpl pristine = (ESRUserPrincipalImpl)this.getPristineEntity(request);
        ESRUserPrincipalImpl updated = (ESRUserPrincipalImpl)pristine.clone();
        this.conversionService.convert((Object)userProfileForm, (Object)updated);
        this.setUpdatedEntity(request, updated);
        if (this.checkRequiredRoles(request, updated)) {
            return this.confirmation(mapping, form, request, response);
        }
        return this.revise(mapping, form, request, response);
    }

    public ActionForward accept(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)this.getUpdatedEntity(request);
        this.getUserAdminService().updateUserProfile(user);
        this.clearSessionData(request);
        return mapping.findForward("displayUpdateMsg");
    }

    @Override
    public ActionForward revise(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)this.getUpdatedEntity(request);
        this.conversionService.convert((Object)user, (Object)form);
        this.populateReferenceData(request);
        return mapping.findForward(EDIT_USER_PROFILE);
    }

    @Override
    public ActionForward discard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearSessionData(request);
        return mapping.findForward(SEARCH_USER_PROFILE);
    }

    @Override
    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form instanceof UserForm) {
            return super.clear(mapping, form, request, response);
        }
        return this.edit(mapping, form, request, response);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }

    private boolean isAllowedtoEdit(ESRUserPrincipalImpl userProfile) {
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)securityContext.getUserPrincipal();
        FunctionalGroup userProfileFG = userProfile.getFunctionalGroup();
        FunctionalGroup loggedinUserFG = user.getFunctionalGroup();
        VAFacility userProfileFacility = userProfile.getFacility();
        VAFacility loggedinUserFacility = user.getFacility();
        if (this.isPermissionGranted(Capability.EDIT_USER_PROFILE_INFO.getName())) {
            if (this.isPermissionGranted(Capability.ADMINISTRATOR.getName())) {
                return true;
            }
            if (this.isPermissionGranted(Capability.LOCAL_ADMINISTRATOR.getName()) && userProfileFacility != null && loggedinUserFacility != null && userProfileFacility.getCode().equals(loggedinUserFacility.getCode())) {
                return true;
            }
            if (userProfileFG != null && loggedinUserFG != null && loggedinUserFG.getCode().equals(userProfileFG.getCode())) {
                return true;
            }
        }
        return false;
    }

    private void convert(UserForm form, UserPrincipalImpl user) {
        user.setGivenName(form.getGivenName());
        user.setFamilyName(form.getFamilyName());
        if (StringUtils.isNotEmpty((String)form.getMiddleName())) {
            user.setMiddleName(form.getMiddleName());
        }
        if (StringUtils.isNotEmpty((String)form.getName())) {
            user.setName(form.getName());
        }
    }

    protected ActionForward confirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ESRUserPrincipalImpl pristine = (ESRUserPrincipalImpl)this.getPristineEntity(request);
        ESRUserPrincipalImpl current = (ESRUserPrincipalImpl)this.getUpdatedEntity(request);
        ArrayList<FieldHistoryInfo> propList = new ArrayList<FieldHistoryInfo>();
        propList.add(new FieldHistoryInfo("label.userName", current.getFullName(), pristine.getFullName()));
        propList.add(new FieldHistoryInfo("label.functionalGroup", current.getFunctionalGroup() == null ? "" : current.getFunctionalGroup().getDescription(), pristine.getFunctionalGroup() == null ? "" : pristine.getFunctionalGroup().getDescription()));
        List list = this.matchSets(current.getUserRoles(), pristine.getUserRoles());
        propList.addAll(this.processRoles(list));
        list = this.matchSets(current.getCapabilitySets(), pristine.getCapabilitySets());
        propList.addAll(this.processCapabilitySets(list));
        list = this.matchSets(current.getUserCapabilities(), pristine.getUserCapabilities());
        propList.addAll(this.processCapabilities(list));
        request.setAttribute("changeList", propList);
        request.setAttribute("confirmationActionName", (Object)EDIT_USER_PROFILE);
        request.setAttribute("confirmationEntityId", (Object)current.getEntityKey().getKeyValueAsString());
        request.setAttribute("confirmationTitle", (Object)"label.editUserProfile");
        return mapping.findForward("confirm");
    }

    @Override
    protected List processCapabilities(List capabilityList) {
        ArrayList<TableRow> filedHistoryList = new ArrayList<TableRow>();
        if (capabilityList != null && capabilityList.size() > 0) {
            FormattingTableRow infoBean = new FormattingTableRow("label.assignedCapabilities");
            filedHistoryList.add(infoBean);
            for (EntityHistory entityHistory : capabilityList) {
                UserCapability current = (UserCapability)entityHistory.getCurrent();
                UserCapability previous = (UserCapability)entityHistory.getPrevious();
                String curValue = current == null ? "" : current.getCapability().getName();
                String oldValue = previous == null ? "" : previous.getCapability().getName();
                filedHistoryList.add(new FieldHistoryInfo("label.name", curValue, oldValue));
                filedHistoryList.add(new FieldHistoryInfo("label.activeDate", current == null ? "" : DateUtils.format((Date)current.getActiveDate(), null), previous == null ? "" : DateUtils.format((Date)previous.getActiveDate(), null)));
                filedHistoryList.add(new FieldHistoryInfo("label.inactivedate", current == null ? "" : DateUtils.format((Date)current.getInactiveDate(), null), previous == null ? "" : DateUtils.format((Date)previous.getInactiveDate(), null)));
            }
        }
        return filedHistoryList;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.displayAll", DISPLAY_ALL_USERS);
        map.put("button.view", "view");
        map.put("button.update", "update");
        map.put("button.search", "search");
        map.put("button.cancel", "cancel");
        map.put("button.clear", "clear");
        map.put("button.edit", "edit");
        map.put("button.revise", "revise");
        map.put("button.discardChanges", "discard");
        map.put("button.acceptChanges", "accept");
        return map;
    }

    private boolean checkRequiredRoles(HttpServletRequest request, ESRUserPrincipalImpl user) throws Exception {
        boolean valid = true;
        Set assignedCapabilities = user.getCapabilities();
        Set assignedCapabilitySets = user.getCapabilitySets();
        Set assignedRoles = user.getUserRoles();
        HashSet<String> assignedRoleNames = new HashSet<String>();
        for (ESRRolePrincipalImpl role : assignedRoles) {
            assignedCapabilitySets.addAll(role.getCapabilitySets());
            assignedCapabilities.addAll(role.getCapabilities());
            assignedRoleNames.add(role.getName());
        }
        for (CapabilitySet cset : assignedCapabilitySets) {
            assignedCapabilities.addAll(cset.getCapabilities());
        }
        Map capRoleMap = this.getUserAdminService().getCapabilityPermissionMap();
        for (Capability capbility : assignedCapabilities) {
            String requiredRoleName = (String)capRoleMap.get(capbility.getCode());
            if (requiredRoleName == null || assignedRoleNames.contains(requiredRoleName)) continue;
            valid = false;
            this.addActionMessage(request, new ActionMessage(MSG_CAPABILITY_REQUIRES_ROLE, (Object)capbility.getDescription(), (Object)requiredRoleName));
        }
        return valid;
    }

    @Override
    protected void processOptimisticLockException(HttpServletRequest request, ServiceOptimisticLockException ex) throws Exception {
        this.addActionMessage(request, "error.optimisticLock");
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRUserPrincipalImpl esrUser;
        ESRUserPrincipalImpl pristine = (ESRUserPrincipalImpl)this.getPristineEntity(request);
        if (pristine != null && (esrUser = this.getUserAdminService().getUserByName(pristine.getName())) != null) {
            this.setPristineEntity(request, esrUser);
            return this.edit(mapping, form, request, response);
        }
        return this.display(mapping, form, request, response);
    }
}

