/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.ui.admin.action.UserForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.util.NameHelper;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;

public class UserAdminConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof ESRUserPrincipalImpl && target instanceof UserForm) {
            this.convertUserToForm((ESRUserPrincipalImpl)source, (UserForm)((Object)target));
        } else if (target instanceof ESRUserPrincipalImpl && source instanceof UserForm) {
            this.convertFormToUser((UserForm)((Object)source), (ESRUserPrincipalImpl)target);
        } else {
            throw new ConversionServiceException("Can not conver from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    private void convertUserToForm(ESRUserPrincipalImpl user, UserForm form) {
        form.setUserId(user.getEntityKey() == null ? null : user.getEntityKey().getKeyValueAsString());
        form.setName(user.getName());
        form.setGivenName(user.getGivenName());
        form.setFamilyName(user.getFamilyName());
        form.setMiddleName(user.getMiddleName());
        form.setJobTitle(user.getJobTitle());
        form.setFacility(this.getLookupCode((Lookup)user.getFacility()));
        form.setPasswordSuspendDate(DateUtils.format((Date)user.getPasswordSuspendDate(), null));
        form.setPasswordExpireDate(DateUtils.format((Date)user.getPasswordExpireDate(), null));
        form.setPasswordCreationDate(DateUtils.format((Date)user.getPasswordCreateDate(), null));
        form.setAgreementSignatureCode(user.getAgreementSignatureCode());
        form.setPasswordLastChangeDate(DateUtils.formatWithTime((Date)user.getPasswordChangeDate(), null));
        form.setLoginAttempFailureCount(user.getFailAttemptCount());
        form.setLastLoginDate(DateUtils.formatWithTime((Date)user.getSuccessfulLoginDate(), null));
        form.setLoginAttemptFailureDate(DateUtils.formatWithTime((Date)user.getFailedLoginDate(), null));
        form.setAccountLockDate(DateUtils.format((Date)user.getLockDate(), null));
        form.setFunctionalGroup(this.getLookupCode((Lookup)user.getFunctionalGroup()));
    }

    private void convertFormToUser(UserForm form, ESRUserPrincipalImpl user) throws ConversionServiceException {
        user.setGivenName(StringUtils.isBlank((String)form.getGivenName()) ? null : form.getGivenName());
        user.setFamilyName(StringUtils.isBlank((String)form.getFamilyName()) ? null : form.getFamilyName());
        user.setMiddleName(StringUtils.isBlank((String)form.getMiddleName()) ? null : form.getMiddleName());
        String fullName = NameHelper.formatNameLastNameFirst((UserPrincipal)user);
        user.setFullName(StringUtils.isBlank((String)fullName) ? null : fullName);
        user.setJobTitle(StringUtils.isBlank((String)form.getJobTitle()) ? null : form.getJobTitle());
        try {
            if (StringUtils.isNotEmpty((String)form.getFacility())) {
                user.setFacility((VAFacility)this.getLookupCacheService().getByCodeFromCache(VAFacility.class, form.getFacility()));
            } else {
                user.setFacility(null);
            }
            if (StringUtils.isNotEmpty((String)form.getFunctionalGroup())) {
                user.setFunctionalGroup((FunctionalGroup)this.getLookupCacheService().getByCodeFromCache(FunctionalGroup.class, form.getFunctionalGroup()));
            } else {
                user.setFunctionalGroup(null);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException(ex.getMessage(), ex);
        }
        user.setPasswordSuspendDate(DateUtils.getDate((String)form.getPasswordSuspendDate()));
        user.setPasswordExpireDate(DateUtils.getDate((String)form.getPasswordExpireDate()));
        user.setLockDate(DateUtils.getDate((String)form.getAccountLockDate()));
        user.setFailAttemptCount(form.getLoginAttempFailureCount());
    }
}

