/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.ui.admin.action.UserForm;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.security.InvalidPasswordException;
import gov.va.med.fw.security.PasswordChangeNotAllowedException;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.MultipleRecordsFoundException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UserAdminAction
extends AbstractAction {
    public static final String ADD_USER_ACCOUNT = "addUserAccount";
    public static final String EDIT_USER_ACCOUNT = "editUserAccount";
    public static final String VIEW_USER_ACCOUNT = "viewUserAccount";
    public static final String SEARCH_USER_ACCOUNT = "searchUserAccount";
    public static final String USER_ACCOUNT = "userAccount";
    public static final String MSG_NO_PERMISSION_TO_ADD_USER = "error.noPermissionAddUser";
    public static final String MSG_NO_PERMISSION_TO_EDIT_USER = "error.noPermissionEditUser";
    public static final String MSG_USER_ACCOUNT_ADDED = "message.userAccountAdded";
    public static final String MSG_CONST_INAVLID_USERID = "error.invalidUserId";
    public static final String MSG_CONST_MULTIPLE_LDAP_RECORDS_FOUND = "error.multipleRecordsFound";
    public static final String MSG_ACCT_DISABLED = "error.acctDisabled";
    public static final String FLD_CONST_USERID = "name";
    public static final String LABEL_KEY_USERID = "label.userid";
    public static final String MSG_ACCT_NOT_DISABLED = "error.acctNotDisabled";
    private boolean isDataClean = true;

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(SEARCH_USER_ACCOUNT);
    }

    public ActionForward selectUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.searchImpl(mapping, form, request, response, false);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.searchImpl(mapping, form, request, response, true);
    }

    protected ActionForward searchImpl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean performLdapCheck) throws Exception {
        ActionForward forward = null;
        UserForm userForm = (UserForm)form;
        this.setPristineEntity(request, null);
        this.setUpdatedEntity(request, null);
        String userName = userForm.getName();
        if (StringUtils.isEmpty((String)userName)) {
            this.addActionMessageForField(request, "errors.required", this.getMessage(request, LABEL_KEY_USERID), FLD_CONST_USERID);
            return mapping.getInputForward();
        }
        ESRUserPrincipalImpl userPrincipal = null;
        userPrincipal = this.getUserAdminService().getUserByName(userName);
        String[] viewPermissions = new String[]{Capability.ADD_NEW_USER.getName(), Capability.EDIT_USER_ACCOUNT.getName(), Capability.ADD_LOCAL_USER.getName(), Capability.EDIT_LOCAL_USER.getName(), Capability.VIEW_USER_ACCOUNTS.getName()};
        String[] addPermissions = new String[]{Capability.ADD_NEW_USER.getName(), Capability.EDIT_USER_ACCOUNT.getName()};
        String[] addLocalUserPermissions = new String[]{Capability.ADD_LOCAL_USER.getName(), Capability.EDIT_LOCAL_USER.getName()};
        String[] administratorPermissions = new String[]{Capability.LOCAL_ADMINISTRATOR.getName(), Capability.ADMINISTRATOR.getName()};
        try {
            if (userPrincipal != null) {
                boolean validNetworkId = true;
                if (performLdapCheck) {
                    validNetworkId = this.getUserAdminService().isValidNetworkId(userName);
                }
                if (validNetworkId) {
                    if (this.isPermissionGranted(Capability.EDIT_USER_ACCOUNT.getName()) || this.isPermissionGranted(Capability.EDIT_LOCAL_USER.getName()) && this.isAllowedtoEdit(userPrincipal)) {
                        this.conversionService.convert((Object)userPrincipal, (Object)form);
                        this.setPristineEntity(request, userPrincipal);
                        this.setUpdatedEntity(request, null);
                        return mapping.findForward(EDIT_USER_ACCOUNT);
                    }
                    if (this.isAnyPermissionGranted(viewPermissions)) {
                        this.conversionService.convert((Object)userPrincipal, (Object)form);
                        return mapping.findForward(VIEW_USER_ACCOUNT);
                    }
                    this.addActionMessage(request, MSG_NO_PERMISSION_TO_EDIT_USER);
                    return mapping.getInputForward();
                }
                if (this.isPermissionGranted(Capability.DISABLE_USER_ACCOUNT.getName())) {
                    userPrincipal.setInActiveDate(new Date());
                    this.getUserAdminService().updateUserAccount(userPrincipal);
                    this.addActionMessageForField(request, MSG_ACCT_DISABLED, FLD_CONST_USERID);
                } else {
                    this.addActionMessageForField(request, MSG_ACCT_NOT_DISABLED, FLD_CONST_USERID);
                }
                forward = mapping.getInputForward();
            } else {
                userPrincipal = this.getUserAdminService().getLDAPUserInfo(userName);
                if (userPrincipal != null) {
                    if (this.isAnyPermissionGranted(addPermissions) || this.isAnyPermissionGranted(addLocalUserPermissions)) {
                        ESRUserPrincipalImpl currentUser;
                        VAFacility facility;
                        this.conversionService.convert((Object)userPrincipal, (Object)form);
                        if (!this.isAnyPermissionGranted(addPermissions) && (facility = (currentUser = (ESRUserPrincipalImpl)this.getLoggedInUser()).getFacility()) != null) {
                            ((UserForm)form).setFacility(facility.getCode());
                        }
                        forward = mapping.findForward(ADD_USER_ACCOUNT);
                    } else {
                        this.addActionMessage(request, MSG_NO_PERMISSION_TO_ADD_USER);
                        forward = mapping.getInputForward();
                    }
                } else {
                    this.addActionMessageForField(request, MSG_CONST_INAVLID_USERID, FLD_CONST_USERID);
                    forward = mapping.getInputForward();
                }
            }
        }
        catch (MultipleRecordsFoundException mrfe) {
            this.addActionMessageForField(request, MSG_CONST_MULTIPLE_LDAP_RECORDS_FOUND, FLD_CONST_USERID);
            forward = mapping.getInputForward();
        }
        return forward;
    }

    public ActionForward updateUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRUserPrincipalImpl userPrincipal = (ESRUserPrincipalImpl)this.getPristineEntity(request);
        ESRUserPrincipalImpl updatedUser = (ESRUserPrincipalImpl)userPrincipal.clone();
        this.conversionService.convert((Object)form, (Object)updatedUser);
        UserForm userForm = (UserForm)form;
        try {
            if (StringUtils.isNotEmpty((String)userForm.getPassword())) {
                this.getUserAdminService().validatePasswordReuse(userPrincipal, userForm.getPassword());
            }
        }
        catch (PasswordChangeNotAllowedException pe) {
            this.addActionMessage(request, "message.passwordChangein3daysNotallowed");
            userForm.setPassword(null);
            userForm.setConfirmationPassword(null);
            return mapping.getInputForward();
        }
        catch (InvalidPasswordException ipe) {
            this.addActionMessage(request, "message.passwordReuseNotAllowed");
            return mapping.getInputForward();
        }
        if (StringUtils.isNotEmpty((String)userForm.getPassword())) {
            updatedUser.setPassword(this.getUserAdminService().encryptPassword(userForm.getPassword()));
            updatedUser.setPasswordChangeDate(new Date());
            updatedUser.setFailAttemptCount(0);
        }
        this.getUserAdminService().updateUserAccount(updatedUser);
        this.clearSessionData(request);
        return mapping.findForward("displayUpdateMsg");
    }

    public ActionForward addUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserForm userForm = (UserForm)form;
        ActionForward forward = mapping.findForward(USER_ACCOUNT);
        ESRUserPrincipalImpl userPrincipal = new ESRUserPrincipalImpl(userForm.getName(), "{AES}F2MrPlleUOh1119rnpyEYw==");
        this.conversionService.convert((Object)form, (Object)userPrincipal);
        userPrincipal.setPassword(this.getUserAdminService().encryptPassword(userPrincipal.getPassword()));
        this.getUserAdminService().addUserAccount(userPrincipal);
        userPrincipal = this.getUserAdminService().getUserByName(userForm.getName());
        userForm.reset(mapping, request);
        this.conversionService.convert((Object)userPrincipal, (Object)userForm);
        this.addInformationMessage(request, MSG_USER_ACCOUNT_ADDED);
        return forward;
    }

    private boolean isAllowedtoEdit(ESRUserPrincipalImpl userProfile) {
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)securityContext.getUserPrincipal();
        VAFacility userProfileSite = userProfile.getFacility();
        VAFacility userLoggedInSite = user.getFacility();
        if (userProfileSite != null && userLoggedInSite != null) {
            return userProfileSite.getCode().equals(userLoggedInSite.getCode());
        }
        return false;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearSessionData(request);
        ((UserForm)form).initialize();
        return mapping.findForward("cancel");
    }

    public void afterPropertiesSet() throws Exception {
    }

    public boolean isDataClean() {
        return this.isDataClean;
    }

    public void setIsDataClean(boolean isDataClean) {
        this.isDataClean = isDataClean;
    }

    private void clearSessionData(HttpServletRequest request) {
        this.setPristineEntity(request, null);
        this.setUpdatedEntity(request, null);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.update", "updateUser");
        map.put("button.add", "addUser");
        map.put("button.search", "search");
        map.put("button.cancel", "cancel");
        map.put("button.display", "display");
        map.put("button.selectPerson", "selectUser");
        return map;
    }

    @Override
    protected void processOptimisticLockException(HttpServletRequest request, ServiceOptimisticLockException ex) throws Exception {
        this.addActionMessage(request, "error.optimisticLock");
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.search(mapping, form, request, response);
    }
}

