/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.SystemParameterType;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class SystemParametersForm
extends AbstractForm {
    private static final long serialVersionUID = -604038258616661348L;
    public static final String NUMERIC_REG_EXP = "^[\\d]+$";
    public static final String NO_SPCL_CHARS_REG_EXP = "^[0-9,a-z,A-Z]+$";
    public static final String CL_VISTA_ROLLOUT_REG_EXP = "^[0-9,a-z,A-Z,\\,]+$";
    private static final String[] nullableParamValues = new String[]{"Agent Orange Special Treatment Authority Exp Date", "SW Asia Cond. Special Treatment Authority Exp Date"};
    private List id = null;
    private List description = null;
    private List name = null;
    private List type = null;
    private List typeCode = null;
    private List length = null;
    private List unit = null;
    private List value = null;
    private List unitDescription = null;
    private List editable = null;
    private String esrVersion = null;

    public SystemParametersForm() {
        this.initialize();
    }

    public String getEsrVersion() {
        return this.esrVersion;
    }

    public void setEsrVersion(String esrVersion) {
        this.esrVersion = esrVersion;
    }

    public List getIds() {
        return this.id;
    }

    public String getId(int index) {
        return (String)this.id.get(index);
    }

    public String getDescription(int index) {
        return (String)this.description.get(index);
    }

    public String getType(int index) {
        return (String)this.type.get(index);
    }

    public String getTypeCode(int index) {
        return (String)this.typeCode.get(index);
    }

    public String getName(int index) {
        return (String)this.name.get(index);
    }

    public String getLength(int index) {
        return (String)this.length.get(index);
    }

    public String getUnit(int index) {
        return (String)this.unit.get(index);
    }

    public String getValue(int index) {
        return (String)this.value.get(index);
    }

    public void setId(int index, String value) {
        this.setElement(this.id, index, value);
    }

    public void setDescription(int index, String value) {
        this.setElement(this.description, index, value);
    }

    public void setType(int index, String value) {
        this.setElement(this.type, index, value);
    }

    public void setTypeCode(int index, String value) {
        this.setElement(this.typeCode, index, value);
    }

    public void setName(int index, String value) {
        this.setElement(this.name, index, value);
    }

    public void setLength(int index, String value) {
        this.setElement(this.length, index, value);
    }

    public void setUnit(int index, String value) {
        this.setElement(this.unit, index, value);
    }

    public void setValue(int index, String value) {
        this.setElement(this.value, index, value);
    }

    public List getDescriptionList() {
        return this.description;
    }

    public List getIdList() {
        return this.id;
    }

    public List getLengthList() {
        return this.length;
    }

    public List getNameList() {
        return this.name;
    }

    public List getTypeList() {
        return this.type;
    }

    public List getTypeCodeList() {
        return this.typeCode;
    }

    public List getUnitList() {
        return this.unit;
    }

    public List getValueList() {
        return this.value;
    }

    public void setDescriptionList(List description) {
        this.description = description;
    }

    public void setIdList(List id) {
        this.id = id;
    }

    public void setLengthList(List length) {
        this.length = length;
    }

    public void setNameList(List name) {
        this.name = name;
    }

    public void setTypeList(List type) {
        this.type = type;
    }

    public void setTypeCodeList(List type) {
        this.typeCode = type;
    }

    public void setUnitList(List unit) {
        this.unit = unit;
    }

    public void setValueList(List value) {
        this.value = value;
    }

    public String getUnitDescription(int index) {
        return (String)this.unitDescription.get(index);
    }

    public void setUnitDescription(int index, String value) {
        this.setElement(this.unitDescription, index, value);
    }

    public List getUnitDescriptionList() {
        return this.unitDescription;
    }

    public void setUnitDescriptionList(List unitDescription) {
        this.unitDescription = unitDescription;
    }

    public Boolean getEditable(int index) {
        return (Boolean)this.editable.get(index);
    }

    public void setEditable(int index, Boolean value) {
        this.setElement(this.editable, index, value);
    }

    public List getEditableList() {
        return this.editable;
    }

    public void setEditableList(List editable) {
        this.editable = editable;
    }

    public boolean isNoData() {
        return this.id == null || this.id.size() == 0;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.initialize();
    }

    public void add(SystemParameter sysParameter, Boolean editable) {
        this.id.add(sysParameter.getEntityKey() == null ? "" : sysParameter.getEntityKey().getKeyValueAsString());
        this.description.add(sysParameter.getDescription());
        this.name.add(sysParameter.getName());
        this.typeCode.add(sysParameter.getType() == null ? "" : sysParameter.getType().getCode());
        this.type.add(sysParameter.getType() == null ? "" : sysParameter.getType().getDescription());
        this.value.add(sysParameter.getValue());
        this.unit.add(sysParameter.getUnit() == null ? "" : sysParameter.getUnit().getCode());
        this.unitDescription.add(sysParameter.getUnit() == null ? "" : sysParameter.getUnit().getDescription());
        this.length.add(sysParameter.getDataLength() == null ? "" : sysParameter.getDataLength().toString());
        this.editable.add(editable);
    }

    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request) {
        ActionMessages messages = this.getActionMessages(request);
        List sysParameters = this.getValueList();
        List sysParameterUnitList = this.getUnitList();
        for (int i = 0; i < sysParameters.size(); ++i) {
            Date date;
            if (!this.isRequired(this.getName(i), this.getValue(i))) continue;
            String parameterValue = this.getValue(i);
            String parameterType = this.getUnit(i);
            if (StringUtils.isEmpty((String)parameterValue) || parameterValue.trim().length() == 0) {
                messages.add(this.getName(i), new ActionMessage("errors.requiresValue", (Object)this.getName(i)));
                continue;
            }
            String trimmedValue = parameterValue.trim();
            int length = Integer.parseInt(this.getLength(i));
            if (length < trimmedValue.length()) {
                messages.add(this.getName(i), new ActionMessage("errors.maxlength", (Object)this.getName(i), (Object)this.getLength(i)));
                continue;
            }
            if ("7".equalsIgnoreCase(parameterType)) {
                date = null;
                try {
                    date = DateUtils.getDate((String)trimmedValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (date == null) {
                    messages.add(this.getName(i), new ActionMessage("errors.date", (Object)this.getName(i)));
                    continue;
                }
            } else if ("ESR Implementation Date".equals(this.getName(i))) {
                date = null;
                try {
                    date = DateUtils.getDate((String)trimmedValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (date == null) {
                    messages.add(this.getName(i), new ActionMessage("errors.date", (Object)this.getName(i)));
                    continue;
                }
            } else {
                if ("CL_VISTA_FULL_ROLLOUT".equals(this.getName(i)) && !trimmedValue.matches(CL_VISTA_ROLLOUT_REG_EXP)) {
                    messages.add(this.getName(i), new ActionMessage("error.campLejeuneVistARollout", (Object)this.getName(i)));
                    continue;
                }
                if (!trimmedValue.matches(NO_SPCL_CHARS_REG_EXP)) {
                    messages.add(this.getName(i), new ActionMessage("error.specailCharsNotAllowed", (Object)this.getName(i)));
                    continue;
                }
            }
            if (SystemParameterType.CODE_NUMERIC.getName().equals(this.getTypeCode(i)) && !trimmedValue.matches(NUMERIC_REG_EXP)) {
                messages.add(this.getName(i), new ActionMessage("errors.numeric", (Object)this.getName(i)));
                continue;
            }
            if ("IVM DM IY Cut Off Date".equals(this.getName(i))) {
                if (trimmedValue.length() < 4) {
                    messages.add(this.getName(i), new ActionMessage("errors.minlength", (Object)this.getName(i), (Object)"4"));
                    continue;
                }
                if (trimmedValue.matches(NUMERIC_REG_EXP) && this.isValidPartialDate(trimmedValue)) continue;
                messages.add(this.getName(i), new ActionMessage("errors.partialDate", (Object)this.getName(i), (Object)trimmedValue));
                continue;
            }
            if (!"SSA SSN Verification Frequency".equals(this.getName(i)) || !StringUtils.isEmpty((String)((String)sysParameterUnitList.get(i)))) continue;
            messages.add(this.getName(i), new ActionMessage("errors.requiresUnits", (Object)this.getName(i)));
        }
        return messages;
    }

    private boolean isValidPartialDate(String mmdd) {
        String dateString = mmdd.substring(0, 2) + "/" + mmdd.substring(2) + "/" + String.valueOf(DateUtils.getCurrentYear());
        Date date = null;
        try {
            date = DateUtils.getDate((String)dateString);
        }
        catch (Exception e) {
            // empty catch block
        }
        return date != null;
    }

    private void initialize() {
        this.id = new ArrayList();
        this.description = new ArrayList();
        this.name = new ArrayList();
        this.type = new ArrayList();
        this.typeCode = new ArrayList();
        this.length = new ArrayList();
        this.unit = new ArrayList();
        this.value = new ArrayList();
        this.unitDescription = new ArrayList();
        this.editable = new ArrayList();
        this.esrVersion = null;
    }

    private boolean isRequired(String parameterValue, String incomingValue) {
        for (int i = 0; i < nullableParamValues.length; ++i) {
            if (!nullableParamValues[i].equals(parameterValue)) continue;
            return incomingValue != null && !incomingValue.equals("");
        }
        return true;
    }

    private boolean isRequired(String parameterValue) {
        for (int i = 0; i < nullableParamValues.length; ++i) {
            if (!nullableParamValues[i].equals(parameterValue)) continue;
            return false;
        }
        return true;
    }
}

