/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.SystemParameterUnit;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.ui.admin.action.SystemParametersForm;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SystemParametersAction
extends AbstractAction {
    public static final String SYSTEM_PARAMETERS = "systemParameters";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SystemParametersForm sysParForm = (SystemParametersForm)form;
        SystemParameterService systemParameterService = this.getSystemParameterService();
        List systemParameters = null;
        systemParameters = systemParameterService.findAll();
        String esrVersion = systemParameterService.getEsrVersion();
        if (systemParameters != null && systemParameters.size() > 0) {
            Collections.sort(systemParameters);
            sysParForm.reset(mapping, request);
            this.convert(systemParameters, sysParForm);
        }
        sysParForm.setEsrVersion(esrVersion);
        return mapping.findForward(SYSTEM_PARAMETERS);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.display(mapping, form, request, response);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SystemParametersForm sysParForm = (SystemParametersForm)form;
        List systemParameters = null;
        systemParameters = this.getSystemParameterService().findAll();
        this.convert(sysParForm, systemParameters);
        HashSet updatedParameters = new HashSet();
        updatedParameters.addAll(systemParameters);
        this.getSystemParameterService().save(updatedParameters);
        return mapping.findForward("displayUpdateMsg");
    }

    private void convert(List systemParameters, SystemParametersForm form) {
        HashSet grantedPermissions = new HashSet(this.getGrantedPermissions());
        Map requiredPermissions = SystemParameter.getCapabilityMap();
        boolean sysAdmin = false;
        if (grantedPermissions.contains(Capability.SYSTEM_ADMINISTRATOR.getCode())) {
            sysAdmin = true;
        }
        for (int i = 0; i < systemParameters.size(); ++i) {
            SystemParameter sysPar = (SystemParameter)systemParameters.get(i);
            String code = (String)requiredPermissions.get(sysPar.getName());
            if (sysAdmin && (code == null || grantedPermissions.contains(code))) {
                form.add(sysPar, Boolean.TRUE);
                continue;
            }
            form.add(sysPar, Boolean.FALSE);
        }
    }

    private void convert(SystemParametersForm form, List systemParameters) throws ServiceException {
        int i;
        HashMap<String, SystemParameter> map = new HashMap<String, SystemParameter>();
        for (i = 0; i < systemParameters.size(); ++i) {
            SystemParameter sysPar = (SystemParameter)systemParameters.get(i);
            map.put(sysPar.getName(), sysPar);
        }
        for (i = 0; i < systemParameters.size(); ++i) {
            String sourceValue;
            String targetValue;
            String sourceUnit;
            String name = form.getName(i);
            SystemParameter target = (SystemParameter)map.get(name);
            if (target == null) {
                throw new ServiceException("System Parameter Not found to update " + name);
            }
            String targetUnit = target.getUnit() == null ? "" : target.getUnit().getCode();
            if (!StringUtils.equals((String)targetUnit, (String)(sourceUnit = form.getUnit(i)))) {
                try {
                    SystemParameterUnit unit = (SystemParameterUnit)this.getLookupCacheService().getByCodeFromCache(SystemParameterUnit.class, sourceUnit);
                    target.setUnit(unit);
                }
                catch (Exception e) {
                    throw new ServiceException("Lookup Failed: " + e.getMessage(), (Throwable)e);
                }
            }
            if ((targetValue = target.getValue()).equals(sourceValue = form.getValue(i))) continue;
            target.setValue(sourceValue);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.update", "update");
        map.put("button.cancel", "cancel");
        map.put("button.reset", "reset");
        map.put("button.display", "display");
        return map;
    }
}

