/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.security.EEServiceRequestLite;
import gov.va.med.esr.common.model.security.EEServiceUser;
import gov.va.med.esr.common.model.security.EEServiceUserRequest;
import gov.va.med.esr.ui.admin.action.ServiceUserForm;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.util.EdbStrutsValidator;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ServiceUserAction
extends AbstractAction {
    public static final String FORWARD_DISPLAY_LIST_SUCCESS = "listsuccess";
    public static final String USER_SAVED = "message.serviceUserAdded";
    public static final String USER_UPDATED = "message.serviceUserUpdated";
    public static final String FORWARD_DISPLAY_EDIT = "displayEdit";
    public static final String FORWARD_DISPLAY_NEW = "displayNew";
    public static final String REQUIRED = "errors.required";
    public static final String LABEL_KEY_USERNAME = "Account Name";
    public static final String LABEL_KEY_PASSWORD = "Password";
    public static final String LABEL_KEY_CONTACTNAME = "Contact Name";
    public static final String LABEL_KEY_CONTACTPHONE = "Phone";
    public static final String FIELD_UNIQUE = "error.uniquename";
    public static final String PASSWORD_NOT_VALID = "message.changePassword.password";
    public static final String MASKED_PASSWORD = "************";

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List serviceUsers = this.getEeServiceAdminService().getEEServiceUsers();
        if (serviceUsers != null && !serviceUsers.isEmpty()) {
            request.setAttribute("serviceUsers", (Object)serviceUsers);
        }
        return mapping.findForward(FORWARD_DISPLAY_LIST_SUCCESS);
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceUserForm serviceUserForm = (ServiceUserForm)form;
        String userId = serviceUserForm.getUserId();
        EntityKey key = EntityKeyFactory.createEntityKey((String)userId, EEServiceUser.class);
        EEServiceUser serviceUser = this.getEeServiceAdminService().getEEserviceUser(key);
        serviceUserForm.clearForm();
        serviceUserForm.setUserId(serviceUser.getIdentifier().toString());
        serviceUserForm.setUserName(serviceUser.getUserName());
        serviceUserForm.setPassword(MASKED_PASSWORD);
        serviceUserForm.setContactName(serviceUser.getContactName());
        serviceUserForm.setContactPhone(serviceUser.getContactPhone());
        serviceUserForm.setActive(serviceUser.getActive());
        List requests = this.getEeServiceAdminService().getEEServiceLiteRequests();
        serviceUserForm.setRequestList(requests);
        serviceUserForm.setSelectedRequestMap(serviceUser.getEeServiceUserRequests());
        return mapping.findForward(FORWARD_DISPLAY_EDIT);
    }

    public ActionForward saveUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isFormValid = this.validateForm(mapping, form, request, response);
        ServiceUserForm serviceUserForm = (ServiceUserForm)form;
        EEServiceUser eeServiceUser = null;
        if (!isFormValid) {
            return mapping.findForward(FORWARD_DISPLAY_EDIT);
        }
        if (eeServiceUser == null) {
            eeServiceUser = new EEServiceUser();
        }
        eeServiceUser.setUserName(serviceUserForm.getUserName().trim());
        eeServiceUser.setContactName(serviceUserForm.getContactName().trim());
        eeServiceUser.setContactPhone(serviceUserForm.getContactPhone().trim());
        if (!MASKED_PASSWORD.equals(serviceUserForm.getPassword().trim())) {
            eeServiceUser.setPassword(serviceUserForm.getPassword().trim());
        }
        eeServiceUser.setActive(serviceUserForm.isActive());
        String[] selectedRequest = serviceUserForm.getSelectedRequests();
        List requests = this.getEeServiceAdminService().getEEServiceLiteRequests();
        if (selectedRequest != null && selectedRequest.length > 0) {
            for (int index = 0; index < selectedRequest.length; ++index) {
                if (requests == null && requests.size() <= 0) continue;
                for (EEServiceRequestLite req : requests) {
                    if (!req.getEntityKey().getKeyValueAsString().equals(selectedRequest[index].toString())) continue;
                    eeServiceUser.addEEServiceUserRequest(req);
                }
            }
        }
        this.getEeServiceAdminService().saveEEServiceUser(eeServiceUser);
        this.addInformationMessage(request, USER_SAVED);
        serviceUserForm.setSelectedRequestMap(eeServiceUser.getEeServiceUserRequests());
        return this.list(mapping, form, request, response);
    }

    public ActionForward updateUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isFormValid = this.validateForm(mapping, form, request, response);
        ServiceUserForm serviceUserForm = (ServiceUserForm)form;
        String userId = serviceUserForm.getUserId();
        EntityKey key = EntityKeyFactory.createEntityKey((String)userId, EEServiceUser.class);
        EEServiceUser eeServiceUser = this.getEeServiceAdminService().getEEserviceUser(key);
        if (!isFormValid) {
            return mapping.findForward(FORWARD_DISPLAY_EDIT);
        }
        if (eeServiceUser == null) {
            eeServiceUser = new EEServiceUser();
        }
        eeServiceUser.setUserName(serviceUserForm.getUserName().trim());
        eeServiceUser.setContactName(serviceUserForm.getContactName().trim());
        eeServiceUser.setContactPhone(serviceUserForm.getContactPhone().trim());
        if (!MASKED_PASSWORD.equals(serviceUserForm.getPassword().trim())) {
            eeServiceUser.setPassword(serviceUserForm.getPassword());
        }
        eeServiceUser.setActive(serviceUserForm.isActive());
        List requests = this.getEeServiceAdminService().getEEServiceLiteRequests();
        HashSet<EEServiceRequestLite> newRequests = new HashSet<EEServiceRequestLite>();
        String[] selectedRequest = serviceUserForm.getSelectedRequests();
        if (selectedRequest != null && selectedRequest.length > 0) {
            for (int index = 0; index < selectedRequest.length; ++index) {
                if (requests == null && requests.size() <= 0) continue;
                for (EEServiceRequestLite req : requests) {
                    if (!req.getEntityKey().getKeyValueAsString().equals(selectedRequest[index].toString())) continue;
                    newRequests.add(req);
                }
            }
        }
        Set existingRequest = eeServiceUser.getEeServiceUserRequests();
        HashSet<EEServiceUserRequest> removeRequest = new HashSet<EEServiceUserRequest>();
        if (existingRequest != null && existingRequest.size() > 0) {
            for (EEServiceUserRequest existingUserReq : existingRequest) {
                EEServiceRequestLite req = existingUserReq.getEeServiceRequestLite();
                if (newRequests.contains(req)) continue;
                removeRequest.add(existingUserReq);
            }
        }
        eeServiceUser.removeRequests(removeRequest);
        if (newRequests != null && newRequests.size() > 0) {
            for (EEServiceRequestLite newRequest : newRequests) {
                eeServiceUser.addEEServiceUserRequest(newRequest);
            }
        }
        this.getEeServiceAdminService().saveEEServiceUser(eeServiceUser);
        this.addInformationMessage(request, USER_UPDATED);
        serviceUserForm.setSelectedRequestMap(eeServiceUser.getEeServiceUserRequests());
        return this.list(mapping, form, request, response);
    }

    private boolean validateForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceUserForm serviceUserForm = (ServiceUserForm)form;
        boolean valid = true;
        if (serviceUserForm.getUserName() == null || serviceUserForm.getUserName().length() <= 0) {
            this.addActionMessage(request, REQUIRED, LABEL_KEY_USERNAME);
            valid = false;
        }
        if (serviceUserForm.getUserId() != null && serviceUserForm.getUserName() != null) {
            EEServiceUser eeServiceUser = this.getEeServiceAdminService().getEEServiceUser(serviceUserForm.getUserName());
            if (eeServiceUser != null) {
                if (!eeServiceUser.getIdentifier().toString().equals(serviceUserForm.getUserId())) {
                    this.addActionMessage(request, FIELD_UNIQUE, LABEL_KEY_USERNAME);
                    valid = false;
                }
                String newPassword = serviceUserForm.getPassword();
                if (serviceUserForm.getPassword() == null || serviceUserForm.getPassword().length() <= 0) {
                    this.addActionMessage(request, REQUIRED, LABEL_KEY_PASSWORD);
                    valid = false;
                } else if (newPassword != null && !MASKED_PASSWORD.equals(newPassword) && !eeServiceUser.getPassword().equals(newPassword)) {
                    if (!EdbStrutsValidator.validatePassword(newPassword)) {
                        this.addActionMessage(request, PASSWORD_NOT_VALID, LABEL_KEY_PASSWORD);
                        valid = false;
                    } else {
                        String encryptedNewPassword = this.getPasswordEncryptionService().encryptPassword(newPassword);
                        serviceUserForm.setPassword(encryptedNewPassword);
                    }
                }
            } else {
                String newPassword = serviceUserForm.getPassword();
                if (serviceUserForm.getPassword() == null || serviceUserForm.getPassword().length() <= 0) {
                    this.addActionMessage(request, REQUIRED, LABEL_KEY_PASSWORD);
                    valid = false;
                } else if (newPassword != null && !EdbStrutsValidator.validatePassword(newPassword)) {
                    this.addActionMessage(request, PASSWORD_NOT_VALID, LABEL_KEY_PASSWORD);
                    valid = false;
                } else {
                    String encryptedNewPassword = this.getPasswordEncryptionService().encryptPassword(newPassword);
                    serviceUserForm.setPassword(encryptedNewPassword);
                }
            }
        }
        if (serviceUserForm.getContactName() == null || serviceUserForm.getContactName().length() <= 0) {
            this.addActionMessage(request, REQUIRED, LABEL_KEY_CONTACTNAME);
            valid = false;
        }
        if (serviceUserForm.getContactPhone() == null || serviceUserForm.getContactPhone().length() <= 0) {
            this.addActionMessage(request, REQUIRED, LABEL_KEY_CONTACTPHONE);
            valid = false;
        }
        return valid;
    }

    public ActionForward displayNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceUserForm serviceUserForm = (ServiceUserForm)form;
        serviceUserForm.clearForm();
        List requests = this.getEeServiceAdminService().getEEServiceLiteRequests();
        serviceUserForm.setRequestList(requests);
        EEServiceUser serviceUser = new EEServiceUser();
        return mapping.findForward(FORWARD_DISPLAY_NEW);
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceUserForm serviceUserForm = (ServiceUserForm)form;
        String userId = serviceUserForm.getUserId();
        if (userId == null || userId.trim().length() <= 0) {
            return this.displayNew(mapping, form, request, response);
        }
        return this.display(mapping, form, request, response);
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.eeserviceUser.update", "updateUser");
        map.put("button.eeserviceUser.add", "saveUser");
        map.put("button.eeserviceUser.cancel", "list");
        map.put("button.eeserviceUser.list", "list");
        map.put("button.eeserviceUser.reset", "reset");
        map.put("button.eeserviceUser.display", "display");
        map.put("button.eeserviceUser.displayNew", FORWARD_DISPLAY_NEW);
        return map;
    }
}

