/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import com.jenkov.prizetags.tree.impl.Tree;
import com.jenkov.prizetags.tree.impl.TreeNode;
import com.jenkov.prizetags.tree.impl.TreeUpdater;
import com.jenkov.prizetags.tree.itf.ISelectListener;
import com.jenkov.prizetags.tree.itf.ITree;
import com.jenkov.prizetags.tree.itf.ITreeNode;
import com.jenkov.prizetags.tree.itf.IUnSelectListener;
import gov.va.med.esr.common.model.lookup.EEServiceField;
import gov.va.med.esr.common.model.lookup.EEServiceFieldLite;
import gov.va.med.esr.common.model.lookup.EEServiceGroup;
import gov.va.med.esr.common.model.security.EEServiceRequest;
import gov.va.med.esr.common.model.security.EEServiceRequestField;
import gov.va.med.esr.common.model.security.EEServiceRequestLite;
import gov.va.med.esr.ui.admin.action.ServiceRequestForm;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.util.TreeNodeSelectListener;
import gov.va.med.esr.ui.util.TreeNodeUnSelectListener;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ServiceRequestAction
extends AbstractAction {
    public static final String GROUP_TYPE = "GROUP";
    public static final String FIELD_TYPE = "FIELD";
    public static final String FORWARD_DISPLAY_EDIT = "displayEdit";
    public static final String FORWARD_DISPLAY_NEW = "displayNew";
    public static final String FORWARD_DISPLAY_LIST_SUCCESS = "listsuccess";
    public static final String REQUIRED = "errors.required";
    public static final String LABEL_KEY_REQNAME = "label.eeServiceRequest.header.name";
    public static final String LABEL_KEY_REQDESC = "label.eeServiceRequest.header.description";
    public static final String FIELD_UNIQUE = "error.uniquename";
    public static final String FIELD_REQ_NAME = "Request Name";
    public static final String FIELD_REQ_DESC = "Description";
    public static final String REQUEST_SAVED = "message.request.saved";
    public static final String ROOT_GROUP = "eeSummary";

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List serviceRequests = this.getEeServiceAdminService().getEEServiceLiteRequests();
        if (serviceRequests != null && !serviceRequests.isEmpty()) {
            request.setAttribute("serviceRequests", (Object)serviceRequests);
        }
        return mapping.findForward(FORWARD_DISPLAY_LIST_SUCCESS);
    }

    public ActionForward CancelSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.list(mapping, form, request, response);
    }

    public ActionForward displayNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceRequestForm serviceRequestForm = (ServiceRequestForm)form;
        serviceRequestForm.reset();
        EEServiceRequestLite serviceRequest = new EEServiceRequestLite();
        ITree tree = this.createTreeFromServiceRequest(serviceRequest);
        TreeUpdater treeUpdater = new TreeUpdater(request, tree);
        treeUpdater.update();
        request.getSession(true).setAttribute("tree.model", (Object)tree);
        return mapping.findForward(FORWARD_DISPLAY_NEW);
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceRequestForm serviceRequestForm = (ServiceRequestForm)form;
        String requestId = serviceRequestForm.getRequestId();
        EntityKey key = EntityKeyFactory.createEntityKey((String)requestId, EEServiceRequest.class);
        EEServiceRequestLite serviceRequest = this.getEeServiceAdminService().getEEserviceRequestLite(key);
        serviceRequestForm.setName(serviceRequest.getName());
        serviceRequestForm.setDescription(serviceRequest.getDescription());
        ITree tree = this.createTreeFromServiceRequest(serviceRequest);
        TreeUpdater treeUpdater = new TreeUpdater(request, tree);
        treeUpdater.update();
        request.getSession(true).setAttribute("tree.model", (Object)tree);
        return mapping.findForward(FORWARD_DISPLAY_EDIT);
    }

    public ActionForward refreshTree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ITree tree = (ITree)request.getSession(true).getAttribute("tree.model");
        TreeUpdater treeUpdater = new TreeUpdater(request, tree);
        treeUpdater.update();
        request.setAttribute("serviceRequestForm", (Object)form);
        return mapping.findForward(FORWARD_DISPLAY_EDIT);
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceRequestForm serviceRequestForm = (ServiceRequestForm)form;
        String requestId = serviceRequestForm.getRequestId();
        if (requestId == null || requestId.trim().length() <= 0) {
            return this.displayNew(mapping, form, request, response);
        }
        return this.display(mapping, form, request, response);
    }

    public ActionForward saveRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EEServiceRequestLite eeRequestOther;
        boolean isFormValid = this.validateForm(mapping, form, request, response);
        ServiceRequestForm serviceRequestForm = (ServiceRequestForm)form;
        if (serviceRequestForm.getName() != null && (eeRequestOther = this.getEeServiceAdminService().getEEServicerequestLiteByName(serviceRequestForm.getName())) != null) {
            if (serviceRequestForm.getRequestId() != null) {
                if (!eeRequestOther.getIdentifier().toString().equals(serviceRequestForm.getRequestId())) {
                    this.addActionMessageForField(request, FIELD_UNIQUE, FIELD_REQ_NAME);
                    isFormValid = false;
                }
            } else {
                this.addActionMessageForField(request, FIELD_UNIQUE, FIELD_REQ_NAME);
                isFormValid = false;
            }
        }
        if (!isFormValid) {
            return mapping.findForward(FORWARD_DISPLAY_EDIT);
        }
        String requestId = serviceRequestForm.getRequestId();
        EEServiceRequest eeRequest = null;
        if (requestId != null && requestId.trim().length() > 0) {
            EntityKey key = EntityKeyFactory.createEntityKey((String)serviceRequestForm.getRequestId(), EEServiceRequest.class);
            eeRequest = this.getEeServiceAdminService().getEEserviceRequest(key);
        } else {
            eeRequest = new EEServiceRequest();
        }
        eeRequest.setName(serviceRequestForm.getName().trim());
        eeRequest.setDescription(serviceRequestForm.getDescription().trim());
        ITree tree = (ITree)request.getSession(true).getAttribute("tree.model");
        Set selectedNodes = tree.getSelectedNodes();
        HashSet<EEServiceRequestField> newFields = new HashSet<EEServiceRequestField>();
        if (selectedNodes != null && selectedNodes.size() > 0) {
            for (ITreeNode node : selectedNodes) {
                if (!node.getType().equals(FIELD_TYPE)) continue;
                EEServiceRequestField reqField = new EEServiceRequestField();
                EEServiceFieldLite field = (EEServiceFieldLite)this.getLookupCacheService().getByCodeFromCache(EEServiceFieldLite.class, node.getName());
                reqField.setEeServiceField(field);
                newFields.add(reqField);
            }
        }
        Set existingFields = eeRequest.getEeServiceFields();
        HashSet<EEServiceRequestField> removeFields = new HashSet<EEServiceRequestField>();
        if (existingFields != null && existingFields.size() > 0) {
            for (EEServiceRequestField existingReqField : existingFields) {
                if (newFields.contains(existingReqField)) continue;
                removeFields.add(existingReqField);
            }
        }
        eeRequest.removeFields(removeFields);
        if (newFields != null && newFields.size() > 0) {
            for (EEServiceRequestField newField : newFields) {
                eeRequest.addField(newField);
            }
        }
        this.getEeServiceAdminService().saveEEServiceRequest(eeRequest);
        this.addInformationMessage(request, REQUEST_SAVED);
        return this.list(mapping, form, request, response);
    }

    private boolean validateForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceRequestForm serviceRequestForm = (ServiceRequestForm)form;
        boolean valid = true;
        if (serviceRequestForm.getName() == null || serviceRequestForm.getName().length() <= 0) {
            this.addActionMessage(request, REQUIRED, FIELD_REQ_NAME);
            valid = false;
        }
        if (serviceRequestForm.getDescription() == null || serviceRequestForm.getDescription().length() <= 0) {
            this.addActionMessage(request, REQUIRED, FIELD_REQ_DESC);
            valid = false;
        }
        return valid;
    }

    private ITree createTreeFromServiceRequest(EEServiceRequestLite serviceRequest) throws Exception {
        EEServiceGroup rootGroup = (EEServiceGroup)this.getLookupCacheService().getByCodeFromCache(EEServiceGroup.class, ROOT_GROUP);
        Set selectedFields = new HashSet();
        if (serviceRequest.getEntityKey() != null) {
            selectedFields = this.getEeServiceAdminService().getEEServiceRequestFieldsByRequest(serviceRequest.getEntityKey());
        }
        Tree tree = new Tree();
        TreeNode root = new TreeNode(rootGroup.getCode(), rootGroup.getCode(), GROUP_TYPE);
        root.setToolTip(rootGroup.getDescription());
        tree.setRoot((ITreeNode)root);
        boolean allGroupsSelected = this.addChildGroups(rootGroup.getChildGroups(), (ITreeNode)root, selectedFields, (ITree)tree);
        boolean allFieldsSelected = this.addFields(rootGroup.getFields(), (ITreeNode)root, selectedFields, (ITree)tree);
        if (allGroupsSelected && allFieldsSelected) {
            tree.select(root.getId());
        }
        tree.addSelectListener((ISelectListener)new TreeNodeSelectListener());
        tree.addUnSelectListener((IUnSelectListener)new TreeNodeUnSelectListener());
        return tree;
    }

    private boolean addFields(Set fields, ITreeNode treeNode, Set selectedFields, ITree tree) {
        if (fields == null) {
            return true;
        }
        Iterator itr = fields.iterator();
        boolean allSelected = true;
        while (itr != null && itr.hasNext()) {
            EEServiceField serviceField = (EEServiceField)itr.next();
            TreeNode fieldNode = new TreeNode(serviceField.getCode(), serviceField.getCode(), FIELD_TYPE);
            fieldNode.setToolTip(serviceField.getDescription());
            treeNode.addChild((ITreeNode)fieldNode);
            if (selectedFields == null) continue;
            if (selectedFields.contains(serviceField.getCode())) {
                tree.select(fieldNode.getId());
                continue;
            }
            allSelected = false;
        }
        return allSelected;
    }

    private boolean addChildGroups(Set childGroups, ITreeNode treeNode, Set selectedFields, ITree tree) {
        if (childGroups == null) {
            return true;
        }
        Iterator itr = childGroups.iterator();
        boolean allSelected = true;
        while (itr != null && itr.hasNext()) {
            EEServiceGroup childGroup = (EEServiceGroup)itr.next();
            TreeNode childGroupNode = new TreeNode(childGroup.getCode(), childGroup.getCode(), GROUP_TYPE);
            childGroupNode.setToolTip(childGroup.getDescription());
            boolean fieldsSlected = this.addFields(childGroup.getFields(), (ITreeNode)childGroupNode, selectedFields, tree);
            boolean groupsSlected = this.addChildGroups(childGroup.getChildGroups(), (ITreeNode)childGroupNode, selectedFields, tree);
            if (fieldsSlected && groupsSlected && (childGroup.getChildGroups() != null && childGroup.getChildGroups().size() > 0 || childGroup.getFields() != null && childGroup.getFields().size() > 0)) {
                tree.select(childGroupNode.getId());
            }
            if (!fieldsSlected || !groupsSlected) {
                allSelected = false;
            }
            treeNode.addChild((ITreeNode)childGroupNode);
        }
        return allSelected;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.eeservicerequest.save", "saveRequest");
        map.put("button.eeservicerequest.add", "saveRequest");
        map.put("button.eeservicerequest.update", "saveRequest");
        map.put("button.eeservicerequest.Cancel", "CancelSave");
        map.put("button.eeservicerequest.list", "list");
        map.put("button.eeservicerequest.display", "display");
        map.put("button.eeservicerequest.displayNew", FORWARD_DISPLAY_NEW);
        map.put("button.eeservicerequest.refreshTree", "refreshTree");
        map.put("button.eeservicerequest.reset", "reset");
        return map;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

