/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.ApplicationMethod;
import gov.va.med.esr.common.model.lookup.ApplicationStatus;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.service.IdmServiceVO;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.ui.admin.action.SearchActionForm;
import gov.va.med.esr.ui.admin.beans.VeteranSearchBean;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.esr.ui.util.MockPersonBuilder;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.InvalidArgumentValueListException;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.ui.valuelist.MissingCapabilityValueListException;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.TimeoutValueListException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class SearchAction
extends PersonAbstractAction {
    public static final String USE_MOCK_DEBUG_FLAG = "ui.use.mock.person";
    public static final String CREATE_MOCK_DEBUG_FLAG = "ui.create.mock.person";
    public static final String ADDAPERSON_INFO_MESSAGE = "message.addAPersonInfo";
    private MockPersonBuilder mockPersonBuilder = null;
    public static final String PERSON_OVERVIEW = "overview";
    public static final String FORWARD_DISPLAY_NEW = "displayNew";
    public static final String FORWARD_DISPLAY_STATUS_HISTORY = "displayStatusHistory";
    public static final String USA = "USA";

    public void afterPropertiesSet() throws Exception {
        if (this.getMockPersonBuilder() == null && log.isWarnEnabled()) {
            log.warn((Object)"Mock person builder is not set.  This should be set when using the mock debug flag.");
        }
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchActionForm searchForm = (SearchActionForm)form;
        searchForm.clear();
        this.putSandboxEntry(request, "addAPerson", new Boolean(false));
        return mapping.findForward("success");
    }

    public ActionForward saveInProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean isAddAPerson = SessionManager.isAddAPerson(request);
            if (!isAddAPerson) {
                return mapping.findForward(PERSON_OVERVIEW);
            }
            SearchActionForm searchForm = form instanceof SearchActionForm ? (SearchActionForm)form : null;
            Validate.notNull((Object)((Object)searchForm), (String)"SearchActionForm bean is null");
            Person person = this.getSelectedPerson(request);
            this.getApplicationInProcessService().savePersonInProcess(person, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.IN_PROCESS.getCode()));
        }
        catch (Exception e) {
            this.addActionMessage(request, "error.addPerson", e.toString());
            this.logger.error((Object)e.toString());
        }
        return mapping.findForward(PERSON_OVERVIEW);
    }

    public ActionForward cancelRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean isAddAPerson = SessionManager.isAddAPerson(request);
            if (isAddAPerson) {
                SearchActionForm searchForm = form instanceof SearchActionForm ? (SearchActionForm)form : null;
                Validate.notNull((Object)((Object)searchForm), (String)"SearchActionForm bean is null");
                Person person = this.getSelectedPerson(request);
                this.removeSelectedPerson(request);
                searchForm.clear();
                searchForm.setAddButtonDisabled(true);
                this.getApplicationInProcessService().savePersonInProcess(person, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.CANCEL.getCode()));
            }
        }
        catch (Exception e) {
            this.addActionMessage(request, "error.addPerson", e.toString());
            this.logger.error((Object)e.toString());
        }
        return mapping.findForward(FORWARD_DISPLAY_NEW);
    }

    public ActionForward displayNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchActionForm searchForm = (SearchActionForm)form;
        searchForm.setAddButtonDisabled(true);
        searchForm.clear();
        Boolean isSigiAvailable = super.getSystemParameterService().getEsSidIndicator();
        searchForm.setDisableSelfIdentifiedGenderIdentity(isSigiAvailable);
        this.putSandboxEntry(request, "addAPerson", new Boolean(true));
        this.removeSelectedPerson(request);
        return mapping.findForward(FORWARD_DISPLAY_NEW);
    }

    public ActionForward displayStatusHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchActionForm searchForm = (SearchActionForm)form;
        searchForm.clear();
        ActionForward forward = mapping.findForward(FORWARD_DISPLAY_STATUS_HISTORY);
        Person person = this.getSelectedPerson(request);
        if (person == null) {
            this.addActionMessage(request, "error.addPerson", "Person not selected for displaying status history!");
            forward = mapping.findForward("failure");
        } else {
            String vpidVaue = person.getVPIDEntityKey().getShortVPID();
            EnrollmentApplication ea = this.getApplicationInProcessService().getEnrollmentApplicationByIcn(vpidVaue);
            UIConversionService uiConversionService = (UIConversionService)this.conversionService;
            uiConversionService.convert(ea, (Object)searchForm);
        }
        return forward;
    }

    public ActionForward addNewPersonScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person;
        SearchActionForm searchForm = form instanceof SearchActionForm ? (SearchActionForm)form : null;
        Validate.notNull((Object)((Object)searchForm), (String)"SearchActionForm bean is null");
        if (this.isTokenValid(request)) {
            this.resetToken(request);
            IdmServiceVO idmServiceVO = null;
            person = null;
            VPIDEntityKey vpid = null;
            try {
                ValueList valueList = ValueListActionUtils.getValueList((ActionForm)searchForm, (HttpServletRequest)request, (String)"personSearchTableId", (String)"personSearchAdapter");
                List results = valueList.getList();
                if (results != null && !results.isEmpty()) {
                    for (VeteranSearchBean veteranBean : results) {
                        if (!veteranBean.getIdmMatchTypeValue().equals("Yes")) continue;
                        vpid = CommonEntityKeyFactory.createVPIDEntityKey((String)veteranBean.getVpid());
                    }
                }
                idmServiceVO = this.createIdmServiceVO((SearchActionForm)form);
                if (vpid == null) {
                    vpid = this.getPersonService().addPerson(idmServiceVO);
                } else {
                    person = this.convertIdmServiceVOToPerson(idmServiceVO, vpid);
                    this.getPersonService().addESRCorrelation(person);
                }
                person = this.convertIdmServiceVOToPerson(idmServiceVO, vpid);
                PersonIdEntityKey personKey = this.getPersonService().getPersonIdByVPID(vpid);
                if (personKey == null) {
                    throw new ServiceException("Unable to getPerson Id by vpid added by idmService: " + vpid.getKeyValueAsString());
                }
                person.setIdentifier(personKey.getKeyValue());
                this.addDefaultValues(person, (SearchActionForm)form);
                this.getApplicationInProcessService().savePersonInProcess(person, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.NEW_APPLICATION.getCode()));
            }
            catch (ValidationServiceException ex) {
                ValidationMessages mesg = ex.getValidationMessages();
                Iterator mesgItr = mesg.get();
                while (mesgItr.hasNext()) {
                    ValidationMessage msgObj = (ValidationMessage)mesgItr.next();
                    this.addActionMessage(request, new ActionMessage(msgObj.getKey()));
                }
            }
        } else {
            searchForm.setAddButtonDisabled(true);
            this.putSandboxEntry(request, "addAPerson", new Boolean(true));
            this.removeSelectedPerson(request);
            this.addActionMessage(request, "error.duplicateAddPerson");
            return mapping.findForward(FORWARD_DISPLAY_NEW);
        }
        this.setSelectedPerson(request, person);
        return mapping.findForward(PERSON_OVERVIEW);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        SearchActionForm searchForm = form instanceof SearchActionForm ? (SearchActionForm)form : null;
        Validate.notNull((Object)((Object)searchForm), (String)"SearchActionForm bean is null");
        boolean isAddAPerson = SessionManager.isAddAPerson(request);
        searchForm.setAddAPerson(isAddAPerson);
        try {
            if (SearchAction.isMockPersonRetrieveEnabled()) {
                this.retrievePerson(searchForm.getFamilyName(), request);
                return mapping.findForward(PERSON_OVERVIEW);
            }
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)searchForm, (HttpServletRequest)request, (String)"personSearchTableId", (String)"personSearchAdapter");
            ValueListInfo info = valueList.getValueListInfo();
            if (info.getTotalNumberOfEntries() == 0) {
                searchForm.setAddButtonDisabled(false);
                this.saveToken(request);
                this.addActionMessage(request, new ActionMessage("errors.search.noresult"));
                forward = SessionManager.isAddAPerson(request) ? mapping.findForward(FORWARD_DISPLAY_NEW) : mapping.findForward("failure");
            } else {
                List results = valueList.getList();
                boolean toDisable = false;
                if (results != null && !results.isEmpty()) {
                    for (VeteranSearchBean veteranBean : results) {
                        if (!veteranBean.getIdmMatchTypeValue().equals("Yes")) continue;
                        toDisable = true;
                    }
                }
                searchForm.setAddButtonDisabled(false);
                if (!toDisable) {
                    this.saveToken(request);
                }
                if (info.getTotalNumberOfEntries() == 1) {
                    VeteranSearchBean veteranBean = (VeteranSearchBean)results.get(0);
                    PersonIdentityTraits traits = this.getSelectedTraits(request);
                    if (!veteranBean.isPersonLocked() && !SessionManager.isAddAPerson(request)) {
                        this.retrievePerson(veteranBean.getPersonID(), request, traits);
                        forward = mapping.findForward(PERSON_OVERVIEW);
                    }
                }
                if (forward == null) {
                    ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
                    if (SessionManager.isAddAPerson(request)) {
                        searchForm.setAddButtonDisabled(toDisable);
                        forward = mapping.findForward(FORWARD_DISPLAY_NEW);
                    } else {
                        forward = mapping.findForward("success");
                    }
                }
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            if (ex.getTotalRecords() > 0 && ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
            } else if (ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded.recordLimit", (Object)new Integer(ex.getRecordLimit())));
            } else {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded.noParams"));
            }
            forward = mapping.findForward("failure");
        }
        catch (MissingCapabilityValueListException ex) {
            this.addActionMessage(request, new ActionMessage("errors.invalid.search.permission"));
            forward = mapping.findForward("failure");
        }
        catch (TimeoutValueListException ex) {
            this.addActionMessage(request, "error.timeout");
            forward = mapping.findForward("failure");
        }
        catch (InvalidArgumentValueListException ex) {
            this.addActionMessage(request, "error.invalid.parameter.combination");
            forward = mapping.findForward("failure");
        }
        return forward;
    }

    public ActionForward selectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchActionForm searchForm = form instanceof SearchActionForm ? (SearchActionForm)form : null;
        Validate.notNull((Object)((Object)searchForm), (String)"SearchActionForm bean is null.");
        boolean isAddAPerson = SessionManager.isAddAPerson(request);
        if (!isAddAPerson) {
            String personId = searchForm.getSelectedPersonId();
            Validate.notNull((Object)personId, (String)"Selected person Id is null.");
            this.retrievePerson(searchForm.getSelectedPersonId(), request);
            String forwardTo = request.getParameter("forwardTo");
            return StringUtils.isNotEmpty((String)forwardTo) ? mapping.findForward(forwardTo) : mapping.findForward(PERSON_OVERVIEW);
        }
        return this.selectForAddAPerson(mapping, searchForm, request, response);
    }

    private ActionForward selectForAddAPerson(ActionMapping mapping, SearchActionForm searchForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String longVpid = searchForm.getSelectedVpid();
        String shortVpid = VPIDEntityKeyImpl.getShortVPID((String)longVpid);
        Validate.notNull((Object)shortVpid, (String)"Selected short vpidValue is null.");
        Person sessionPerson = null;
        Person esrPerson = this.getESRPersonByVPID(longVpid);
        EnrollmentDetermination enrollDet = esrPerson == null ? null : esrPerson.getEnrollmentDetermination();
        Person inProcessPerson = this.getApplicationInProcessService().getInProcessPersonByIcn(shortVpid);
        Person idmSearchResultPerson = null;
        if (esrPerson == null || enrollDet == null && inProcessPerson == null) {
            idmSearchResultPerson = this.createPersonFromSearchResult(request, shortVpid);
        }
        ActionForward forward = mapping.findForward(PERSON_OVERVIEW);
        boolean shouldDisableAddPerson = false;
        if (esrPerson != null) {
            this.getPersonService().addESRCorrelation(esrPerson);
            if (inProcessPerson != null) {
                sessionPerson = inProcessPerson;
                if (enrollDet != null) {
                    this.getApplicationInProcessService().savePersonInProcess(inProcessPerson, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.CANCEL.getCode()));
                    this.addInformationMessage(request, ADDAPERSON_INFO_MESSAGE);
                    sessionPerson = esrPerson;
                    shouldDisableAddPerson = true;
                }
            } else {
                List appStatusList = this.getApplicationInProcessService().getApplicationStatusesByIcn(shortVpid);
                boolean isRegistrationCompleted = this.getApplicationInProcessService().existsRecordWithStatus(appStatusList, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.COMPLETE.getCode()));
                if (isRegistrationCompleted) {
                    sessionPerson = esrPerson;
                    shouldDisableAddPerson = true;
                } else if (enrollDet != null) {
                    sessionPerson = esrPerson;
                    shouldDisableAddPerson = true;
                } else {
                    sessionPerson = idmSearchResultPerson;
                    sessionPerson.setIdentifier(esrPerson.getEntityKey().getKeyValue());
                    this.getApplicationInProcessService().savePersonInProcess(sessionPerson, this.getLookupService().getApplicationStatusByCode(ApplicationStatus.NEW_APPLICATION.getCode()));
                    sessionPerson.setPersonLockedReason(null);
                    this.putSandboxEntry(request, "addAPerson", new Boolean(true));
                }
            }
        } else {
            sessionPerson = idmSearchResultPerson;
            this.getApplicationInProcessService().processAddPersonStubAndSaveInProcess(sessionPerson);
            sessionPerson.setPersonLockedReason(null);
            this.putSandboxEntry(request, "addAPerson", new Boolean(true));
        }
        this.savePersonToSession(sessionPerson, request);
        if (shouldDisableAddPerson) {
            this.putSandboxEntry(request, "addAPerson", new Boolean(false));
        }
        return forward;
    }

    public void retrievePerson(String personIdString, HttpServletRequest request) throws Exception {
        this.retrievePerson(personIdString, request, null);
    }

    private void retrievePerson(String personIdString, HttpServletRequest request, PersonIdentityTraits traits) throws Exception {
        Person person = null;
        if (SearchAction.isMockPersonRetrieveEnabled()) {
            person = this.getMockupPerson(personIdString);
        } else {
            PersonIdEntityKey entityKey = CommonEntityKeyFactory.createPersonIdEntityKey((String)personIdString);
            person = this.getPersonService().getPerson((PersonEntityKey)entityKey, traits);
            person.setOpenCasesCount(this.getWorkflowService().getOpenCasesCount(person.getPersonEntityKey()));
        }
        this.savePersonToSession(person, request);
    }

    private void savePersonToSession(Person person, HttpServletRequest request) {
        SessionManager.removeVeteranHeaderBean(request);
        SessionManager.removeMessageList(request);
        SessionManager.removeSelectedFinancialIncomeYear(request);
        SessionManager.removeQRYZ07FacilityList(request);
        this.setSelectedPerson(request, person);
    }

    private Person getESRPersonByVPID(String vpid) throws ServiceException {
        Person person = null;
        PersonIdEntityKey entityKey = null;
        VPIDEntityKey vpidEntity = CommonEntityKeyFactory.createVPIDEntityKey((String)vpid);
        entityKey = this.getPersonService().getPersonIdByVPID(vpidEntity);
        if (entityKey != null) {
            person = this.getPersonService().getPerson((PersonEntityKey)entityKey);
            person.setOpenCasesCount(this.getWorkflowService().getOpenCasesCount(person.getPersonEntityKey()));
        }
        return person;
    }

    private Person createPersonFromSearchResult(HttpServletRequest request, String vpid) throws ServiceException {
        String tableId = "personSearchTableId";
        List resultVetList = SearchValueListAdapter.getResultsFromSession((HttpSession)request.getSession(), (String)(tableId + SearchValueListAdapter.RESULTS_KEY));
        VeteranSearchBean vetBean2 = null;
        for (VeteranSearchBean vetBean2 : resultVetList) {
            if (vetBean2.getVpid() == null) continue;
            String shortVpid = new String(vetBean2.getVpid());
            if (!(shortVpid = shortVpid.substring(6, 23)).equals(vpid)) continue;
            try {
                IdmServiceVO idmServiceVo = this.createIdmServiceVO(vetBean2);
                VPIDEntityKey vpidEntity = CommonEntityKeyFactory.createVPIDEntityKey((String)VPIDEntityKeyImpl.getLongVPID((String)vpid));
                return this.convertIdmServiceVOToPerson(idmServiceVo, vpidEntity);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to convert VeteranSearchBean to Person: " + vetBean2 + ", shortVpid = " + vpid);
            }
        }
        throw new ServiceException("Add a Person Select Person: No row in search result matches vpid: " + vpid + ". resultVetList = " + resultVetList);
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchActionForm searchForm = (SearchActionForm)form;
        searchForm.clear();
        if (SessionManager.isAddAPerson(request)) {
            searchForm.setAddButtonDisabled(true);
        }
        return SessionManager.isAddAPerson(request) ? mapping.findForward(FORWARD_DISPLAY_NEW) : mapping.findForward("failure");
    }

    public ActionForward research(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.search(mapping, form, request, response);
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.search(mapping, form, request, response);
    }

    public ActionForward addNewPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAddAPerson = SessionManager.isAddAPerson(request);
        if (!isAddAPerson) {
            this.addActionMessage(request, "error.addPerson", "Please use Search and Add New Person Screen.");
            return mapping.findForward(PERSON_OVERVIEW);
        }
        Person incoming = this.getSelectedPerson(request);
        if (incoming == null) {
            this.addActionMessage(request, new ActionMessage("error.noPersonFound"));
            return mapping.findForward(PERSON_OVERVIEW);
        }
        if (!this.ValidateFormForMinField(request, incoming)) {
            return mapping.findForward(PERSON_OVERVIEW);
        }
        Person incomingPersonClone = (Person)incoming.clone();
        Person onFile = this.getApplicationInProcessService().processCompleteRegistration(incomingPersonClone);
        if (onFile == null) {
            this.addActionMessage(request, "error.resubmitCompleteRegistration");
            return mapping.findForward(PERSON_OVERVIEW);
        }
        try {
            if (this.isValidQueryInfo(incomingPersonClone)) {
                MessagingService messagingService = this.getMessagingService();
                messagingService.processTriggerBroker(incomingPersonClone);
            } else {
                this.logger.error((Object)("Query Info is not valid for processTriggerBroker for Person with VPID:" + incoming.getVPIDValue()));
            }
            this.addInformationMessage(request, "message.personAdded");
            onFile.setIdentityTraits(incoming.getIdentityTraits());
            this.setSelectedPerson(request, onFile);
            this.putSandboxEntry(request, "addAPerson", new Boolean(false));
            return mapping.findForward(PERSON_OVERVIEW);
        }
        catch (ValidationServiceException ex) {
            ValidationMessages mesg = ex.getValidationMessages();
            Iterator mesgItr = mesg.get();
            while (mesgItr.hasNext()) {
                ValidationMessage msgObj = (ValidationMessage)mesgItr.next();
                this.addActionMessage(request, new ActionMessage(msgObj.getKey()));
            }
            return mapping.findForward(PERSON_OVERVIEW);
        }
    }

    public boolean ValidateFormForMinField(HttpServletRequest request, Person person) {
        boolean valid = true;
        if (person.getNames() == null) {
            this.addActionMessage(request, "error.firstNameRequired");
            valid = false;
        }
        if (person.getBirthRecord() == null || person.getBirthRecord().getBirthDate() == null) {
            this.addActionMessage(request, "error.dateOfBirthRequired");
            valid = false;
        }
        if (person.getBirthRecord() == null || StringUtils.isBlank((String)person.getBirthRecord().getCity())) {
            this.addActionMessage(request, "error.placeOfBirthRequired");
            valid = false;
        }
        if (person.getBirthRecord() == null || StringUtils.isBlank((String)person.getBirthRecord().getState())) {
            this.addActionMessage(request, "error.stateOfBirthRequired");
            valid = false;
        }
        if (person.getGender() == null) {
            this.addActionMessage(request, "error.birthSexRequired");
            valid = false;
        }
        if (person.getIdentityTraits().getSsnText() == null) {
            this.addActionMessage(request, "error.ssnRequired");
            valid = false;
        } else if (!this.isValidSSN(request, person)) {
            valid = false;
        }
        if (person.getPreferredFacilities().isEmpty()) {
            this.addActionMessage(request, "error.preferredFacilityRequired");
            valid = false;
        }
        if (person.getMaritalStatus() == null) {
            this.addActionMessage(request, "error.maritalStatusRequired");
            valid = false;
        }
        if (person.getAddresses() == null || person.getAddresses().size() < 1) {
            this.addActionMessage(request, "error.addressRequired");
            valid = false;
        }
        if (person.getPermanentAddress() == null) {
            this.addActionMessage(request, "error.addressRequired");
            valid = false;
        }
        if (person.getApplication() == null || person.getApplication().getApplicationDate() == null) {
            this.addActionMessage(request, "error.applicationDateRequired");
            valid = false;
        }
        if (person.getVeteran() == null) {
            this.addActionMessage(request, "error.veteranIndicatorRequired");
            valid = false;
        }
        if (person.getEligibilityVerification() == null || person.getEligibilityVerification().getEligibilityStatus() == null) {
            this.addActionMessage(request, "error.eligibilityStatusRequired");
            valid = false;
        }
        return valid;
    }

    private boolean isValidSSN(HttpServletRequest request, Person person) {
        boolean valid = true;
        String ssn = person.getIdentityTraits().getSsnText().replaceAll("-", "");
        if (ssn.startsWith("00000") || ssn.startsWith("000") || ssn.endsWith("0000") || ssn.substring(3, 5).equals("00") || ssn.equals("111111111") || ssn.equals("222222222") || ssn.equals("333333333") || ssn.equals("444444444") || ssn.equals("555555555") || ssn.equals("666666666") || ssn.equals("777777777") || ssn.equals("888888888") || ssn.equals("999999999") || ssn.equals("123456789")) {
            this.addActionMessage(request, "error.ssnInvalid");
            valid = false;
        }
        return valid;
    }

    private void setMultipleBirth(Person person, String setYes) {
        BirthRecord birthRecord = person.getBirthRecord();
        if (setYes == null || setYes.equalsIgnoreCase("nd")) {
            if (birthRecord != null) {
                birthRecord.setMultipleBirth(null);
            }
        } else {
            if (birthRecord == null) {
                birthRecord = new BirthRecord();
            }
            birthRecord.setMultipleBirth(ConvertUtils.convertBoolean(setYes));
            person.setBirthRecord(birthRecord);
        }
    }

    private IdmServiceVO createIdmServiceVO(SearchActionForm form) throws Exception {
        String country;
        IdmServiceVO idmServiceVO = new IdmServiceVO();
        Name lName = new Name();
        String prefixName = "";
        lName.setGivenName(form.getGivenName() != null ? form.getGivenName() : "");
        lName.setMiddleName(form.getMiddleName() != null ? form.getMiddleName() : "");
        lName.setFamilyName(form.getFamilyName() != null ? form.getFamilyName() : "");
        lName.setType(this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName()));
        HashSet<Name> names = new HashSet<Name>();
        names.add(lName);
        idmServiceVO.setNames(names);
        BirthRecord br = new BirthRecord();
        br.setBirthDate(new ImpreciseDate(form.getDateOfBirth()));
        idmServiceVO.setBirthRecord(br);
        Gender gender = this.getLookupService().getGenderByCode(form.getGender());
        idmServiceVO.setGender(gender);
        Address permAddress = new Address();
        permAddress.setLine1(form.getAddressLine1());
        permAddress.setLine2("");
        permAddress.setLine3("");
        permAddress.setCity(form.getCity() != null ? form.getCity() : "");
        permAddress.setState(form.getState() != null ? form.getState() : "");
        permAddress.setZipCode(form.getZipCode() != null ? form.getZipCode() : "");
        permAddress.setPostalCode(form.getPostalCode() != null ? form.getPostalCode() : "");
        String string = country = form.getCountry() != null ? form.getCountry() : "";
        if (StringUtils.isEmpty((String)country)) {
            country = USA;
        }
        permAddress.setCountry(country);
        permAddress.setPhoneNumber(form.getHomePhoneNumber() != null ? form.getHomePhoneNumber() : "");
        permAddress.setType(this.getLookupService().getAddressTypeByCode("P"));
        idmServiceVO.addAddress(permAddress);
        SSN ssN = new SSN();
        ssN.setSsnText(form.getSsn());
        idmServiceVO.setSsn(ssN);
        return idmServiceVO;
    }

    private IdmServiceVO createIdmServiceVO(VeteranSearchBean bean) throws Exception {
        String country;
        IdmServiceVO idmServiceVO = new IdmServiceVO();
        Name lName = new Name();
        lName.setGivenName(bean.getFirstName() != null ? bean.getFirstName() : "");
        lName.setMiddleName(bean.getMiddleName() != null ? bean.getMiddleName() : "");
        lName.setFamilyName(bean.getLastName() != null ? bean.getLastName() : "");
        lName.setType(this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName()));
        HashSet<Name> names = new HashSet<Name>();
        names.add(lName);
        idmServiceVO.setNames(names);
        BirthRecord br = new BirthRecord();
        br.setBirthDate(new ImpreciseDate(bean.getDateOfBirth()));
        idmServiceVO.setBirthRecord(br);
        idmServiceVO.setGender(bean.getGender());
        Address permAddress = new Address();
        permAddress.setLine1(bean.getAddress());
        permAddress.setLine2("");
        permAddress.setLine3("");
        permAddress.setCity(bean.getCity() != null ? bean.getCity() : "");
        permAddress.setState(bean.getState() != null ? bean.getState() : "");
        permAddress.setZipCode(bean.getZipCode() != null ? bean.getZipCode() : "");
        permAddress.setPostalCode(bean.getPostalCode() != null ? bean.getPostalCode() : "");
        String string = country = bean.getCountry() != null ? bean.getCountry() : "";
        if (StringUtils.isEmpty((String)country)) {
            country = USA;
        }
        permAddress.setCountry(country);
        permAddress.setPhoneNumber(bean.getHomePhoneNumber() != null ? bean.getHomePhoneNumber() : "");
        permAddress.setType(this.getLookupService().getAddressTypeByCode("P"));
        idmServiceVO.addAddress(permAddress);
        SSN ssN = new SSN();
        ssN.setSsnText(bean.getSsn());
        idmServiceVO.setSsn(ssN);
        return idmServiceVO;
    }

    private Person convertIdmServiceVOToPerson(IdmServiceVO idmServiceVO, VPIDEntityKey vpid) throws ServiceException {
        if (vpid == null) {
            return null;
        }
        Person target = new Person(vpid);
        target.addName(idmServiceVO.getLegalName());
        BirthRecord dob = idmServiceVO.getBirthRecord();
        target.setBirthRecord(dob);
        target.setGender(idmServiceVO.getGender());
        SSN ssn = idmServiceVO.getSsn();
        ssn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getName()));
        target.addSsn(idmServiceVO.getSsn());
        target.setIdmMatchType(idmServiceVO.getIdmMatchType());
        Application application = new Application();
        application.setPerson(target);
        application.setAppliactionMethod(this.getLookupService().getApplicationMethodByCode(ApplicationMethod.IN_PERSON.getCode()));
        target.setApplication(application);
        return target;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.displayNew", FORWARD_DISPLAY_NEW);
        map.put("button.displayStatusHistory", FORWARD_DISPLAY_STATUS_HISTORY);
        map.put("button.completeRegistration", "addNewPerson");
        map.put("button.saveInProcess", "saveInProcess");
        map.put("button.cancelRegistration", "cancelRegistration");
        map.put("button.searchAddAPerson", "searchAddAPerson");
        map.put("button.add", "addNewPersonScreen");
        map.put("button.search", "search");
        map.put("button.research", "research");
        map.put("button.clear", "clear");
        map.put("button.refresh", "refresh");
        map.put("button.cancel", "clear");
        map.put("button.selectPerson", "selectPerson");
        return map;
    }

    @Override
    protected boolean requiresSelectedPerson() {
        return false;
    }

    public static boolean isMockPersonRetrieveEnabled() {
        return System.getProperty(USE_MOCK_DEBUG_FLAG) != null;
    }

    public static boolean isMockPersonCreateEnabled() {
        return System.getProperty(CREATE_MOCK_DEBUG_FLAG) != null;
    }

    public Person getMockupPerson(String personId) throws Exception {
        if (SearchAction.isMockPersonCreateEnabled()) {
            this.getMockPersonBuilder().createPersonInDB();
        }
        return this.getMockPersonBuilder().getPerson(personId);
    }

    public MockPersonBuilder getMockPersonBuilder() {
        return this.mockPersonBuilder;
    }

    public void setMockPersonBuilder(MockPersonBuilder mockPersonBuilder) {
        this.mockPersonBuilder = mockPersonBuilder;
    }

    private void addDefaultValues(Person person, SearchActionForm form) {
        this.addAddressToPerson(person, form);
        this.setEligibility(person);
        this.setSSAStatus(person);
    }

    private String setAddressField(String fieldValue) {
        if (fieldValue == null || fieldValue.length() == 0) {
            return "";
        }
        return fieldValue;
    }

    private void addAddressToPerson(Person person, SearchActionForm form) {
        String country;
        Address address = new Address();
        String string = country = form.getCountry() != null ? form.getCountry() : "";
        if (StringUtils.isEmpty((String)country)) {
            country = USA;
        }
        address.setCountry(this.setAddressField(country));
        int validFields = 0;
        if (StringUtils.isNotEmpty((String)form.getAddressLine1())) {
            ++validFields;
        }
        address.setLine1(this.setAddressField(form.getAddressLine1()));
        if (StringUtils.isNotEmpty((String)form.getCity())) {
            ++validFields;
        }
        address.setCity(this.setAddressField(form.getCity()));
        if (StringUtils.isNotEmpty((String)form.getState())) {
            ++validFields;
        }
        address.setState(this.setAddressField(form.getState()));
        if (StringUtils.isNotEmpty((String)form.getZipCode())) {
            ++validFields;
        }
        address.setZipCode(this.setAddressField(form.getZipCode()));
        if (StringUtils.isNotEmpty((String)form.getZipPlus4())) {
            ++validFields;
        }
        address.setZipPlus4(this.setAddressField(form.getZipPlus4()));
        if (StringUtils.isNotEmpty((String)form.getCounty())) {
            ++validFields;
        }
        address.setCounty(this.setAddressField(form.getCounty()));
        if (StringUtils.isNotEmpty((String)form.getHomePhoneNumber())) {
            ++validFields;
        }
        address.setPhoneNumber(this.setAddressField(form.getHomePhoneNumber()));
        try {
            String countryCode = country;
            if (StringUtils.isNotEmpty((String)countryCode)) {
                Country newCountry = this.getLookupService().getCountryByCode(countryCode);
                String countryShortName = newCountry.getShortName();
                Country countryObject = new Country();
                countryObject.setShortName(countryShortName);
                address.setCountryObject(countryObject);
            }
            address.setType(this.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode()));
            String homePhone = form.getHomePhoneNumber();
            if (StringUtils.isNotEmpty((String)homePhone)) {
                Phone phone = new Phone();
                phone.setType(this.getLookupService().getPhoneTypeByCode(PhoneType.CODE_HOME.getName()));
                phone.setPhoneNumber(homePhone);
                person.addPhone(phone);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (validFields > 0) {
            person.addAddress(address);
        }
    }

    private void setSSAStatus(Person person) {
        SSAVerificationStatus ssnNew = new SSAVerificationStatus();
        try {
            ssnNew = this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.NEW_RECORD.getCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        person.getIdentityTraits().getSsn().setSsaVerificationStatus(ssnNew);
    }

    private void setEligibility(Person person) {
        person.setVeteran(Boolean.TRUE);
        EligibilityVerification ev = new EligibilityVerification();
        try {
            ev.setEligibilityStatus(this.getLookupService().getEligibilityStatusByCode(EligibilityStatus.CODE_PENDING_VERIFICATION.getCode()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        person.setEligibilityVerification(ev);
    }

    private boolean isValidQueryInfo(Person person) {
        if (this.passedNullValidation(person)) {
            return !this.invalidQuery(person);
        }
        return false;
    }

    private boolean invalidQuery(Person person) {
        return person.getIdentityTraits().getLegalName().getGivenName() == null || person.getIdentityTraits().getLegalName().getGivenName().length() == 0 || person.getIdentityTraits().getLegalName().getGivenName().trim().length() == 0 || person.getIdentityTraits().getSsnText() == null || person.getIdentityTraits().getSsnText().length() == 0 || person.getIdentityTraits().getSsnText().trim().length() == 0 || person.getIdentityTraits().getLegalName().getFamilyName() == null || person.getIdentityTraits().getLegalName().getFamilyName().length() == 0 || person.getIdentityTraits().getLegalName().getFamilyName().trim().length() == 0 || person.getIdentityTraits().getGender().getCode() == null || person.getIdentityTraits().getGender().getCode().length() == 0 || person.getIdentityTraits().getGender().getCode().trim().length() == 0 || person.getIdentityTraits().getBirthRecord().getBirthDate() == null;
    }

    public boolean passedNullValidation(Person person) {
        return person.getIdentityTraits() != null && person.getIdentityTraits().getLegalName() != null && person.getGender() != null && person.getBirthRecord() != null;
    }
}

