/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.ui.admin.action.AbstractUserProfileAction;
import gov.va.med.esr.ui.admin.action.RoleForm;
import gov.va.med.esr.ui.common.beans.FieldHistoryInfo;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.security.RolePrincipal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RolesAction
extends AbstractUserProfileAction {
    public static final String FWD_DISPLAY_ROLES = "displayRoles";
    public static final String FWD_EDIT = "editRole";
    public static final String FWD_CONFIRM = "confirm";
    public static final String PAR_ROLE_ID = "roleId";
    public static final String ATTR_ROLES = "Roles";
    public static final String ATTR_DELETED_ROLES = "DeletedRoles";
    public static final String MSG_ASSIGNED_CAN_NOT_BE_DELETED = "error.roleisAssigned";
    public static final String MSG_ROLE_REQUIRES = "error.roleRequires";
    public static final String MSG_ROLE_NAME_DUPLICATE = "error.roleNameDuplicate";
    public static final String FIELD_NAME = "name";
    public static final String MSG_ACTIVE_DATE_INVALID = "error.activeDate";
    public static final String FLD_ACTIVE_DATE = "activeDate";
    public static final String FLD_INACTIVE_DATE = "inactiveDate";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearSessionData(request);
        List allRoles = this.getUserAdminService().getAllRoles();
        Collections.sort(allRoles);
        List deletedRoles = this.getUserAdminService().findDeletedRoles();
        Collections.sort(deletedRoles);
        request.setAttribute(ATTR_ROLES, (Object)allRoles);
        request.setAttribute(ATTR_DELETED_ROLES, (Object)deletedRoles);
        return mapping.findForward(FWD_DISPLAY_ROLES);
    }

    public ActionForward addNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleForm roleForm = (RoleForm)form;
        roleForm.setAvailableCapabilities(this.getUserAdminService().getAllCapabilities());
        roleForm.setAvailableCapabilitySets(this.getUserAdminService().getAllCapabilitySets());
        this.populateReferenceData(request);
        return mapping.findForward(FWD_EDIT);
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String roleId = request.getParameter(PAR_ROLE_ID);
        Validate.notNull((Object)roleId, (String)"Role Id can not be null");
        EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(roleId), ESRRolePrincipalImpl.class);
        ESRRolePrincipalImpl role = (ESRRolePrincipalImpl)this.getUserAdminService().getRoleById(entityKey);
        this.setPristineEntity(request, role);
        this.conversionService.convert((Object)role, (Object)form);
        this.populateReferenceData(request);
        return mapping.findForward(FWD_EDIT);
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String roleName = ((RoleForm)form).getName().trim();
        if (this.getUserAdminService().getRoleByName(roleName) != null) {
            this.addActionMessageForField(request, MSG_ROLE_NAME_DUPLICATE, FIELD_NAME);
            return mapping.getInputForward();
        }
        ESRRolePrincipalImpl newRole = new ESRRolePrincipalImpl();
        this.conversionService.convert((Object)form, (Object)newRole);
        this.setPristineEntity(request, null);
        this.setUpdatedEntity(request, newRole);
        if (this.isValid(request, newRole)) {
            return this.confirmation(mapping, form, request, response);
        }
        return mapping.getInputForward();
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String roleId = request.getParameter(PAR_ROLE_ID);
        Validate.notNull((Object)roleId, (String)"Role Id can not be null");
        EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(roleId), ESRRolePrincipalImpl.class);
        ESRRolePrincipalImpl role = (ESRRolePrincipalImpl)this.getUserAdminService().getRoleById(entityKey);
        if (Boolean.TRUE.equals(role.getAssigned())) {
            this.addActionMessage(request, MSG_ASSIGNED_CAN_NOT_BE_DELETED);
            return mapping.getInputForward();
        }
        this.getUserAdminService().deleteRole((RolePrincipal)role);
        return mapping.findForward("displayDeleteMsg");
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleForm roleForm = (RoleForm)form;
        ESRRolePrincipalImpl pristine = (ESRRolePrincipalImpl)this.getPristineEntity(request);
        ESRRolePrincipalImpl updated = (ESRRolePrincipalImpl)pristine.clone();
        this.conversionService.convert((Object)roleForm, (Object)updated);
        this.setUpdatedEntity(request, updated);
        if (this.isValid(request, updated)) {
            return this.confirmation(mapping, form, request, response);
        }
        return mapping.getInputForward();
    }

    public ActionForward accept(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRRolePrincipalImpl role = (ESRRolePrincipalImpl)this.getUpdatedEntity(request);
        if (role.getEntityKey() == null) {
            this.getUserAdminService().addRole((RolePrincipal)role);
            return mapping.findForward("displayAddMessage");
        }
        this.getUserAdminService().updateRole((RolePrincipal)role);
        return mapping.findForward("displayUpdateMsg");
    }

    @Override
    public ActionForward revise(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ESRRolePrincipalImpl role = (ESRRolePrincipalImpl)this.getUpdatedEntity(request);
        this.conversionService.convert((Object)role, (Object)form);
        return mapping.findForward(FWD_EDIT);
    }

    @Override
    public ActionForward discard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FWD_DISPLAY_ROLES);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }

    private boolean isValid(HttpServletRequest request, ESRRolePrincipalImpl role) {
        boolean valid = true;
        Date current = DateUtils.getCurrentDate();
        Date prevActiveDate = null;
        Date prevInactiveDate = null;
        if (role.getEntityKey() != null) {
            ESRRolePrincipalImpl pristine = (ESRRolePrincipalImpl)this.getPristineEntity(request);
            prevActiveDate = pristine.getActiveDate();
            prevInactiveDate = pristine.getInactiveDate();
        }
        if (role.getActiveDate() != null && !role.getActiveDate().equals(prevActiveDate) && role.getActiveDate().before(current)) {
            valid = false;
            this.addActionMessageForField(request, "error.activeDatePast", FLD_ACTIVE_DATE);
        }
        if (role.getInactiveDate() != null && !role.getInactiveDate().equals(prevInactiveDate) && role.getInactiveDate().before(current)) {
            valid = false;
            this.addActionMessageForField(request, "error.inactiveDatePast", FLD_INACTIVE_DATE);
        }
        if (role.getActiveDate() != null && role.getInactiveDate() != null && role.getActiveDate().after(role.getInactiveDate())) {
            valid = false;
            this.addActionMessageForField(request, MSG_ACTIVE_DATE_INVALID, FLD_ACTIVE_DATE);
            this.addActionMessageForField(request, MSG_ACTIVE_DATE_INVALID, FLD_INACTIVE_DATE);
        }
        return valid;
    }

    protected ActionForward confirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ESRRolePrincipalImpl pristine = (ESRRolePrincipalImpl)this.getPristineEntity(request);
        ESRRolePrincipalImpl current = (ESRRolePrincipalImpl)this.getUpdatedEntity(request);
        ArrayList<FieldHistoryInfo> propList = new ArrayList<FieldHistoryInfo>();
        propList.add(new FieldHistoryInfo("label.name", current == null ? "" : current.getName(), pristine == null ? "" : pristine.getName()));
        propList.add(new FieldHistoryInfo("label.description", current == null ? "" : current.getDescription(), pristine == null ? "" : pristine.getDescription()));
        propList.add(new FieldHistoryInfo("label.activeDate", current == null ? "" : DateUtils.format((Date)current.getActiveDate(), null), pristine == null ? "" : DateUtils.format((Date)pristine.getActiveDate(), null)));
        propList.add(new FieldHistoryInfo("label.inactivedate", current == null ? "" : DateUtils.format((Date)current.getInactiveDate(), null), pristine == null ? "" : DateUtils.format((Date)pristine.getInactiveDate(), null)));
        List list = this.matchSets(current.getCapabilitySets(), pristine == null ? null : pristine.getCapabilitySets());
        propList.addAll(this.processCapabilitySets(list));
        list = this.matchSets(current.getCapabilities(), pristine == null ? null : pristine.getCapabilities());
        propList.addAll(this.processCapabilities(list));
        request.setAttribute("changeList", propList);
        request.setAttribute("confirmationActionName", (Object)FWD_EDIT);
        request.setAttribute("confirmationEntityId", (Object)(pristine == null ? "" : pristine.getEntityKey().getKeyValueAsString()));
        if (pristine == null) {
            request.setAttribute("confirmationTitle", (Object)"label.addRole");
        } else {
            request.setAttribute("confirmationTitle", (Object)"label.editRole");
        }
        return mapping.findForward(FWD_CONFIRM);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.add", "add");
        map.put("button.update", "update");
        map.put("button.delete", "delete");
        map.put("button.cancel", "discard");
        map.put("button.addRole", "addNew");
        map.put("button.edit", "edit");
        map.put("button.revise", "revise");
        map.put("button.discardChanges", "discard");
        map.put("button.acceptChanges", "accept");
        map.put("button.returnToEdit", "returnToEdit");
        return map;
    }
}

