/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonSearchQueryInfo;
import gov.va.med.esr.ui.admin.beans.VeteranSearchBean;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueListInfo;

public class PersonSearchValueListAdapter
extends SearchValueListAdapter {
    private static final long serialVersionUID = -7571419029256398228L;

    protected List performPostQueryProcessing(List results, SearchQueryInfo searchQueryInfo, ValueListInfo info) throws ValueListException {
        Vector<VeteranSearchBean> vetList = new Vector<VeteranSearchBean>();
        int size = results != null ? results.size() : 0;
        boolean isAddPerson = false;
        PersonSearchQueryInfo personSearchQueryInfo = null;
        if (searchQueryInfo != null && searchQueryInfo instanceof PersonSearchQueryInfo) {
            personSearchQueryInfo = (PersonSearchQueryInfo)searchQueryInfo;
        }
        boolean bl = isAddPerson = personSearchQueryInfo != null && personSearchQueryInfo.isAddAPerson();
        if (size == 1) {
            this.saveTraitsToSession((Person)results.get(0), info);
        } else {
            this.clearTraitsFromSession(info);
        }
        for (int i = 0; i < size; ++i) {
            Person p = (Person)results.get(i);
            VeteranSearchBean bean = new VeteranSearchBean();
            Name legalName = null;
            Set names = p.getNames();
            if (names != null && names.size() > 0) {
                for (Name name : names) {
                    String code;
                    NameType type = name.getType();
                    String string = code = type != null ? type.getCode() : null;
                    if (!NameType.LEGAL_NAME.getName().equalsIgnoreCase(code)) continue;
                    legalName = name;
                    break;
                }
            }
            String firstName = "";
            String middleName = "";
            String lastName = "";
            if (legalName != null) {
                firstName = StringUtils.isBlank((String)legalName.getGivenName()) ? "" : legalName.getGivenName();
                String string = middleName = StringUtils.isBlank((String)legalName.getMiddleName()) ? "" : legalName.getMiddleName();
                if (StringUtils.isNotBlank((String)legalName.getFamilyName())) {
                    lastName = legalName.getFamilyName();
                    if (StringUtils.isNotBlank((String)legalName.getSuffix())) {
                        lastName = lastName + " " + legalName.getSuffix();
                    }
                }
            }
            bean.setFirstName(firstName);
            bean.setMiddleName(middleName);
            bean.setLastName(lastName);
            if (personSearchQueryInfo != null && !personSearchQueryInfo.isAddAPerson()) {
                bean.setPersonID(p.getEntityKey().getKeyValueAsString());
            }
            Set ssns = p.getSsns();
            String ssnText = "";
            if (ssns != null) {
                for (SSN ssnObj : ssns) {
                    if (((PersonSearchQueryInfo)searchQueryInfo).isAddAPerson()) {
                        ssnText = ssnObj.getSsnText();
                        break;
                    }
                    if (!SSNType.CODE_ACTIVE.getName().equals(ssnObj.getType().getCode())) continue;
                    ssnText = ssnObj.getSsnText();
                }
            }
            if (StringUtils.isBlank((String)ssnText)) {
                ssnText = "UNKNOWN";
            }
            bean.setSsn(ssnText);
            bean.setDateOfBirth(p.getBirthRecord() != null ? p.getBirthRecord().getBirthDate() : null);
            bean.setSensitiveRecord(p.getSensitiveRecord());
            bean.setPersonLockedReason(p.getPersonLockedReason());
            if (p.getBirthRecord().getMultipleBirth() == null) {
                bean.setMultipleBirth("");
            } else if (p.getBirthRecord().getMultipleBirth().equals(Boolean.TRUE)) {
                bean.setMultipleBirth("Y");
            } else {
                bean.setMultipleBirth("N");
            }
            bean.setAddAPerson(isAddPerson);
            bean.setIdmMatchType(p.getIdmMatchType());
            bean.setGender(p.getGender());
            bean.setVpid(p.getVPIDEntityKey().getKeyValueAsString());
            vetList.add(bean);
        }
        return vetList;
    }

    private void clearTraitsFromSession(ValueListInfo info) {
        Map filterMap = info.getFilters();
        HttpServletRequest request = (HttpServletRequest)filterMap.get(HTTP_REQUEST_KEY);
        this.removeSelectedTraits(request);
    }

    private void saveTraitsToSession(Person p, ValueListInfo info) {
        PersonIdentityTraits traits = p.getIdentityTraits();
        Map filterMap = info.getFilters();
        HttpServletRequest request = (HttpServletRequest)filterMap.get(HTTP_REQUEST_KEY);
        this.setSelectedTraits(request, traits);
    }

    protected void setSelectedTraits(HttpServletRequest request, PersonIdentityTraits traits) {
        this.putSandboxEntry(request, "SelectedTraits", traits);
    }

    protected void removeSelectedTraits(HttpServletRequest request) {
        this.removeSandboxEntry(request, "SelectedTraits");
    }

    protected Map getApplicationData(HttpServletRequest request) {
        HttpSession session = request.getSession();
        HashMap appData = (HashMap)session.getAttribute("AppData");
        if (appData == null) {
            appData = new HashMap();
            session.setAttribute("AppData", appData);
        }
        return appData;
    }

    protected Map getSandbox(HttpServletRequest request) {
        return this.getApplicationData(request);
    }

    protected void putSandboxEntry(HttpServletRequest request, Object key, Object value) {
        if (key != null && value != null) {
            this.getSandbox(request).put(key, value);
        }
    }

    protected Object removeSandboxEntry(HttpServletRequest request, Object key) {
        return key != null ? this.getSandbox(request).remove(key) : null;
    }
}

