/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.comms.Document;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.DocumentType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.util.MailingAddressHelper;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.external.HandBookInfo;
import gov.va.med.esr.ui.admin.action.PersonOverviewForm;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PersonOverviewConversionService
extends UIConversionServiceImpl {
    public static final String EMPTY_STRING = "";

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof Person && target instanceof PersonOverviewForm) {
            Person person = (Person)source;
            PersonOverviewForm formBean = (PersonOverviewForm)((Object)target);
            PersonHelperService helper = this.getPersonHelperService();
            try {
                IncomeTest incomeTest;
                HealthBenefitProfile hbp;
                formBean.setEligibilityStatus(helper.getEligibilityStatus(person));
                ServiceConnectionAward svcConnAwd = person.getServiceConnectionAward();
                formBean.setServiceConnectedPercentage(svcConnAwd == null ? null : svcConnAwd.getServiceConnectedPercentage());
                EnrollmentDetermination enrollDet = person.getEnrollmentDetermination();
                if (enrollDet != null) {
                    Eligibility eligibility = enrollDet.getPrimaryEligibility();
                    formBean.setPrimaryEligibilityCode(eligibility == null ? null : eligibility.getType().getDescription());
                    Set eligibilities = enrollDet.getSecondaryEligibilities();
                    ArrayList<String> secondaryEligibilityCodes = new ArrayList<String>();
                    if (eligibilities != null && eligibilities.size() > 0) {
                        Object[] a = enrollDet.getSecondaryEligibilities().toArray();
                        Arrays.sort(a);
                        for (int i = 0; i < a.length; ++i) {
                            eligibility = (Eligibility)a[i];
                            secondaryEligibilityCodes.add(eligibility.getType().getDescription());
                        }
                    }
                    formBean.setSecondaryEligibilityCodes(secondaryEligibilityCodes);
                    formBean.setEffectiveDateOfChange(enrollDet.getEffectiveDate());
                }
                if ((hbp = person.getHealthBenefitProfile()) != null) {
                    Set plans = hbp.getHealthBenefitPlans();
                    formBean.setCurrentNumberOfHealthBenefitPlans(plans.size());
                } else {
                    formBean.setCurrentNumberOfHealthBenefitPlans(0);
                }
                Address currentAddress = MailingAddressHelper.selectAddressForMailing((Collection)person.getAddresses());
                formBean.setCurrentMailingAddress(JspUtils.displayAddress((Address)currentAddress));
                formBean.setBadAddressReason(currentAddress == null || currentAddress.getBadAddressReason() == null ? null : currentAddress.getBadAddressReason().getCode());
                this.copyEmergencyReponse(person, formBean);
                Set phones = person.getPhones();
                if (phones != null) {
                    for (Phone phone : phones) {
                        if (!phone.getType().getCode().equals(PhoneType.CODE_HOME.getName())) continue;
                        String phonenumber = phone.getPhoneNumber();
                        if (phonenumber != null && phonenumber.length() > 0) {
                            formBean.setPhoneNumber(phonenumber);
                            continue;
                        }
                        formBean.setPhoneNumber(null);
                    }
                }
                if ((incomeTest = this.getPersonHelperService().getCurrentIncomeTest(person)) != null) {
                    Set statuses;
                    formBean.setCurrentTestType(incomeTest.getType().getDescription());
                    if (incomeTest.getPrimaryTestType() != null) {
                        formBean.setPrimaryTestType(incomeTest.getPrimaryTestType().getDescription());
                    }
                    if ((statuses = incomeTest.getStatuses()) != null) {
                        for (Object statusObj : statuses) {
                            if (statusObj == null || !(statusObj instanceof IncomeTestStatus)) continue;
                            IncomeTestStatus incomeTestStatus = (IncomeTestStatus)statusObj;
                            String statusDesc = null;
                            if (incomeTestStatus.getStatus() != null) {
                                statusDesc = incomeTestStatus.getStatus().getDescription();
                            }
                            if (incomeTestStatus.getType() == null) continue;
                            if (incomeTestStatus.getType().getCode().equals(IncomeTestType.CODE_MEANS_TEST.getName())) {
                                formBean.setMeansTestStatus(statusDesc);
                                continue;
                            }
                            if (incomeTestStatus.getType().getCode().equals(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName())) {
                                formBean.setPharmacyCoPayStatus(statusDesc);
                                continue;
                            }
                            if (incomeTestStatus.getType().getCode().equals(IncomeTestType.CODE_LTC_CO_PAY_TEST.getName())) {
                                formBean.setLtcCoPayStatus(statusDesc);
                                continue;
                            }
                            if (!incomeTestStatus.getType().getCode().equals(IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST.getName())) continue;
                            formBean.setLtcCoPayExemptionStatus(statusDesc);
                        }
                    }
                }
                if (person.getSignatureImages() != null && person.getSignatureImages().size() > 0) {
                    ArrayList signatures = new ArrayList(person.getSignatureImages());
                    Collections.sort(signatures);
                    SignatureImage image = (SignatureImage)signatures.get(0);
                    if (image != null) {
                        formBean.setSignatureOnFile(image.getSignatureIndicator());
                        formBean.setImageId(image.getImageIdNumber());
                        formBean.setDateIndexed(image.getDateIndex());
                    }
                } else {
                    formBean.setSignatureOnFile(null);
                    formBean.setImageId(null);
                    formBean.setDateIndexed(null);
                }
                formBean.setApplicationDate(person.getApplication() == null ? null : person.getApplication().getApplicationDate());
                DeathRecord deathRecord = person.getDeathRecord();
                if (deathRecord != null && deathRecord.getDeathDate() != null) {
                    formBean.setCurrentStatus("Deceased");
                } else {
                    formBean.setCurrentStatus("Alive");
                }
                List handBookls = this.getHandBookService().getLatestHandbookInformation(person.getIdentityTraits().getVpid().getVPID());
                if (handBookls != null && !handBookls.isEmpty()) {
                    this.buildHandebookOverview(formBean, handBookls);
                    if (formBean.getBenefitGlanceHistory() != null && formBean.getBenefitGlanceHistory().size() > 0 || formBean.getHandbookHistory() != null && formBean.getHandbookHistory().size() > 0) {
                        formBean.setHandbookInfo(true);
                    }
                }
                String vpid = person.getIdentityTraits().getVpid().getVPID();
                this.getVhicCardInfoService().resetVhicCardInfo(vpid);
                formBean.setVhicCardNum(this.getVhicCardInfoService().getVhicCardInfo().getCurrentVHICCardNumber());
                formBean.setVhicCardStatus(this.getVhicCardInfoService().getVhicCardInfo().getCurrentVHICCardStatus());
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        } else {
            throw new ConversionServiceException("Type mismatch: Expecting Person, PersonOverviewForm Received " + source.getClass().getName() + " and " + target.getClass().getName());
        }
    }

    private void buildHandebookOverview(PersonOverviewForm formBean, List handBookls) throws Exception {
        DocumentReceipt docReceipt = null;
        Set docs = null;
        Document doc2 = null;
        List<Document> hbDocList = new ArrayList();
        List<Document> bpDocList = new ArrayList();
        for (int i = 0; i < handBookls.size(); ++i) {
            docReceipt = (DocumentReceipt)handBookls.get(i);
            docs = docReceipt.getDocuments();
            for (Document doc2 : docs) {
                if (DocumentType.isHandBook((DocumentType)doc2.getDocumentType())) {
                    hbDocList.add(doc2);
                    continue;
                }
                if (!DocumentType.isBenefitsProfile((DocumentType)doc2.getDocumentType())) continue;
                bpDocList.add(doc2);
            }
        }
        hbDocList = this.getLastestThreeDocHistory(hbDocList);
        bpDocList = this.getLastestThreeDocHistory(bpDocList);
        formBean.setHandbookHistory(this.buildDocumentList(hbDocList));
        formBean.setBenefitGlanceHistory(this.buildDocumentList(bpDocList));
    }

    private List buildDocumentList(List docList) throws Exception {
        if (docList == null) {
            return null;
        }
        ArrayList<HandBookInfo> ls = new ArrayList<HandBookInfo>();
        Object doc = null;
        Object dr = null;
        for (int i = 0; i < docList.size(); ++i) {
            ls.add(this.buildDocument(((Document)docList.get(i)).getDocumentReceipt(), (Document)docList.get(i)));
        }
        return ls;
    }

    private HandBookInfo buildDocument(DocumentReceipt docReceipt, Document doc) throws Exception {
        HandBookInfo hbi = new HandBookInfo();
        hbi.setDocType(doc.getDocumentType().getName());
        hbi.setGeneratedDate(doc.getCreationDate());
        hbi.setName(doc.getFileInfo().getName());
        hbi.setPhysicalLocation(this.getHandBookService().getVBRFileLocation(doc.getFileInfo().getDirectory()));
        hbi.setReleaseControlNumber(docReceipt.getReleaseControlNumber());
        hbi.setVersion(docReceipt.getVersionNumber());
        hbi.setFileId(doc.getFileInfo().getEntityKey().getKeyValueAsString());
        return hbi;
    }

    public List getLastestThreeDocHistory(Collection docs) {
        ArrayList sortedList = new ArrayList();
        if (docs != null && !docs.isEmpty()) {
            sortedList.addAll(docs);
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = pObject1 instanceof Document ? ((Document)pObject1).getCreationDate() : null;
                    Date date2 = pObject2 instanceof Document ? ((Document)pObject2).getCreationDate() : null;
                    return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                }
            };
            Collections.sort(sortedList, comparator);
        }
        if (sortedList.size() < 4) {
            return sortedList;
        }
        return sortedList.subList(0, 3);
    }

    private void copyEmergencyReponse(Person person, PersonOverviewForm form) {
        Set existingEResponseIndicator = person.getEmergencyResponseIndicators();
        HashSet<String> existingEResponseIndicatorDesc = new HashSet<String>();
        if (existingEResponseIndicator != null && !existingEResponseIndicator.isEmpty()) {
            EmergencyResponseIndicator eResponseIndicator2 = null;
            for (EmergencyResponseIndicator eResponseIndicator2 : existingEResponseIndicator) {
                if (eResponseIndicator2 == null) continue;
                existingEResponseIndicatorDesc.add(eResponseIndicator2.getEmergencyResponse().getDescription());
            }
            form.setEmergencyResponse(JspUtils.displayValues(existingEResponseIndicatorDesc, (String)EMPTY_STRING, null));
        }
    }
}

