/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.ui.admin.action.Log4jForm;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.Log4jTriggerEvent;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;
import org.apache.commons.lang.Validate;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class Log4jAction
extends AbstractAction {
    private static final String DISPLAY_CURRENT_LOG_LEVELS = "displayCurrentLogLevels";
    private static final String LOG4J_TABLE_ID = "log4jTableId";
    private static final String LOG4J_VALUE_LIST_ADAPTER = "log4jValueListAdapter";
    private static final String BEGINS_WITH = "BEGINS WITH";
    private static final String CONTAINS = "CONTAINS";
    private TriggerableService triggerService = null;
    private String triggerEventName = null;

    public ActionForward displayCurrentLogLevels(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parentLogFilter;
        String button;
        String filterType;
        String loggerFilter = null;
        Log4jForm log4jForm = null;
        log4jForm = actionForm != null ? (Log4jForm)actionForm : (Log4jForm)((Object)request.getSession().getAttribute("log4jForm"));
        loggerFilter = log4jForm != null ? log4jForm.getLoggerFilter() : null;
        List currentLogLeves = this.getCurrentLogLevels(loggerFilter, filterType = (button = request.getParameter("methodName")) != null && (button.equals(BEGINS_WITH) || button.equals(CONTAINS)) ? button : null, parentLogFilter = request.getParameter("parentLogFilter"));
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)actionForm, (HttpServletRequest)request, (String)LOG4J_TABLE_ID, (String)LOG4J_VALUE_LIST_ADAPTER, (List)currentLogLeves);
        ValueListInfo info = valueList.getValueListInfo();
        if (info.getTotalNumberOfEntries() == 0) {
            this.addActionMessage(request, new ActionMessage("errors.search.noresult"));
        } else {
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        }
        return mapping.findForward(DISPLAY_CURRENT_LOG_LEVELS);
    }

    public ActionForward updateLogLevels(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String targetLogger = request.getParameter("logger");
        String targetLogLevel = request.getParameter("newLogLevel");
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(targetLogger, targetLogLevel);
        List children = this.getChildren(targetLogger, targetLogLevel);
        for (Logger logger : children) {
            configMap.put(logger.getName(), targetLogLevel);
        }
        this.updateLogLevels(configMap);
        return mapping.findForward(DISPLAY_CURRENT_LOG_LEVELS);
    }

    public void updateLogLevels(Map configMap) throws ServiceException {
        this.triggerService.trigger((TriggerEvent)new Log4jTriggerEvent(this.triggerEventName, (Serializable)new Object[]{configMap}, TriggerEvent.createTriggerIdentity((TriggerIdentity.DestinationType)TriggerIdentity.DestinationType.LOG4J), Log4jTriggerEvent.UPDATE));
    }

    public ActionForward resetLogLevelsToDefault(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.resetLogLevelsToDefault();
        return this.displayCurrentLogLevels(mapping, actionForm, request, response);
    }

    public void resetLogLevelsToDefault() throws ServiceException {
        this.triggerService.trigger((TriggerEvent)new Log4jTriggerEvent(this.triggerEventName, null, TriggerEvent.createTriggerIdentity((TriggerIdentity.DestinationType)TriggerIdentity.DestinationType.LOG4J), Log4jTriggerEvent.RESET_TO_DEFAULT));
    }

    protected List getCurrentLogLevels(String logNameFilter, String filterType, String parentLogFilter) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        ArrayList<Logger> loggersList = new ArrayList<Logger>();
        Logger rootLogger = LogManager.getRootLogger();
        loggersList.add(rootLogger);
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getName().startsWith("gov") || parentLogFilter != null && (parentLogFilter == null || !logger.getParent().getName().equals(parentLogFilter) && !logger.getName().equals(parentLogFilter))) continue;
            if (logNameFilter == null || logNameFilter.trim().length() == 0) {
                loggersList.add(logger);
                continue;
            }
            if (filterType == null || filterType != null && filterType.equals(CONTAINS)) {
                if (logger.getName().toUpperCase().indexOf(logNameFilter.toUpperCase()) < 0) continue;
                loggersList.add(logger);
                continue;
            }
            if (filterType == null || !filterType.equals(BEGINS_WITH) || !logger.getName().startsWith(logNameFilter)) continue;
            loggersList.add(logger);
        }
        return loggersList;
    }

    protected List getChildren(String parentLoggerName, String targetLogLevel) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        ArrayList<Logger> loggersList = new ArrayList<Logger>();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getName().startsWith("gov") || parentLoggerName == null || logger.getParent() == null || !logger.getParent().getName().equals(parentLoggerName) || targetLogLevel.equalsIgnoreCase(logger.getEffectiveLevel().toString())) continue;
            loggersList.add(logger);
        }
        return loggersList;
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.displayCurrentLogLevels", DISPLAY_CURRENT_LOG_LEVELS);
            this.keyMethodMap.put("button.beginsWith", DISPLAY_CURRENT_LOG_LEVELS);
            this.keyMethodMap.put("button.contains", DISPLAY_CURRENT_LOG_LEVELS);
            this.keyMethodMap.put("button.refresh", DISPLAY_CURRENT_LOG_LEVELS);
            this.keyMethodMap.put("button.updateLogLevels", "updateLogLevels");
            this.keyMethodMap.put("button.reset", "resetLogLevelsToDefault");
        }
        return this.keyMethodMap;
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.triggerService, (String)"Triggerable Service cannot be null");
        Validate.notNull((Object)this.triggerEventName, (String)"Trigger Event Name cannot be null");
    }

    public String getTriggerEventName() {
        return this.triggerEventName;
    }

    public void setTriggerEventName(String triggerEventName) {
        this.triggerEventName = triggerEventName;
    }

    public TriggerableService getTriggerService() {
        return this.triggerService;
    }

    public void setTriggerService(TriggerableService triggerService) {
        this.triggerService = triggerService;
    }
}

