/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class IrsRejectAction
extends AbstractAction {
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("irsRejectBatch");
    }

    public ActionForward displayIrsRejectBatch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List submissions = this.getIrsTransmissionService().getFailedBatchTransmissions();
        if (submissions != null && submissions.isEmpty()) {
            submissions = null;
        }
        if (submissions != null) {
            Collections.sort(submissions, new BeanComparator("transmissionDate", (Comparator)new NullComparator()));
            Collections.reverse(submissions);
        }
        request.setAttribute("submissions", (Object)submissions);
        return mapping.findForward("irsRejectBatch");
    }

    public ActionForward resubmit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String submissionId = request.getParameter("submissionId");
        this.getIrsTransmissionService().retransmitFailedSubmission(new BigDecimal(submissionId));
        this.addInformationMessage(request, "resubmitFailure");
        return this.displayIrsRejectBatch(mapping, form, request, response);
    }

    public ActionForward resubmitPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String submissionId = request.getParameter("submissionId");
        this.getIrsTransmissionService().retransmitFailedPersonSubmission(new BigDecimal(submissionId));
        this.addInformationMessage(request, "resubmitFailure");
        return this.displayIrsRejectPerson(mapping, form, request, response);
    }

    public ActionForward displayIrsRejectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List submissions = this.getIrsTransmissionService().getFailedPersonTransmissions();
        Collections.sort(submissions, new BeanComparator("batchTransmissionEntry.transmissionDate", (Comparator)new NullComparator()));
        Collections.reverse(submissions);
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"irsPersonTableId", (String)"irsRejectPersonAdapter", (List)submissions);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        request.setAttribute("submissions", (Object)submissions);
        return mapping.findForward("irsRejectPerson");
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("title.irsReject", "displayIrsRejectBatch");
        map.put("title.irsRejectP", "displayIrsRejectPerson");
        map.put("link.irsReject.resubmit", "resubmit");
        map.put("Resubmit", "resubmit");
        map.put("link.irsReject.resubmitPerson", "resubmitPerson");
        map.put("Resubmit Person", "resubmitPerson");
        return map;
    }
}

