/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.comms.BatchRequestFacility;
import gov.va.med.esr.common.model.comms.BatchRequestPriortyGroup;
import gov.va.med.esr.common.model.comms.HandBookBatchRequest;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.HandBookReleaseControl;
import gov.va.med.esr.common.model.lookup.HandBookRequestStatusType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.ui.admin.action.HandBookBatchRequestForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public class HandBookBatchRequestConversionService
extends UIConversionServiceImpl {
    public static final String ALL = "all";
    public static final String COMMA = ",";
    private PreferredFacilityService preferredFacilityService;
    private static final String[][] availablePriorityGroupCodes = new String[][]{{"1", null}, {"2", null}, {"3", null}, {"4", null}, {"5", null}, {"6", null}, {"7", "1"}, {"7", "3"}, {"8", "1"}, {"8", "2"}, {"8", "3"}, {"8", "4"}};
    private static TreeSet<BatchRequestPriortyGroup> avaialblePriorityGroups = null;

    public Object convert(Object source, Class targetClass) throws ConversionServiceException {
        return null;
    }

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (target instanceof HandBookBatchRequest && source instanceof HandBookBatchRequestForm) {
            this.convertFormToHandBookBatchRequest((HandBookBatchRequestForm)((Object)source), (HandBookBatchRequest)target);
        }
    }

    private void convertFormToHandBookBatchRequest(HandBookBatchRequestForm handBookBatchRequestForm, HandBookBatchRequest handBookBatchRequest) throws ConversionServiceException {
        handBookBatchRequest.setBatchReleaseDate(DateUtils.getDate((String)handBookBatchRequestForm.getReleaseDate()));
        handBookBatchRequest.setMaxPerJobNumber(Integer.toString(handBookBatchRequestForm.getMaxRecord()));
        handBookBatchRequest.setRequestNote(handBookBatchRequestForm.getReleaseNote());
        this.setEnrollmentPriorityGroups(handBookBatchRequestForm.getPriorityGroup(), handBookBatchRequest);
        Set facilities = this.getFacilitiesForSite(handBookBatchRequestForm.getVisnVamc());
        if (facilities != null && facilities.size() > 0) {
            this.setFacilities(facilities, handBookBatchRequest);
        }
        String reaseControl = handBookBatchRequestForm.getReleaseCtl();
        HandBookReleaseControl handBookReleaseControl = (HandBookReleaseControl)this.getLookup(HandBookReleaseControl.class, reaseControl);
        handBookBatchRequest.setHandBookReleaseControl(handBookReleaseControl);
        HandBookRequestStatusType statusType = (HandBookRequestStatusType)this.getLookup(HandBookRequestStatusType.class, HandBookRequestStatusType.NEW.getCode());
        handBookBatchRequest.setHandBookRequestStatus(statusType);
        handBookBatchRequest.setBatchReleaseSize("0");
    }

    private void setEnrollmentPriorityGroups(String code, HandBookBatchRequest handBookBatchRequest) throws ConversionServiceException {
        BatchRequestPriortyGroup userSelection = this.getUserSelectedPriorityGroup(code);
        this.setBatchRequestPriorityGroupCriteria(userSelection, handBookBatchRequest);
    }

    private BatchRequestPriortyGroup getUserSelectedPriorityGroup(String code) throws ConversionServiceException {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        BatchRequestPriortyGroup userSelection = null;
        try {
            EnrollmentPriorityGroup priorityGroupLookup;
            String[] codes = StringUtils.split((String)code, (String)COMMA);
            String priorityCode = null;
            String prioritySubCode = null;
            priorityCode = codes[0];
            String string = prioritySubCode = codes.length > 1 ? codes[1] : null;
            if (StringUtils.contains((String)code, (String)ALL)) {
                priorityCode = availablePriorityGroupCodes[availablePriorityGroupCodes.length - 1][0];
                prioritySubCode = availablePriorityGroupCodes[availablePriorityGroupCodes.length - 1][1];
            }
            if ((priorityGroupLookup = (EnrollmentPriorityGroup)this.getLookup(EnrollmentPriorityGroup.class, priorityCode)) != null) {
                userSelection = new BatchRequestPriortyGroup();
                userSelection.setPriorityGroup(priorityGroupLookup);
                EnrollmentPrioritySubGroup prioritySubGroupLookup = (EnrollmentPrioritySubGroup)this.getLookup(EnrollmentPrioritySubGroup.class, prioritySubCode);
                if (prioritySubGroupLookup != null) {
                    userSelection.setPrioritySubGroup(prioritySubGroupLookup);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while creating EnrollmentPriorityGroup", ex);
        }
        return userSelection;
    }

    private void setBatchRequestPriorityGroupCriteria(BatchRequestPriortyGroup userSelection, HandBookBatchRequest handBookBatchRequest) throws ConversionServiceException {
        NavigableSet<BatchRequestPriortyGroup> priorityGroupCriteriaList = this.getAvaiablePriorityGroups().headSet(userSelection, true);
        for (BatchRequestPriortyGroup availablePriorityGroupItem : priorityGroupCriteriaList) {
            BatchRequestPriortyGroup batchRequestPriorityGroupRecord = new BatchRequestPriortyGroup();
            batchRequestPriorityGroupRecord.setPriorityGroup(availablePriorityGroupItem.getPriorityGroup());
            if (availablePriorityGroupItem.getPrioritySubGroup() != null) {
                batchRequestPriorityGroupRecord.setPrioritySubGroup(availablePriorityGroupItem.getPrioritySubGroup());
            }
            handBookBatchRequest.addBatchRequestPriortyGroup(batchRequestPriorityGroupRecord);
        }
    }

    private TreeSet<BatchRequestPriortyGroup> getAvaiablePriorityGroups() throws ConversionServiceException {
        if (avaialblePriorityGroups == null) {
            avaialblePriorityGroups = new TreeSet();
            for (String[] priorityCodes : availablePriorityGroupCodes) {
                BatchRequestPriortyGroup newPriorityGrp = new BatchRequestPriortyGroup();
                newPriorityGrp.setPriorityGroup((EnrollmentPriorityGroup)this.getLookup(EnrollmentPriorityGroup.class, priorityCodes[0]));
                if (priorityCodes[1] != null) {
                    newPriorityGrp.setPrioritySubGroup((EnrollmentPrioritySubGroup)this.getLookup(EnrollmentPrioritySubGroup.class, priorityCodes[1]));
                }
                avaialblePriorityGroups.add(newPriorityGrp);
            }
        }
        return avaialblePriorityGroups;
    }

    @Override
    public Lookup getLookup(Class clazz, String code) throws ConversionServiceException {
        Lookup lookup = null;
        try {
            if (StringUtils.isNotEmpty((String)code)) {
                lookup = this.getLookupCacheService().getByCodeFromCache(clazz, code);
            }
        }
        catch (Exception ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Error while getting lookup object for ");
            buffer.append(" type = " + clazz.getName());
            buffer.append(" code = " + code);
            throw new ConversionServiceException(buffer.toString(), ex);
        }
        return lookup;
    }

    private void setFacilities(Set siteStats, HandBookBatchRequest handBookBatchRequest) throws ConversionServiceException {
        for (VAFacility facility : siteStats) {
            ArrayList<VAFacility> pfList = new ArrayList<VAFacility>();
            pfList.add(facility);
            try {
                Set childSite = this.getChildFacilities(pfList);
                Iterator childIter = childSite.iterator();
                while (childIter.hasNext()) {
                    BatchRequestFacility batchRequestFacility = new BatchRequestFacility();
                    VAFacility childVAFacility = (VAFacility)childIter.next();
                    batchRequestFacility.setRequestSite(childVAFacility);
                    batchRequestFacility.setParentSite(facility);
                    handBookBatchRequest.addbatchRequestFacility(batchRequestFacility);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)"eeror in finding child VA Facilities", ex.getCause());
            }
        }
    }

    private Set getFacilitiesForSite(String[] code) throws ConversionServiceException {
        Set facilities = null;
        if (code != null && code.length > 0) {
            facilities = StringUtils.contains((String[])code, (String)ALL) ? new HashSet() : this.getLookups(VAFacility.class, code);
        }
        return facilities;
    }

    private Set getLookups(Class clazz, String[] code) throws ConversionServiceException {
        HashSet<Lookup> lookups = null;
        try {
            if (code != null && code.length > 0) {
                if (StringUtils.contains((String[])code, (String)ALL)) {
                    lookups = new HashSet(this.getLookupCacheService().getFromCache(clazz.getName()));
                } else {
                    lookups = new HashSet<Lookup>();
                    Lookup lookup = null;
                    for (int i = 0; i < code.length; ++i) {
                        lookup = this.getLookup(clazz, code[i]);
                        if (lookup == null) continue;
                        lookups.add(this.getLookup(clazz, code[i]));
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while getting lookup object for type = " + clazz.getName() + " code = " + code, ex);
        }
        return lookups;
    }

    private Lookup getLookupByName(Class clazz, String name) throws ConversionServiceException {
        AbstractLookup lookup = null;
        try {
            if (StringUtils.isNotEmpty((String)name)) {
                lookup = this.getLookupCacheService().getLookupService().getByName(clazz, name);
            }
        }
        catch (Exception ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Error while getting lookup object for ");
            buffer.append(" type = " + clazz.getName());
            buffer.append(" name = " + name);
            throw new ConversionServiceException(buffer.toString(), ex);
        }
        return lookup;
    }

    private Integer getInteger(String value) {
        return StringUtils.isNotEmpty((String)value) ? new Integer(value) : null;
    }

    private boolean getTrueFalse(String flag) {
        return StringUtils.equals((String)flag, (String)"y");
    }

    protected static void setPrivateFieldData(Object obj, Class clazz, String methodName, Object data) {
        try {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                Object[] params = new Object[]{data};
                methods[i].setAccessible(true);
                methods[i].invoke(obj, params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] merge(String[] setOne, String[] SetTwo) {
        int i;
        HashSet<String> newSet = new HashSet<String>();
        if (setOne != null && setOne.length > 0) {
            for (i = 0; i < setOne.length; ++i) {
                newSet.add(setOne[i]);
            }
        }
        if (SetTwo != null && SetTwo.length > 0) {
            for (i = 0; i < SetTwo.length; ++i) {
                newSet.add(SetTwo[i]);
            }
        }
        return this.getStringArrayFromSet(newSet);
    }

    private String[] getStringArrayFromSet(Set set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        String[] code = new String[set.size()];
        int i = 0;
        for (String string : set) {
            if (!StringUtils.isNotEmpty((String)string)) continue;
            code[i] = string;
            ++i;
        }
        return code;
    }

    public Set getChildFacilities(List pfList) throws ServiceException {
        HashSet<VAFacility> childFacilities = new HashSet<VAFacility>();
        Object pf = null;
        ArrayList<BigDecimal> siteList = null;
        while (pfList.size() > 0) {
            Iterator iter = pfList.iterator();
            while (iter.hasNext()) {
                siteList = new ArrayList<BigDecimal>();
                VAFacility facility = (VAFacility)iter.next();
                childFacilities.add(facility);
                siteList.add(facility.getIdentifier());
            }
            pfList = this.preferredFacilityService.getChildVAFacility(siteList);
        }
        return childFacilities;
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }
}

