/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.comms.HandbookBatchFileProcessStatistics;
import gov.va.med.esr.ui.admin.action.HandBookBatchFileProcessForm;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.service.ServiceConfigurationException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class HandBookBatchFileProcessAction
extends AbstractAction {
    public static final String FORWARD_HANDBOOK_FILE_DATE_FILTER = "displayHandbookFileDateFilter";
    public static final String FORWARD_HANDBOOK_FILE_STATISTICS = "displayHandbookFileStatistics";

    public ActionForward displayHandbookFileDateFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HandBookBatchFileProcessForm hbfProcessForm = this.getHandBookBatchFileProcessForm(form);
        if (hbfProcessForm.getHbfDateList() == null || hbfProcessForm.getHbfDateList().size() == 0) {
            List dateList = this.getHandBookService().getHandbookBatchFileProcessDateList();
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
            ArrayList<String> dateListStr = new ArrayList<String>();
            Iterator iter = dateList.iterator();
            while (iter.hasNext()) {
                dateListStr.add(formatter.format(iter.next()));
            }
            request.setAttribute("Date_Change_Event_Keys", dateListStr);
            hbfProcessForm.setHbfDateList(dateListStr);
        } else {
            request.setAttribute("Date_Change_Event_Keys", (Object)hbfProcessForm.getHbfDateList());
        }
        return mapping.findForward(FORWARD_HANDBOOK_FILE_DATE_FILTER);
    }

    protected HandBookBatchFileProcessForm getHandBookBatchFileProcessForm(ActionForm form) throws ServiceConfigurationException {
        HandBookBatchFileProcessForm hbfProcessForm;
        HandBookBatchFileProcessForm handBookBatchFileProcessForm = hbfProcessForm = form instanceof HandBookBatchFileProcessForm ? (HandBookBatchFileProcessForm)form : null;
        if (hbfProcessForm == null) {
            throw new ServiceConfigurationException("HandBookBatchFileProcessForm not properly configured.");
        }
        return hbfProcessForm;
    }

    public ActionForward displayHandbookFileStatistics(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HandBookBatchFileProcessForm hbfProcessForm = this.getHandBookBatchFileProcessForm(form);
        String selectedDateStr = new String(hbfProcessForm.getSelectedDate());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        Date selectedDate = dateFormat.parse(selectedDateStr);
        Date minJobStartDate = this.getHandBookService().getHandbookBatchFileProcessMinJobStartDate(selectedDate);
        Date maxJobEndDate = this.getHandBookService().getHandbookBatchFileProcessMaxJobEndDate(selectedDate);
        hbfProcessForm.setMinJobStartDate(minJobStartDate);
        hbfProcessForm.setMaxJobEndDate(maxJobEndDate);
        HandbookBatchFileProcessStatistics handBookBatchFileProcessStatistics = this.getHandBookService().getHandbookBatchFileProcessStatistics(selectedDate, minJobStartDate, maxJobEndDate);
        if (handBookBatchFileProcessStatistics != null) {
            request.setAttribute("handBookBatchFileProcessStat", (Object)handBookBatchFileProcessStatistics);
        }
        return mapping.findForward(FORWARD_HANDBOOK_FILE_STATISTICS);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("link.handBookBatchRequest.handbookFileDateFilters", FORWARD_HANDBOOK_FILE_DATE_FILTER);
        map.put("button.viewData", FORWARD_HANDBOOK_FILE_STATISTICS);
        return map;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

