/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.ui.admin.action.AbstractUserProfileAction;
import gov.va.med.esr.ui.admin.action.CapabilitySetForm;
import gov.va.med.esr.ui.common.beans.FieldHistoryInfo;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CapabilitySetsAction
extends AbstractUserProfileAction {
    public static final String FWD_DISPLAY_SETS = "displaySets";
    public static final String FWD_EDIT = "editSet";
    public static final String FWD_CONFIRM = "confirm";
    public static final String PAR_CAPABILITY_SET_ID = "capabilitySetId";
    public static final String ATTR_CAPABILITY_SETS = "CapabilitySets";
    public static final String ATTR_DELETED_CAPABILITY_SETS = "DeletedCapabilitySets";
    public static final String MSG_SET_NAME_DUPLICATE = "error.capabilitySetNameDuplicate";
    public static final String MSG_SET_REQUIRES_TWO = "error.capabilitySetrequiresTwoCapabilities";
    public static final String FIELD_NAME = "name";
    public static final String MSG_ASSIGNED_CAN_NOT_BE_DELETED = "error.capabilitySetisAssigned";
    public static final String MSG_ACTIVE_DATE_INVALID = "error.activeDate";
    public static final String FLD_ACTIVE_DATE = "activeDate";
    public static final String FLD_INACTIVE_DATE = "inactiveDate";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearSessionData(request);
        List allCapabilitySets = this.getUserAdminService().getAllCapabilitySets();
        Collections.sort(allCapabilitySets);
        List deletedSets = this.getUserAdminService().findDeletedCapabilitySets();
        Collections.sort(deletedSets);
        request.setAttribute(ATTR_CAPABILITY_SETS, (Object)allCapabilitySets);
        request.setAttribute(ATTR_DELETED_CAPABILITY_SETS, (Object)deletedSets);
        return mapping.findForward(FWD_DISPLAY_SETS);
    }

    public ActionForward addNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CapabilitySetForm setForm = (CapabilitySetForm)form;
        setForm.setAvailableCapabilities(this.getUserAdminService().getAllCapabilities());
        return mapping.findForward(FWD_EDIT);
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String setId = request.getParameter(PAR_CAPABILITY_SET_ID);
        Validate.notNull((Object)setId, (String)"Capability Set Id can not be null");
        EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(setId), CapabilitySet.class);
        CapabilitySet capabilitySet = this.getUserAdminService().getCapabilitySetById(entityKey);
        this.setPristineEntity(request, capabilitySet);
        this.conversionService.convert((Object)capabilitySet, (Object)form);
        return mapping.findForward(FWD_EDIT);
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String setName = ((CapabilitySetForm)form).getName().trim();
        if (this.getUserAdminService().getCapabilitySetByName(setName) != null) {
            this.addActionMessageForField(request, MSG_SET_NAME_DUPLICATE, FIELD_NAME);
            return mapping.getInputForward();
        }
        CapabilitySet newSet = new CapabilitySet();
        this.conversionService.convert((Object)form, (Object)newSet);
        this.setPristineEntity(request, null);
        this.setUpdatedEntity(request, newSet);
        if (this.isValid(request, newSet)) {
            return this.confirmation(mapping, form, request, response);
        }
        return mapping.getInputForward();
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String setId = request.getParameter(PAR_CAPABILITY_SET_ID);
        Validate.notNull((Object)setId, (String)"Capability Set Id can not be null");
        EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(setId), CapabilitySet.class);
        CapabilitySet capabilitySet = this.getUserAdminService().getCapabilitySetById(entityKey);
        if (Boolean.TRUE.equals(capabilitySet.isAssigned())) {
            this.addActionMessage(request, MSG_ASSIGNED_CAN_NOT_BE_DELETED);
            return mapping.getInputForward();
        }
        this.getUserAdminService().deleteCapabilitySet(capabilitySet);
        return mapping.findForward("displayDeleteMsg");
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CapabilitySetForm setForm = (CapabilitySetForm)form;
        CapabilitySet pristine = (CapabilitySet)this.getPristineEntity(request);
        CapabilitySet updated = (CapabilitySet)pristine.clone();
        this.conversionService.convert((Object)setForm, (Object)updated);
        this.setUpdatedEntity(request, updated);
        if (this.isValid(request, updated)) {
            return this.confirmation(mapping, form, request, response);
        }
        return mapping.getInputForward();
    }

    public ActionForward accept(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CapabilitySet capabilitySet = (CapabilitySet)this.getUpdatedEntity(request);
        if (capabilitySet.getEntityKey() == null) {
            this.getUserAdminService().addCapabilitySet(capabilitySet);
            return mapping.findForward("displayAddMessage");
        }
        this.getUserAdminService().updateCapabilitySet(capabilitySet);
        return mapping.findForward("displayUpdateMsg");
    }

    @Override
    public ActionForward revise(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CapabilitySet capabilitySet = (CapabilitySet)this.getUpdatedEntity(request);
        this.conversionService.convert((Object)capabilitySet, (Object)form);
        return mapping.findForward(FWD_EDIT);
    }

    @Override
    public ActionForward discard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FWD_DISPLAY_SETS);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }

    protected ActionForward confirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CapabilitySet pristine = (CapabilitySet)this.getPristineEntity(request);
        CapabilitySet current = (CapabilitySet)this.getUpdatedEntity(request);
        ArrayList<FieldHistoryInfo> propList = new ArrayList<FieldHistoryInfo>();
        propList.add(new FieldHistoryInfo("label.name", current == null ? "" : current.getName(), pristine == null ? "" : pristine.getName()));
        propList.add(new FieldHistoryInfo("label.description", current == null ? "" : current.getDescription(), pristine == null ? "" : pristine.getDescription()));
        propList.add(new FieldHistoryInfo("label.activeDate", current == null ? "" : DateUtils.format((Date)current.getActiveDate(), null), pristine == null ? "" : DateUtils.format((Date)pristine.getActiveDate(), null)));
        propList.add(new FieldHistoryInfo("label.inactivedate", current == null ? "" : DateUtils.format((Date)current.getInactiveDate(), null), pristine == null ? "" : DateUtils.format((Date)pristine.getInactiveDate(), null)));
        List list = this.matchSets(current.getCapabilities(), pristine == null ? null : pristine.getCapabilities());
        propList.addAll(this.processCapabilities(list));
        request.setAttribute("changeList", propList);
        request.setAttribute("confirmationActionName", (Object)"editCapabilitySet");
        request.setAttribute("confirmationEntityId", (Object)(pristine == null ? "" : pristine.getEntityKey().getKeyValueAsString()));
        if (pristine == null) {
            request.setAttribute("confirmationTitle", (Object)"label.addCapabilitySet");
        } else {
            request.setAttribute("confirmationTitle", (Object)"label.editCapabilitySet");
        }
        return mapping.findForward(FWD_CONFIRM);
    }

    private boolean isValid(HttpServletRequest request, CapabilitySet set) {
        boolean valid = true;
        if (set.getCapabilities().size() < 2) {
            this.addActionMessage(request, MSG_SET_REQUIRES_TWO);
            valid = false;
        }
        Date current = DateUtils.getCurrentDate();
        Date prevActiveDate = null;
        Date prevInactiveDate = null;
        if (set.getEntityKey() != null) {
            CapabilitySet pristine = (CapabilitySet)this.getPristineEntity(request);
            prevActiveDate = pristine.getActiveDate();
            prevInactiveDate = pristine.getInactiveDate();
        }
        if (set.getActiveDate() != null && !set.getActiveDate().equals(prevActiveDate) && set.getActiveDate().before(current)) {
            valid = false;
            this.addActionMessageForField(request, "error.activeDatePast", FLD_ACTIVE_DATE);
        }
        if (set.getInactiveDate() != null && !set.getInactiveDate().equals(prevInactiveDate) && set.getInactiveDate().before(current)) {
            valid = false;
            this.addActionMessageForField(request, "error.inactiveDatePast", FLD_INACTIVE_DATE);
        }
        if (set.getActiveDate() != null && set.getInactiveDate() != null && set.getActiveDate().after(set.getInactiveDate())) {
            valid = false;
            this.addActionMessageForField(request, MSG_ACTIVE_DATE_INVALID, FLD_ACTIVE_DATE);
            this.addActionMessageForField(request, MSG_ACTIVE_DATE_INVALID, FLD_INACTIVE_DATE);
        }
        return valid;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.add", "add");
        map.put("button.update", "update");
        map.put("button.delete", "delete");
        map.put("button.cancel", "discard");
        map.put("button.addCapabilitySet", "addNew");
        map.put("button.edit", "edit");
        map.put("button.revise", "revise");
        map.put("button.discardChanges", "discard");
        map.put("button.acceptChanges", "accept");
        map.put("button.returnToEdit", "returnToEdit");
        return map;
    }
}

