/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.batchprocess.BatchProcessDetailStatus;
import gov.va.med.fw.batchprocess.BatchProcessInvoker;
import gov.va.med.fw.batchprocess.BatchProcessService;
import gov.va.med.fw.batchprocess.model.JobConfig;
import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.batchprocess.model.JobStatus;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.scheduling.TriggerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class BatchProcessAction
extends AbstractAction {
    public static final String BATCH_PROCESS_MGMT = "batchProcessManagement";
    public static final String BATCH_PROCESS_ACTIVE = "batchProcessActive";
    public static final String BATCH_PROCESS_CONFIG = "batchProcessConfig";
    public static final String BATCH_PROCESS_EXECUTE_WITH_ARGS = "batchProcessExecuteWithArgs";
    public static final String BATCH_PROCESS_HISTORY = "batchProcessHistory";
    public static final String BATCH_PROCESS_MGMT_FAILURE = "batchProcessManagement.failure";
    private BatchProcessInvoker invoker;
    private SchedulingService schedulingService;
    private BatchProcessService batchProcessService;

    public ActionForward displayActiveJobs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List activeJobs = this.batchProcessService.getJobResults(JobStatus.IN_PROCESS);
        if (activeJobs != null && !activeJobs.isEmpty()) {
            request.setAttribute("activeJobs", (Object)activeJobs);
        }
        return mapping.findForward(BATCH_PROCESS_ACTIVE);
    }

    public ActionForward markActiveJobAsCancelled(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm actionForm = (DynaActionForm)form;
        String jobResultId = actionForm.getString("jobResultId");
        this.batchProcessService.cancelActiveJob(EntityKeyFactory.createEntityKey((String)jobResultId, JobResult.class));
        return this.displayActiveJobs(mapping, form, request, null);
    }

    public ActionForward markActiveJobAsError(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm actionForm = (DynaActionForm)form;
        String jobResultId = actionForm.getString("jobResultId");
        this.batchProcessService.errActiveJob(EntityKeyFactory.createEntityKey((String)jobResultId, JobResult.class));
        return this.displayActiveJobs(mapping, form, request, null);
    }

    public ActionForward displayManagementDashboard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Collection jobs = this.getLookupCacheService().getFromCache(BatchProcessDetail.class.getName());
        ArrayList<BatchProcessDetailStatus> jobAndTriggerStatus = new ArrayList<BatchProcessDetailStatus>(jobs.size());
        Iterator itr = jobs != null ? jobs.iterator() : null;
        BatchProcessDetail detail = null;
        BatchProcessDetailStatus status = null;
        TriggerStatus triggerStatus = null;
        while (itr != null && itr.hasNext()) {
            detail = (BatchProcessDetail)itr.next();
            status = new BatchProcessDetailStatus();
            status.setBatchProcessDetail(detail);
            triggerStatus = this.schedulingService.getTriggerStatus(detail.getTriggerName(), detail.getTriggerGroup());
            status.setTriggerStatus(triggerStatus);
            jobAndTriggerStatus.add(status);
        }
        Collections.sort(jobAndTriggerStatus);
        request.setAttribute("jobs", jobAndTriggerStatus);
        return mapping.findForward(BATCH_PROCESS_MGMT);
    }

    public ActionForward executeBatchProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm actionForm = (DynaActionForm)form;
        String jobName = actionForm.getString("jobName");
        BatchProcessDetail batchProcessDetail = (BatchProcessDetail)this.getLookupCacheService().getByCodeFromCache(BatchProcessDetail.class.getName(), jobName);
        if (batchProcessDetail == null) {
            return mapping.findForward(BATCH_PROCESS_MGMT_FAILURE);
        }
        if (!batchProcessDetail.isExecutableFromManagementPage()) {
            return mapping.findForward(BATCH_PROCESS_MGMT_FAILURE);
        }
        this.invoker.invokeBatchProcessWithEvent(batchProcessDetail);
        this.addInformationMessage(request, "message.batchProcessManagement.execute.success", jobName);
        return this.displayManagementDashboard(mapping, form, request, response);
    }

    public ActionForward updateConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jobGroup;
        DynaActionForm actionForm = (DynaActionForm)form;
        String jobName = actionForm.getString("jobName");
        JobConfig jobConfig = this.batchProcessService.getJobConfig(jobName, jobGroup = actionForm.getString("jobGroup"));
        if (jobConfig == null) {
            jobConfig = new JobConfig();
            jobConfig.setJobName(jobName);
            jobConfig.setJobGroup(jobGroup);
        }
        jobConfig.setEmailDistributionList(actionForm.getString("emailDistributionList"));
        this.batchProcessService.saveJobConfig(jobConfig);
        if (!actionForm.get("previousTriggerStatus").equals("triggerStatus")) {
            if (TriggerStatus.NORMAL_STATUS.equals(actionForm.get("triggerStatus"))) {
                this.schedulingService.resumeJob(jobName, jobGroup);
            } else if (TriggerStatus.PAUSED_STATUS.equals(actionForm.get("triggerStatus"))) {
                this.schedulingService.pauseJob(jobName, jobGroup);
            }
        }
        this.addInformationMessage(request, "message.batchProcessConfig.success", jobName);
        return this.displayManagementDashboard(mapping, form, request, response);
    }

    public ActionForward executeBatchProcessWithArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BatchProcessDetail batchProcessDetail;
        DynaActionForm actionForm = (DynaActionForm)form;
        String jobName = actionForm.getString("jobName");
        Object[] invocationArgs = null;
        String invocationArgsStrArray = actionForm.getString("invocationArgs");
        if (StringUtils.isNotBlank((String)invocationArgsStrArray)) {
            invocationArgs = invocationArgsStrArray.split(" ");
        }
        if ((batchProcessDetail = (BatchProcessDetail)this.getLookupCacheService().getByCodeFromCache(BatchProcessDetail.class.getName(), jobName)) == null) {
            return mapping.findForward(BATCH_PROCESS_MGMT_FAILURE);
        }
        if (!batchProcessDetail.isExecutableFromManagementPage()) {
            return mapping.findForward(BATCH_PROCESS_MGMT_FAILURE);
        }
        this.invoker.invokeBatchProcessWithEvent(batchProcessDetail, invocationArgs);
        this.addInformationMessage(request, "message.batchProcessManagement.execute.success", jobName);
        return this.displayManagementDashboard(mapping, form, request, response);
    }

    public ActionForward pauseAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.schedulingService.pauseTriggerGroup("esr.common.static.triggers");
        this.addInformationMessage(request, "message.batchProcessManagement.pauseAll.success");
        return this.displayManagementDashboard(mapping, form, request, response);
    }

    public ActionForward resumeAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.schedulingService.resumeTriggerGroup("esr.common.static.triggers");
        this.addInformationMessage(request, "message.batchProcessManagement.resumeAll.success");
        return this.displayManagementDashboard(mapping, form, request, response);
    }

    public ActionForward viewHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BatchProcessDetailStatus job = this.initBatchProcessDetailStatus((DynaActionForm)form, request);
        List jobResults = this.batchProcessService.getFinishedJobResults(job.getBatchProcessDetail().getJobName(), job.getBatchProcessDetail().getJobGroup());
        if (jobResults != null && !jobResults.isEmpty()) {
            request.setAttribute("jobResults", (Object)jobResults);
        }
        return mapping.findForward(BATCH_PROCESS_HISTORY);
    }

    public ActionForward viewExecuteWithArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initBatchProcessDetailStatus((DynaActionForm)form, request);
        return mapping.findForward(BATCH_PROCESS_EXECUTE_WITH_ARGS);
    }

    public ActionForward viewConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm actionForm = (DynaActionForm)form;
        BatchProcessDetailStatus job = this.initBatchProcessDetailStatus((DynaActionForm)form, request);
        ArrayList<String> triggerStatuses = (ArrayList<String>)request.getSession().getServletContext().getAttribute("triggerStatuses");
        if (triggerStatuses == null) {
            triggerStatuses = new ArrayList<String>();
            triggerStatuses.add(TriggerStatus.NORMAL_STATUS);
            triggerStatuses.add(TriggerStatus.PAUSED_STATUS);
            request.getSession().getServletContext().setAttribute("triggerStatuses", triggerStatuses);
        }
        actionForm.set("triggerStatus", (Object)job.getTriggerStatus().getStatus());
        actionForm.set("previousTriggerStatus", (Object)job.getTriggerStatus().getStatus());
        JobConfig config = this.batchProcessService.getJobConfig(job.getBatchProcessDetail().getJobName(), job.getBatchProcessDetail().getJobGroup());
        if (config != null) {
            actionForm.set("emailDistributionList", (Object)config.getEmailDistributionList());
        }
        return mapping.findForward(BATCH_PROCESS_CONFIG);
    }

    private BatchProcessDetailStatus initBatchProcessDetailStatus(DynaActionForm form, HttpServletRequest request) throws Exception {
        String jobName = form.getString("jobName");
        BatchProcessDetailStatus status = new BatchProcessDetailStatus();
        BatchProcessDetail detail = (BatchProcessDetail)this.getLookupCacheService().getByCodeFromCache(BatchProcessDetail.class.getName(), jobName);
        status.setBatchProcessDetail(detail);
        TriggerStatus triggerStatus = this.schedulingService.getTriggerStatus(detail.getTriggerName(), detail.getTriggerGroup());
        status.setTriggerStatus(triggerStatus);
        request.setAttribute("job", (Object)status);
        return status;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("batchProcess.management.display", "displayManagementDashboard");
        map.put("batchProcess.active.display", "displayActiveJobs");
        map.put("button.batchProcessManagement.pauseAll", "pauseAll");
        map.put("button.batchProcessManagement.resumeAll", "resumeAll");
        map.put("link.batchProcessManagement.execute", "executeBatchProcess");
        map.put("link.batchProcessManagement.viewExecuteWithArgs", "viewExecuteWithArgs");
        map.put("button.batchProcessDetail.executeWithArgs", "executeBatchProcessWithArgs");
        map.put("link.batchProcessManagement.viewConfig", "viewConfig");
        map.put("button.batchProcessDetail.updateConfig", "updateConfig");
        map.put("link.batchProcessActive.markAsCancelled", "markActiveJobAsCancelled");
        map.put("link.batchProcessActive.markAsError", "markActiveJobAsError");
        map.put("link.batchProcessManagement.history", "viewHistory");
        return map;
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.invoker, (String)"A BatchProcessInvoker must be non-null");
        Validate.notNull((Object)this.schedulingService, (String)"A schedulingService must be non-null");
        Validate.notNull((Object)this.batchProcessService, (String)"A batchProcessService must be non-null");
    }

    public BatchProcessInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(BatchProcessInvoker invoker) {
        this.invoker = invoker;
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public BatchProcessService getBatchProcessService() {
        return this.batchProcessService;
    }

    public void setBatchProcessService(BatchProcessService batchProcessService) {
        this.batchProcessService = batchProcessService;
    }
}

