/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.beans.EntityHistory;
import gov.va.med.esr.ui.common.beans.FieldHistoryInfo;
import gov.va.med.esr.ui.common.beans.FormattingTableRow;
import gov.va.med.esr.ui.common.beans.TableRow;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AbstractUserProfileAction
extends AbstractAction {
    public static final String ERRORS_ACTIVE_DATE_PAST = "error.activeDatePast";
    public static final String ERRORS_INACTIVE_DATE_PAST = "error.inactiveDatePast";

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.clearSessionData(request);
        return mapping.findForward("cancel");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return mapping.findForward("clear");
    }

    public ActionForward returnToEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AbstractKeyedEntity pristine = (AbstractKeyedEntity)this.getPristineEntity(request);
        AbstractKeyedEntity updated = (AbstractKeyedEntity)this.getUpdatedEntity(request);
        if (pristine == null) {
            return this.discard(mapping, form, request, response);
        }
        if (updated != null && updated.getClass().getName().equals(pristine.getClass().getName())) {
            EntityKey key1 = pristine.getEntityKey();
            EntityKey key2 = updated.getEntityKey();
            if (key1.getKeyValue().equals(key2.getKeyValue())) {
                return this.revise(mapping, form, request, response);
            }
        }
        this.setUpdatedEntity(request, pristine.clone());
        return this.revise(mapping, form, request, response);
    }

    public ActionForward revise(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward discard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected void clearSessionData(HttpServletRequest request) throws Exception {
        this.setPristineEntity(request, null);
        this.setUpdatedEntity(request, null);
    }

    protected void populateReferenceData(HttpServletRequest request) throws Exception {
        List set = this.getUserAdminService().getAllCapabilitySets();
        List roles = this.getUserAdminService().getAllRoles();
        request.getSession().setAttribute("REF_CAPABILITY_SETS", (Object)this.conevrtToKeyMap(set));
        request.getSession().setAttribute("REF_ROLES", (Object)this.conevrtToKeyMap(roles));
    }

    protected List processCapabilitySets(List sets) {
        ArrayList<TableRow> filedHistoryList = new ArrayList<TableRow>();
        if (sets != null && sets.size() > 0) {
            FormattingTableRow infoBean = new FormattingTableRow("label.assignedCapabilitySets");
            filedHistoryList.add(infoBean);
            for (EntityHistory entityHistory : sets) {
                CapabilitySet current = (CapabilitySet)entityHistory.getCurrent();
                CapabilitySet previous = (CapabilitySet)entityHistory.getPrevious();
                String curValue = current == null ? "" : current.getName();
                String oldValue = previous == null ? "" : previous.getName();
                filedHistoryList.add(new FieldHistoryInfo("label.name", curValue, oldValue));
            }
        }
        return filedHistoryList;
    }

    protected List processRoles(List roles) {
        ArrayList<TableRow> filedHistoryList = new ArrayList<TableRow>();
        if (roles != null && roles.size() > 0) {
            FormattingTableRow infoBean = new FormattingTableRow("label.assignedRoles");
            filedHistoryList.add(infoBean);
            for (EntityHistory entityHistory : roles) {
                ESRRolePrincipalImpl current = (ESRRolePrincipalImpl)entityHistory.getCurrent();
                ESRRolePrincipalImpl previous = (ESRRolePrincipalImpl)entityHistory.getPrevious();
                String curValue = current == null ? "" : current.getName();
                String oldValue = previous == null ? "" : previous.getName();
                filedHistoryList.add(new FieldHistoryInfo("label.name", curValue, oldValue));
            }
        }
        return filedHistoryList;
    }

    protected List processCapabilities(List capabilityList) {
        ArrayList<TableRow> filedHistoryList = new ArrayList<TableRow>();
        if (capabilityList != null && capabilityList.size() > 0) {
            FormattingTableRow infoBean = new FormattingTableRow("label.assignedCapabilities");
            filedHistoryList.add(infoBean);
            for (EntityHistory entityHistory : capabilityList) {
                Capability current = (Capability)entityHistory.getCurrent();
                Capability previous = (Capability)entityHistory.getPrevious();
                String curValue = current == null ? "" : current.getName();
                String oldValue = previous == null ? "" : previous.getName();
                filedHistoryList.add(new FieldHistoryInfo("label.name", curValue, oldValue));
            }
        }
        return filedHistoryList;
    }

    private Map conevrtToKeyMap(List list) {
        HashMap<String, AbstractKeyedEntity> map = new HashMap<String, AbstractKeyedEntity>();
        if (list == null || list.size() == 0) {
            return map;
        }
        for (AbstractKeyedEntity entity : list) {
            map.put(entity.getEntityKey().getKeyValueAsString(), entity);
        }
        return map;
    }
}

