/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;
import gov.va.med.caip.client.exceptions.CaipException;
import gov.va.med.caip.client.exceptions.CaipJMSUtilityException;
import gov.va.med.caip.client.location.ServiceFacadeJMS;
import gov.va.med.caip.client.location.ServiceFacadeRemoteEJB;
import gov.va.med.caip.client.utils.JMSUtilities;
import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.ExternalService;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public abstract class ExternalServiceImpl
implements ExternalService {
    private static final long serialVersionUID = -1370346746640850300L;
    private static final String MESSAGE_TYPE = "Message_Type";
    private static final String INITIATER = "Message_Initiater";
    private ServiceFacadeRemoteEJB caipFacadeForEJB;
    private ServiceFacadeJMS caipFacadeForJMS;

    protected synchronized EJBObject getEJB() throws RemoteException, CreateException {
        return this.createEJB(this.getEJBHome());
    }

    protected abstract EJBObject createEJB(EJBHome var1) throws RemoteException, CreateException;

    private EJBHome getEJBHome() {
        return this.caipFacadeForEJB.getEjbHomeReference();
    }

    public abstract BusinessDelegateInfo getBusinessDelegateInterfaceInfo();

    public void setServiceFacade(ServiceFacadeRemoteEJB caipFacadeForEJB) throws CaipException {
        this.caipFacadeForEJB = caipFacadeForEJB;
    }

    public void setServiceFacade(ServiceFacadeJMS caipFacadeForJMS) throws CaipException {
        this.caipFacadeForJMS = caipFacadeForJMS;
    }

    private ObjectMessage createObjectMessage() throws ESRException {
        try {
            return JMSUtilities.createObjectMessage((Session)this.caipFacadeForJMS.getSession());
        }
        catch (CaipJMSUtilityException e) {
            throw new ESRException("Unable to create JMS Message", e);
        }
    }

    public void sendMessage(Serializable payload, String messageType, String initiater, String destinationKey) throws ESRException {
        try {
            ObjectMessage msg = this.createObjectMessage();
            msg.setObject(payload);
            msg.setStringProperty(MESSAGE_TYPE, messageType);
            msg.setStringProperty(INITIATER, initiater);
            msg.setStringProperty("Destination_Key", destinationKey);
            JMSUtilities.sendMessage((Connection)this.caipFacadeForJMS.getConnection(), (Session)this.caipFacadeForJMS.getSession(), (Destination)this.caipFacadeForJMS.getDestination(), (Message)msg);
        }
        catch (Exception e) {
            throw new ESRException("Unable to send JMS Message", e);
        }
    }
}

