/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import java.text.NumberFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemUtils
extends org.apache.commons.lang.SystemUtils {
    public static final String ALWAYS_LOGGER = "ALWAYS_LOGGER";
    protected static final Log logger = LogFactory.getLog(SystemUtils.class);
    protected static final Runtime runtime = Runtime.getRuntime();

    public static void logAllStats() {
        SystemUtils.logAllStats(false);
    }

    public static void logAllStats(boolean garbageCollectFirst) {
        SystemUtils.logSystemStats();
        SystemUtils.logMemory(garbageCollectFirst);
    }

    public static void logSystemStats() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("OS Name: " + OS_NAME + LINE_SEPARATOR + "OS Version: " + OS_VERSION + LINE_SEPARATOR + "Java Version: " + JAVA_VERSION_FLOAT + LINE_SEPARATOR + "Available Processors: " + runtime.availableProcessors()));
        }
    }

    public static void logMemory() {
        SystemUtils.logMemory(false);
    }

    public static void logMemory(boolean garbageCollectFirst) {
        if (logger.isInfoEnabled()) {
            if (garbageCollectFirst) {
                runtime.gc();
            }
            SystemUtils.logMemory(SystemUtils.getMaxMemory(), SystemUtils.getAvailableMemory(), SystemUtils.getUsedMemory());
        }
    }

    public static void logMemory(long maxMemory, long availableMemory, long usedMemory) {
        if (logger.isInfoEnabled()) {
            NumberFormat nf = NumberFormat.getInstance();
            NumberFormat nfp = NumberFormat.getPercentInstance();
            logger.info((Object)("Used Memory:      " + nf.format(usedMemory) + " bytes (" + nfp.format((float)usedMemory / (float)maxMemory) + ")" + LINE_SEPARATOR + "Available Memory: " + nf.format(availableMemory) + " bytes (" + nfp.format((float)availableMemory / (float)maxMemory) + ")" + LINE_SEPARATOR + "Max Memory:       " + nf.format(maxMemory) + " bytes"));
        }
    }

    public static void logMemoryDelta(long oldUsedMemory) {
        SystemUtils.logMemoryDelta(null, oldUsedMemory, SystemUtils.getUsedMemory());
    }

    public static void logMemoryDelta(String context, long oldUsedMemory) {
        SystemUtils.logMemoryDelta(context, oldUsedMemory, SystemUtils.getUsedMemory());
    }

    public static void logMemoryDelta(String context, long oldUsedMemory, long newUsedMemory) {
        if (logger.isInfoEnabled()) {
            NumberFormat nf = NumberFormat.getInstance();
            NumberFormat nfp = NumberFormat.getPercentInstance();
            StringBuffer buf = new StringBuffer();
            if (context != null) {
                buf.append("[").append(context).append("] ");
            }
            buf.append("Delta Memory:     ").append(nf.format(newUsedMemory - oldUsedMemory));
            buf.append(" bytes (").append(nfp.format((float)(newUsedMemory - oldUsedMemory) / (float)SystemUtils.getMaxMemory()) + ")");
            logger.info((Object)buf.toString());
        }
    }

    public static long getMaxMemory() {
        return runtime.maxMemory();
    }

    public static long getAvailableMemory() {
        return SystemUtils.getMaxMemory() - runtime.totalMemory() + runtime.freeMemory();
    }

    public static long getUsedMemory() {
        return SystemUtils.getMaxMemory() - SystemUtils.getAvailableMemory();
    }
}

