/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.util.Reflector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.io.ClassPathResource;

public class ObjectVersioningUtil
extends AbstractComponent {
    private static String FILE_EXTENSION = ".ser";
    private static String FILE_LOCATION_ROOT = "versionedObjects";
    private static String FILE_LOCATION_RELATIVE = "." + SystemUtils.FILE_SEPARATOR + "config" + SystemUtils.FILE_SEPARATOR + "test" + SystemUtils.FILE_SEPARATOR + "data" + SystemUtils.FILE_SEPARATOR + FILE_LOCATION_ROOT + SystemUtils.FILE_SEPARATOR;

    private static InputStream getSerializedFileInputStream(String className) throws IOException {
        InputStream inputStream = null;
        ClassPathResource resource = new ClassPathResource(FILE_LOCATION_ROOT + SystemUtils.FILE_SEPARATOR + className + FILE_EXTENSION);
        if (resource.exists()) {
            inputStream = resource.getInputStream();
        } else {
            File file = new File(FILE_LOCATION_RELATIVE + className + FILE_EXTENSION);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            }
        }
        if (inputStream == null) {
            throw new IOException("Unable to create an InputStream for Class " + className + " (perhaps the serialized file is not in the path)");
        }
        return inputStream;
    }

    public static void deserializeFiles(Class[] targetClasses) throws Exception {
        String className = null;
        ArrayList<String> failed = new ArrayList<String>();
        for (int i = 0; i < targetClasses.length; ++i) {
            className = targetClasses[i].getName();
            try {
                System.out.println("Deserialization passed for: " + SerializationUtils.deserialize((InputStream)ObjectVersioningUtil.getSerializedFileInputStream(className)).getClass().getName());
                continue;
            }
            catch (Exception e) {
                failed.add(className);
                System.out.println("Deserialization failed for [" + className + "] with exception: " + e);
            }
        }
        if (!failed.isEmpty()) {
            throw new SerializationException("Failed deserialization results: " + failed);
        }
    }

    public static void generateSerializedFiles(Class[] targetClasses, String optionalLabel, Object objectFactory) throws Exception {
        String className = null;
        ArrayList<String> failed = new ArrayList<String>();
        File fileLocationRoot = new File(FILE_LOCATION_RELATIVE);
        if (!fileLocationRoot.exists()) {
            fileLocationRoot.mkdir();
        }
        Serializable targetObject = null;
        for (int i = 0; i < targetClasses.length; ++i) {
            className = targetClasses[i].getName();
            try {
                targetObject = (Serializable)Reflector.invoke(objectFactory, "generate" + ClassUtils.getShortClassName((Class)targetClasses[i]), null);
                if (targetObject instanceof TriggerEvent) {
                    ((TriggerEvent)targetObject).setName(optionalLabel);
                }
                if (targetObject instanceof BeanNameAware) {
                    ((BeanNameAware)targetObject).setBeanName(optionalLabel);
                }
                ObjectVersioningUtil.createSerializedFile(targetObject);
                continue;
            }
            catch (Exception e) {
                failed.add(className);
                e.printStackTrace();
                System.out.println("Unable to create serialized file for [" + className + "] due to exception: " + e);
            }
        }
        if (!failed.isEmpty()) {
            throw new SerializationException("Failed serialization results: " + failed);
        }
    }

    private static void createSerializedFile(Serializable object) throws Exception {
        FileOutputStream out = new FileOutputStream(FILE_LOCATION_RELATIVE + object.getClass().getName() + FILE_EXTENSION);
        SerializationUtils.serialize((Serializable)object, (OutputStream)out);
        System.out.println("Serialized class to file: " + object.getClass().getName());
    }
}

