/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.Validate;

public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    public static final String MM = "MM";
    public static final String MMDD = "MM/dd";
    public static final String YYYY = "yyyy";
    public static final String MMYYYY = "MM/yyyy";
    public static final String MMDDYYYY = "MM/dd/yyyy";
    public static final String MMDDYYYYHHMMSS = "MM/dd/yyyy h:mm:ssa";
    public static final String MMDDYYYYHHMM_EDIT = "MM/dd/yyyy HH:mm";
    public static final Code FIRST_QUARTER = new Code("1");
    public static final Code SECOND_QUARTER = new Code("2");
    public static final Code THIRD_QUARTER = new Code("3");
    public static final Code FOURTH_QUARTER = new Code("4");
    public static final String[] FISCAL_QUARTERS = new String[]{FIRST_QUARTER.getCode(), SECOND_QUARTER.getCode(), THIRD_QUARTER.getCode(), FOURTH_QUARTER.getCode()};

    private DateUtils() {
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isBlank((String)format)) {
            format = MMDDYYYY;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        return sdf.format(date);
    }

    public static Calendar createCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar createCalendar(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar;
    }

    public static Calendar createCalendar(int year, int month) {
        Calendar calendar = DateUtils.createCalendar(year);
        calendar.set(2, month - 1);
        return calendar;
    }

    public static Calendar createCalendar(int year, int month, int day) {
        Calendar calendar = DateUtils.createCalendar(year, month);
        calendar.set(5, day);
        return calendar;
    }

    public static Calendar createCalendar(int year, int month, int day, int hour) {
        Calendar calendar = DateUtils.createCalendar(year, month, day);
        calendar.set(11, hour);
        return calendar;
    }

    public static Calendar createCalendar(int year, int month, int day, int hour, int minute) {
        Calendar calendar = DateUtils.createCalendar(year, month, day, hour);
        calendar.set(12, minute);
        return calendar;
    }

    public static Calendar createCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = DateUtils.createCalendar(year, month, day, hour, minute);
        calendar.set(13, second);
        return calendar;
    }

    public static Calendar createCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar calendar = DateUtils.createCalendar(year, month, day, hour, minute, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    public static Calendar getFiscalYearFirstQuarter(int year, boolean startDate) {
        Calendar time = DateUtils.createCalendar(year);
        GregorianCalendar calendar = new GregorianCalendar(time.get(1), time.get(2), time.get(5));
        if (startDate) {
            calendar.roll(2, -3);
            calendar.roll(1, -1);
            return calendar;
        }
        calendar.roll(5, -1);
        calendar.roll(2, -1);
        calendar.roll(1, -1);
        return calendar;
    }

    public static Calendar getFiscalYearSecondQuarter(int year, boolean startDate) {
        Calendar time = DateUtils.createCalendar(year);
        GregorianCalendar calendar = new GregorianCalendar(time.get(1), time.get(2), time.get(5));
        if (startDate) {
            return calendar;
        }
        calendar.roll(2, 2);
        calendar.set(5, 31);
        return calendar;
    }

    public static Calendar getFiscalYearThirdQuarter(int year, boolean startDate) {
        Calendar time = DateUtils.createCalendar(year);
        GregorianCalendar calendar = new GregorianCalendar(time.get(1), time.get(2), time.get(5));
        if (startDate) {
            calendar.roll(2, 3);
            return calendar;
        }
        calendar.roll(2, 5);
        calendar.set(5, 30);
        return calendar;
    }

    public static Calendar getFiscalYearFourthQuarter(int year, boolean startDate) {
        Calendar time = DateUtils.createCalendar(year);
        GregorianCalendar calendar = new GregorianCalendar(time.get(1), time.get(2), time.get(5));
        if (startDate) {
            calendar.roll(2, 6);
            return calendar;
        }
        calendar.roll(2, 8);
        calendar.set(5, 30);
        return calendar;
    }

    public static Calendar getFiscalYearQuarter(int year, boolean startDate, String quarter) {
        Calendar calendar = null;
        if (FIRST_QUARTER.getCode().equals(quarter)) {
            calendar = DateUtils.getFiscalYearFirstQuarter(year, startDate);
        } else if (SECOND_QUARTER.getCode().equals(quarter)) {
            calendar = DateUtils.getFiscalYearSecondQuarter(year, startDate);
        } else if (THIRD_QUARTER.getCode().equals(quarter)) {
            calendar = DateUtils.getFiscalYearThirdQuarter(year, startDate);
        } else if (FOURTH_QUARTER.getCode().equals(quarter)) {
            calendar = DateUtils.getFiscalYearFourthQuarter(year, startDate);
        }
        return calendar;
    }

    public static int getFiscalYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFiscalYear(calendar);
    }

    public static int getFiscalYear(Calendar calendar) {
        Validate.notNull((Object)calendar, (String)"A calendar must not be null");
        int year = calendar.get(1);
        Date start = DateUtils.getFiscalYearFirstQuarter(year, true).getTime();
        Date end = DateUtils.getFiscalYearFourthQuarter(year, false).getTime();
        Date date = calendar.getTime();
        if (!start.equals(date) && !start.before(date) || !end.equals(date) && !end.after(date)) {
            ++year;
        }
        return year;
    }

    public static boolean isDateInYear(Integer year, Date date) {
        Validate.notNull((Object)year, (String)"A year code must not be null");
        Validate.notNull((Object)date, (String)"A date must not be null");
        Calendar start = Calendar.getInstance();
        start.set(year, 0, 1, 0, 0, 0);
        Calendar end = Calendar.getInstance();
        end.set(year, 11, 31, 23, 59, 59);
        return DateUtils.isDateBetween(date, start.getTime(), end.getTime());
    }

    public static boolean isDateBetween(Date date, Date start, Date end) {
        boolean inBetween = false;
        if ((start.equals(date) || start.before(date)) && (end.equals(date) || end.after(date))) {
            inBetween = true;
        }
        return inBetween;
    }

    public static String getQuarterAsString(Date date) {
        return DateUtils.getQuarter(date) + " Quarter";
    }

    public static String getQuarter(Date date) {
        String quarter = null;
        for (int i = 0; i < FISCAL_QUARTERS.length; ++i) {
            if (!DateUtils.isInQuarter(FISCAL_QUARTERS[i], date)) continue;
            quarter = String.valueOf(i + 1);
        }
        return quarter;
    }

    public static String getQuarterDateRangeAsString(Date date) {
        DateFormat df = DateFormat.getDateInstance(2);
        Calendar[] calendars = null;
        for (int i = 0; i < FISCAL_QUARTERS.length; ++i) {
            if (!DateUtils.isInQuarter(FISCAL_QUARTERS[i], date)) continue;
            calendars = DateUtils.getStartEndDateForQuarter(FISCAL_QUARTERS[i], date);
            break;
        }
        return calendars != null ? df.format(calendars[0].getTime()) + " - " + df.format(calendars[1].getTime()) : null;
    }

    public static boolean isInQuarter(String quarter, Date date) {
        Validate.notNull((Object)date, (String)"A date must not be null");
        Validate.notNull((Object)quarter, (String)"A quarter code must not be null");
        Calendar[] calendars = DateUtils.getStartEndDateForQuarter(quarter, date);
        Date start = calendars[0].getTime();
        Date end = calendars[1].getTime();
        return DateUtils.isDateBetween(date, start, end);
    }

    public static Calendar[] getStartEndDateForQuarter(String quarter, Date date) {
        Calendar[] calendars = new Calendar[2];
        int year = DateUtils.getFiscalYear(date);
        for (int i = 0; i < FISCAL_QUARTERS.length; ++i) {
            if (!FISCAL_QUARTERS[i].equals(quarter)) continue;
            calendars[0] = DateUtils.getFiscalYearQuarter(year, true, FISCAL_QUARTERS[i]);
            calendars[1] = DateUtils.getFiscalYearQuarter(year, false, FISCAL_QUARTERS[i]);
            break;
        }
        return calendars;
    }

    public static int getQuarterNumber(Date date) {
        int quarter = 0;
        if (date != null) {
            for (int i = 0; i < FISCAL_QUARTERS.length; ++i) {
                if (!DateUtils.isInQuarter(FISCAL_QUARTERS[i], date)) continue;
                quarter = i + 1;
            }
        }
        return quarter;
    }

    public static Calendar[] getStartEndDateForPreviousQuarter(Date date) {
        Calendar[] calendars = new Calendar[2];
        if (date != null) {
            int previousQuarter = 0;
            int currentQuarter = DateUtils.getQuarterNumber(date);
            int year = DateUtils.getFiscalYear(date);
            if (String.valueOf(currentQuarter).equals(FIRST_QUARTER.getCode())) {
                --year;
                previousQuarter = 4;
            } else {
                previousQuarter = currentQuarter - 1;
            }
            calendars[0] = DateUtils.getFiscalYearQuarter(year, true, String.valueOf(previousQuarter));
            calendars[1] = DateUtils.getFiscalYearQuarter(year, false, String.valueOf(previousQuarter));
        }
        return calendars;
    }

    public static Calendar[] getStartEndDateForFiscalYear(Date date) {
        Calendar[] calendars = new Calendar[2];
        if (date != null) {
            int year = DateUtils.getFiscalYear(date);
            calendars[0] = DateUtils.getFiscalYearQuarter(year, true, FIRST_QUARTER.getCode());
            calendars[1] = DateUtils.getFiscalYearQuarter(year, false, FOURTH_QUARTER.getCode());
        }
        return calendars;
    }

    public static Calendar[] getStartEndDateForPreviousFiscalYear(Date date) {
        Calendar[] calendars = new Calendar[2];
        if (date != null) {
            int year = DateUtils.getFiscalYear(date);
            calendars[0] = DateUtils.getFiscalYearQuarter(year - 1, true, FIRST_QUARTER.getCode());
            calendars[1] = DateUtils.getFiscalYearQuarter(year - 1, false, FOURTH_QUARTER.getCode());
        }
        return calendars;
    }

    public static Calendar[] getStartEndDateForPreviousMonth(Date date) {
        Calendar[] calendars = new Calendar[2];
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int month = calendar.get(2);
            calendar.set(2, month - 1);
            calendars[0] = DateUtils.createCalendar(calendar.get(1), calendar.get(2) + 1, 1);
            calendars[1] = DateUtils.createCalendar(calendar.get(1), calendar.get(2) + 1, calendar.getActualMaximum(5));
        }
        return calendars;
    }

    public static Calendar[] getStartEndDateForPreviousWeek(Date date) {
        Calendar[] calendars = new Calendar[2];
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(7, 1);
            int weekOfMonth = calendar.get(4);
            calendar.set(4, weekOfMonth - 1);
            calendars[0] = DateUtils.createCalendar(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
            calendar.set(7, 7);
            calendars[1] = DateUtils.createCalendar(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        }
        return calendars;
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date getCurrentDateTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Date getYesterdayDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date getTomorrowDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static boolean isBefore(Date date1, Date date2) {
        boolean compare = false;
        if (date1 != null && date2 != null) {
            compare = date1.before(date2);
        } else if (date1 != null) {
            compare = true;
        } else if (date2 != null) {
            compare = false;
        }
        return compare;
    }

    public static boolean isBeforeIgnoreTime(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return false;
        }
        if (date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return DateUtils.isBefore(DateUtils.truncate((Date)date1, (int)5), DateUtils.truncate((Date)date2, (int)5));
    }

    public static boolean isEqualOrBeforeIgnoreTime(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2) || DateUtils.isBefore(DateUtils.truncate((Date)date1, (int)5), DateUtils.truncate((Date)date2, (int)5));
    }

    public static boolean isEqualOrBefore(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2) || DateUtils.isBefore(date1, date2);
    }

    public static boolean isAfter(Date date1, Date date2) {
        boolean compare = false;
        if (date1 != null && date2 != null) {
            compare = date1.after(date2);
        } else if (date1 != null) {
            compare = true;
        } else if (date2 != null) {
            compare = false;
        }
        return compare;
    }

    public static boolean isAfterIgnoreTime(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return false;
        }
        if (date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return DateUtils.isAfter(DateUtils.truncate((Date)date1, (int)5), DateUtils.truncate((Date)date2, (int)5));
    }

    public static boolean isEqualOrAfterIgnoreTime(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2) || DateUtils.isAfter(DateUtils.truncate((Date)date1, (int)5), DateUtils.truncate((Date)date2, (int)5));
    }

    public static boolean isEqualOrAfter(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2) || DateUtils.isAfter(date1, date2);
    }

    public static Date getYearStartDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, 0, 1);
        return cal.getTime();
    }

    public static Date getYearEndDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, 11, 31);
        return cal.getTime();
    }

    public static Date getAddedDate(int field, int amount) {
        Calendar time = Calendar.getInstance();
        return DateUtils.getAddedDate(field, amount, time);
    }

    public static Date getAddedDate(int field, int amount, Calendar time) {
        GregorianCalendar calendar = new GregorianCalendar(time.get(1), time.get(2), time.get(5), time.get(11), time.get(12), time.get(13));
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static class Code
    extends AbstractCode {
        private static final long serialVersionUID = 1L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code)Code.getCode(Code.class, code);
        }
    }
}

