/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckSerialVersionUtil
extends AbstractComponent {
    private static final int MASK = 24;
    public static final String MISSING_SER_LIST = "missingSerList";
    public static final String ERROR_LIST = "errorList";

    public static Map checkSerialVersionUID(String clsRootDirectory) throws Exception {
        if (StringUtils.isEmpty((String)clsRootDirectory)) {
            throw new Exception("Classes root directory is null");
        }
        HashMap retMap = new HashMap();
        ArrayList missingSerList = new ArrayList();
        ArrayList errorList = new ArrayList();
        CheckSerialVersionUtil.check(clsRootDirectory, clsRootDirectory.length() + 1, missingSerList, errorList);
        if (!missingSerList.isEmpty()) {
            retMap.put(MISSING_SER_LIST, missingSerList);
        }
        if (!errorList.isEmpty()) {
            retMap.put(ERROR_LIST, errorList);
        }
        return retMap;
    }

    public static void check(String clsRootDirectory, int strip, List missingSerList, List errorList) {
        String[] files = new File(clsRootDirectory).list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String file = clsRootDirectory + File.separatorChar + files[i];
            if (file.endsWith(".class")) {
                CheckSerialVersionUtil.checkClass(file, strip, missingSerList, errorList);
                continue;
            }
            if (!new File(file).isDirectory()) continue;
            CheckSerialVersionUtil.check(file, strip, missingSerList, errorList);
        }
    }

    private static void checkClass(String file, int strip, List missingSerList, List errorList) {
        file = file.substring(strip, file.length() - 6);
        file = file.replace(File.separatorChar, '.');
        try {
            Class<?> c = Class.forName(file);
            if (c.isInterface() || !Serializable.class.isAssignableFrom(c)) {
                return;
            }
            Field f = c.getDeclaredField("serialVersionUID");
            if ((f.getModifiers() & 0x18) != 24) {
                missingSerList.add(file);
            }
        }
        catch (ClassNotFoundException e) {
            errorList.add(file);
        }
        catch (NoClassDefFoundError e) {
            errorList.add(file);
        }
        catch (NoSuchFieldException e) {
            missingSerList.add(file);
        }
    }
}

