/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.filter;

import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.ui.filter.WebSecurityFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;

public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String errorURL = null;
    private HttpServletResponse servletResponse = null;
    protected WebSecurityFilter webSecurityFilter;

    public WebSecurityFilter getWebSecurityFilter() {
        return this.webSecurityFilter;
    }

    public void setWebSecurityFilter(WebSecurityFilter webSecurityFilter) {
        this.webSecurityFilter = webSecurityFilter;
    }

    public XSSRequestWrapper(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String errorURL) {
        super(servletRequest);
        this.servletResponse = servletResponse;
        this.errorURL = errorURL;
        try {
            HttpServletRequest req = servletRequest;
            if (this.webSecurityFilter == null) {
                WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext(req.getSession().getServletContext());
                this.webSecurityFilter = (WebSecurityFilter)((Object)ac.getBean("webSecurityFilter"));
                this.setErrorPage(this.webSecurityFilter.getSsoErrorUrl());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to obtain an webSecurityFilter", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("XSSRequestWrapper : errorURL is " + errorURL));
        }
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.stripXSS(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        return this.stripXSS(value);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return this.stripXSS(value);
    }

    private String stripXSS(String value) {
        if (value != null) {
            String orgValue = value;
            int orgValueLength = value.length();
            value = value.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            if (value.length() != orgValueLength) {
                this.logger.warn((Object)("Possible XSS Attack received - original value is " + orgValue + " !!!"));
                this.logger.warn((Object)("Value is stripped to " + value));
                try {
                    if (this.getErrorPage() != null) {
                        this.servletResponse.sendRedirect(this.getErrorPage());
                    }
                }
                catch (IOException ioe) {
                    this.logger.warn((Object)("Error occured when redirecting to Security Error Page is " + ioe.getMessage()));
                }
            }
        }
        return value;
    }

    public String getErrorPage() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getErrorPage errorURL is " + this.errorURL));
        }
        return this.errorURL;
    }

    public void setErrorPage(String errorURL) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("setErrorPage errorURL is " + errorURL));
        }
        this.errorURL = errorURL;
    }
}

