/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParamFilter
implements Filter {
    private Pattern pattern;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.pattern = Pattern.compile(filterConfig.getInitParameter("excludeParams"), 32);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)new ParamFilteredRequest(request, this.pattern), response);
    }

    public void destroy() {
    }

    static class ParamFilteredRequest
    extends HttpServletRequestWrapper {
        private final String body;
        private final Pattern pattern;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ParamFilteredRequest(ServletRequest request, Pattern pattern) {
            super((HttpServletRequest)request);
            this.pattern = pattern;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                ServletInputStream inputStream = request.getInputStream();
                if (inputStream != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                    char[] charBuffer = new char[128];
                    int bytesRead = -1;
                    while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                        stringBuilder.append(charBuffer, 0, bytesRead);
                    }
                } else {
                    stringBuilder.append("");
                }
            }
            catch (IOException ex) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {}
                }
            }
            this.body = stringBuilder.toString();
        }

        public Enumeration getParameterNames() {
            ArrayList<String> requestParameterNames = Collections.list(super.getParameterNames());
            ArrayList<String> finalParameterNames = new ArrayList<String>();
            for (String parameterName : requestParameterNames) {
                if (this.pattern.matcher(parameterName).matches()) continue;
                finalParameterNames.add(parameterName);
            }
            return Collections.enumeration(finalParameterNames);
        }

        public ServletInputStream getInputStream() throws IOException {
            System.out.println(this.body);
            final ByteArrayInputStream byteArrayInputStream = this.pattern.matcher(this.body).matches() ? new ByteArrayInputStream("".getBytes()) : new ByteArrayInputStream(this.body.getBytes());
            return new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }
            };
        }
    }
}

