/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.filter;

import gov.va.med.fw.security.EncryptionServiceException;
import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.ui.filter.BaseFilter;
import gov.va.med.fw.ui.filter.DecryptedRequest;
import gov.va.med.fw.ui.security.UIEncryptionService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;

public class DecryptionFilter
extends BaseFilter {
    protected UIEncryptionService encryptionService;

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            if (this.encryptionService == null) {
                WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext(req.getSession().getServletContext());
                this.encryptionService = (UIEncryptionService)ac.getBean("encryptionService");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to obtain an encryption service", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        if (this.encryptionService == null || !this.encryptionService.isEncryptionEnabled()) {
            filterChain.doFilter(request, response);
            return;
        }
        if (request instanceof DecryptedRequest) {
            filterChain.doFilter(request, response);
            return;
        }
        try {
            DecryptedRequest wrapper = new DecryptedRequest(req, this.encryptionService);
            filterChain.doFilter((ServletRequest)wrapper, response);
        }
        catch (EncryptionServiceException decryptoEx) {
            this.logger.error((Object)decryptoEx);
            this.handleEncryptionError(req, res, decryptoEx);
        }
    }

    private void handleEncryptionError(HttpServletRequest request, HttpServletResponse response, Throwable exception) throws ServletException {
        try {
            if (this.logger.isWarnEnabled()) {
                StringBuffer userInfo = new StringBuffer();
                userInfo.append(" User IP = " + request.getRemoteHost());
                userInfo.append(" User Id = " + request.getRemoteUser());
                userInfo.append(" User URL = " + request.getRequestURL().toString());
                this.logger.warn((Object)userInfo, exception);
            }
            String encryptionErrorUrl = this.encryptionService.getEncryptionErrorUrl();
            RequestDispatcher reqDispatcher = request.getRequestDispatcher(encryptionErrorUrl);
            reqDispatcher.forward((ServletRequest)new DecryptedRequest(request), (ServletResponse)response);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error displaying error page", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }
}

