/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.trigger;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.Map;

public class TriggerEventConsumer
extends AbstractComponent {
    private Map triggerableServiceMap;

    public void trigger(TriggerEvent triggerEvent) throws ServiceException {
        if (triggerEvent != null) {
            TriggerableService triggerService;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received a trigger event " + triggerEvent));
            }
            if ((triggerService = this.getTriggerableService(triggerEvent.getTriggerIdentity())) != null) {
                triggerService.trigger(triggerEvent);
            }
        }
    }

    @Override
    public void afterPropertiesSet() {
        if (this.triggerableServiceMap == null) {
            throw new InvalidConfigurationException("triggerableServiceMap must be set on " + ((Object)((Object)this)).getClass().getName());
        }
    }

    protected TriggerableService getTriggerableService(TriggerIdentity triggerIdentity) {
        for (TriggerIdentity triggerIdentitySearch : this.triggerableServiceMap.keySet()) {
            if (!triggerIdentitySearch.getClass().equals(triggerIdentity.getClass())) continue;
            return (TriggerableService)this.triggerableServiceMap.get(triggerIdentitySearch);
        }
        return null;
    }

    public Map getTriggerableServiceMap() {
        return this.triggerableServiceMap;
    }

    public void setTriggerableServiceMap(Map triggerableServiceMap) {
        this.triggerableServiceMap = triggerableServiceMap;
    }
}

