/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.trigger;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.service.trigger.BaseTriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerEventMetrics;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class TriggerEvent
extends AbstractEntity {
    private static final String CONSUMER_ROUTING_KEY = "Message_Type";
    private static final String DESTINATION_TYPE = "Destination_Type";
    private static final long serialVersionUID = -591185356879397839L;
    private String name;
    private UserCredentials initiater;
    private TriggerEventMetrics eventMetrics;
    private TriggerIdentity triggerIdentity;
    private Serializable payload;

    public UserCredentials getInitiater() {
        return this.initiater;
    }

    public void setInitiater(UserCredentials initiater) {
        this.initiater = initiater;
    }

    public TriggerEvent(String name, Serializable payload, TriggerIdentity triggerIdentity) {
        if (name == null) {
            throw new IllegalArgumentException("TriggerEvent must have non-null name");
        }
        this.name = name;
        this.payload = payload;
        this.triggerIdentity = triggerIdentity;
        this.eventMetrics = new TriggerEventMetrics();
        this.eventMetrics.createdTimestamp = System.currentTimeMillis();
    }

    public TriggerEvent(String name, Serializable payload) {
        this(name, payload, TriggerEvent.createTriggerIdentity(TriggerIdentity.DestinationType.DEFAULT));
    }

    public TriggerEvent(String name) {
        this(name, null);
    }

    public TriggerEvent(TriggerIdentity triggerIdentity) {
        this(triggerIdentity != null ? triggerIdentity.getName() : null, null, triggerIdentity);
    }

    public static final TriggerIdentity createTriggerIdentity(TriggerIdentity.DestinationType destType) {
        return new BaseTriggerIdentity(destType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("TriggerEvent must have non-null name");
        }
        this.name = name;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("name", (Object)this.name);
        builder.append("payload", (Object)this.payload);
        builder.append("initiater", (Object)this.initiater);
        builder.append("triggerIdentity", (Object)this.triggerIdentity);
        builder.append("eventMetrics", (Object)this.eventMetrics);
    }

    public TriggerIdentity getTriggerIdentity() {
        return this.triggerIdentity;
    }

    public String getTriggerContext() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        this.buildContextString(builder);
        return builder.toString();
    }

    protected void buildContextString(ToStringBuilder builder) {
        builder.append("name", (Object)this.name);
        builder.append("initiater", (Object)SecurityContextHelper.getUserName(this.initiater));
    }

    public void setTriggerIdentity(TriggerIdentity triggerIdentity) {
        this.triggerIdentity = triggerIdentity;
    }

    public final void preTriggerInit() {
        if (this.eventMetrics != null) {
            this.eventMetrics.routedTimestamp = System.currentTimeMillis();
        }
        this.preTrigger();
    }

    public long getCreationDate() {
        return this.eventMetrics != null ? this.eventMetrics.createdTimestamp : 0L;
    }

    protected void preTrigger() {
    }

    protected void preConsumedInit() {
        if (this.eventMetrics != null) {
            this.eventMetrics.consumedTimestamp = System.currentTimeMillis();
        }
    }

    public String getConsumerRoutingKey() {
        String routingKey;
        String string = routingKey = this.getTriggerIdentity() != null && this.getTriggerIdentity().isUsedForConsumerRouting() ? this.getTriggerIdentity().getClass().getName() : this.getName();
        if (routingKey == null) {
            throw new IllegalStateException("Invalid TriggerEvent; getConsumerRoutingKey() can not return null");
        }
        return routingKey;
    }

    public Properties getRoutingProperties() {
        Properties props = new Properties();
        props.put(DESTINATION_TYPE, this.getTriggerIdentity().getDestinationType().getName());
        props.put(CONSUMER_ROUTING_KEY, this.getConsumerRoutingKey());
        return props;
    }

    public Serializable getPayload() {
        return this.payload;
    }

    public void setPayload(Serializable payload) {
        this.payload = payload;
    }
}

