/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.trigger;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractTriggerIdentity
extends AbstractEntity
implements TriggerIdentity {
    private static final long serialVersionUID = 5720385641520187408L;
    private TriggerIdentity.TargetType targetType;
    private TriggerIdentity.DestinationType destinationType;
    private TriggerIdentity.DispatchType dispatchType;
    private TriggerIdentity.EntityType entityType;
    private boolean usedForConsumerRouting = true;
    private transient String name;

    public AbstractTriggerIdentity() {
    }

    public AbstractTriggerIdentity(TriggerIdentity.DestinationType destinationType) {
        this.destinationType = destinationType;
        this.usedForConsumerRouting = false;
    }

    public AbstractTriggerIdentity(TriggerIdentity.DestinationType destinationType, TriggerIdentity.TargetType targetType, TriggerIdentity.DispatchType dispatchType) {
        this.destinationType = destinationType;
        this.targetType = targetType;
        this.dispatchType = dispatchType;
    }

    public AbstractTriggerIdentity(TriggerIdentity.DestinationType destinationType, TriggerIdentity.TargetType targetType, TriggerIdentity.DispatchType dispatchType, TriggerIdentity.EntityType entityType) {
        this(destinationType, targetType, dispatchType);
        this.entityType = entityType;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("destinationType", (Object)this.destinationType);
        builder.append("targetType", (Object)this.targetType);
        builder.append("dispatchType", (Object)this.dispatchType);
        builder.append("entityType", (Object)this.entityType);
    }

    @Override
    public TriggerIdentity.DestinationType getDestinationType() {
        return this.destinationType;
    }

    @Override
    public TriggerIdentity.TargetType getTargetType() {
        return this.targetType;
    }

    @Override
    public TriggerIdentity.DispatchType getDispatchType() {
        return this.dispatchType;
    }

    @Override
    public TriggerIdentity.EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.buildName();
    }

    protected String buildName() {
        StringBuffer buf = new StringBuffer(this.destinationType != null ? this.destinationType.getName() : "NO_DESTINATION");
        buf.append("-").append(this.targetType != null ? this.targetType.getName() : "NO_TARGET_TYPE");
        buf.append("-").append(this.dispatchType != null ? this.dispatchType.getName() : "NO_DISPATCH_TYPE");
        buf.append("-").append(this.entityType != null ? this.entityType.getName() : "NO_ENTITY_TYPE");
        return buf.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDispatchType(TriggerIdentity.DispatchType dispatchType) {
        this.dispatchType = dispatchType;
    }

    public void setEntityType(TriggerIdentity.EntityType entityType) {
        this.entityType = entityType;
    }

    public void setTargetType(TriggerIdentity.TargetType targetType) {
        this.targetType = targetType;
    }

    public void setDestinationType(TriggerIdentity.DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    @Override
    public boolean isUsedForConsumerRouting() {
        return this.usedForConsumerRouting;
    }

    public void setUsedForConsumerRouting(boolean usedForConsumerRouting) {
        this.usedForConsumerRouting = usedForConsumerRouting;
    }
}

