/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import gov.va.med.fw.cache.TransactionTimestampCacheManager;
import gov.va.med.fw.service.AbstractComponent;
import java.sql.Timestamp;
import org.apache.commons.lang.Validate;
import org.springframework.transaction.support.TransactionSynchronization;

public class TransactionSynchronizationForTimestamp
extends AbstractComponent
implements TransactionSynchronization {
    private TransactionTimestampCacheManager cacheManager;
    private Timestamp ts;

    public void suspend() {
        if (this.cacheManager.hasTimestamp()) {
            this.ts = this.cacheManager.removeTimestamp();
        }
    }

    public void resume() {
        if (this.ts != null) {
            this.cacheManager.storeTransactionTimestamp(this.ts);
        }
    }

    public void beforeCommit(boolean readOnly) {
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        this.cacheManager.removeTimestamp();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.cacheManager);
    }

    public TransactionTimestampCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(TransactionTimestampCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

