/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.support;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.support.SpawnedThread;
import gov.va.med.fw.service.support.SpawnedThreadTask;

public class SpawnedThreadInvoker
extends AbstractComponent {
    protected static int STATUS_SUCCESS = 0;
    protected static int STATUS_FAILURE = 1;
    protected static int STATUS_TIMEOUT = 2;
    protected int threadStatus;
    protected Throwable threadError;
    protected Object threadResult;
    protected Thread t;
    private int timeout = 120000;
    private boolean blocking;

    public SpawnedThreadInvoker(SpawnedThreadTask task) {
        this(task, false);
    }

    public SpawnedThreadInvoker(SpawnedThreadTask task, boolean blocking) {
        this.t = new SpawnedThread(task, this);
        this.blocking = blocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.blocking) {
            Thread thread = this.t;
            synchronized (thread) {
                this.t.start();
                try {
                    this.t.wait(this.timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Spawned thread has been interrupted, should not occur", e);
                }
            }
        }
        this.t.start();
    }

    protected Thread getCurrentThread() {
        return this.t;
    }

    public void abort() {
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isTimedOut() {
        return this.threadStatus == STATUS_TIMEOUT;
    }

    public boolean isFailed() {
        return this.threadStatus == STATUS_FAILURE;
    }

    public Throwable getError() {
        return this.threadError;
    }

    public Object getResult() {
        return this.threadResult;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }
}

