/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.support;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.support.SpawnedMethodInvocation;
import gov.va.med.fw.service.support.SpawnedThreadInvoker;
import gov.va.med.fw.util.TimeoutException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SpawnedThreadAdvice
extends AbstractComponent
implements MethodInterceptor {
    private boolean blocking = true;
    private Integer spawnedThreadTimeout;
    private boolean enabled = true;

    public Object invoke(MethodInvocation arg0) throws Throwable, TimeoutException {
        if (!this.enabled) {
            return arg0.proceed();
        }
        SpawnedMethodInvocation mi = new SpawnedMethodInvocation(arg0);
        SpawnedThreadInvoker invoker = new SpawnedThreadInvoker(mi, this.blocking);
        if (this.spawnedThreadTimeout != null) {
            invoker.setTimeout(this.spawnedThreadTimeout);
        }
        invoker.execute();
        if (invoker.isTimedOut()) {
            invoker.abort();
            throw new TimeoutException("Spawned thread has timed out while attempting to call: " + arg0.getMethod().getName());
        }
        if (invoker.isFailed()) {
            throw invoker.getError();
        }
        return invoker.getResult();
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public Integer getSpawnedThreadTimeout() {
        return this.spawnedThreadTimeout;
    }

    public void setSpawnedThreadTimeout(Integer spawnedThreadTimeout) {
        this.spawnedThreadTimeout = spawnedThreadTimeout;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.spawnedThreadTimeout != null) {
            this.blocking = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

