/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.jms;

import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.AbstractMessageProducerService;
import gov.va.med.fw.service.jms.JMSServiceException;
import gov.va.med.fw.service.jms.QueueDescriptor;
import gov.va.med.fw.service.jms.QueueMessageProducer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import org.springframework.jms.support.JmsUtils;

public class QueueMessageProducerService
extends AbstractMessageProducerService
implements QueueMessageProducer {
    private static final long serialVersionUID = 2808696406833332275L;
    private QueueDescriptor descriptor = null;

    public QueueDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(QueueDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.descriptor == null) {
            throw new ServiceConfigurationException("Required JMS descriptor property needs to be configured");
        }
    }

    @Override
    public void send(Object object, Properties properties) throws ServiceException {
        this.send(object, properties, 2, 4, 0L);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(Object object, Properties properties, int deliverymode, int priority, long timeToLive) throws ServiceException {
        if (object == null || properties == null || properties.isEmpty()) {
            throw new ServiceConfigurationException("Invalid message and properties");
        }
        QueueConnection connection = null;
        QueueSession session = null;
        Queue queue = null;
        boolean transactedJMSSession = !super.isSupportsDistributedTransactions();
        int sessionAckMode = 1;
        List providerURLs = this.descriptor.getProviderURLs();
        Iterator itr = providerURLs.iterator();
        String providerURL = null;
        while (itr.hasNext()) {
            providerURL = (String)itr.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting to JMS server at: " + providerURL));
            }
            try {
                connection = this.descriptor.createQueueConnection(providerURL);
                session = this.descriptor.createQueueSession(connection, transactedJMSSession, sessionAckMode);
                queue = this.descriptor.getQueue(providerURL);
                break;
            }
            catch (ServiceException e) {
                this.logger.error((Object)("Unable to establish JMS connectivity to " + providerURL + " due to exception: "), (Throwable)e);
                JmsUtils.closeSession((Session)session);
                session = null;
                JmsUtils.closeConnection((Connection)connection);
                connection = null;
                if (!itr.hasNext()) {
                    throw e;
                }
                this.logger.error((Object)"...Attempting fallback to lower priority providerURL");
            }
        }
        QueueSender sender = null;
        try {
            sender = session.createSender(queue);
            sender.setDeliveryMode(deliverymode);
            sender.setPriority(priority);
            sender.setTimeToLive(timeToLive);
            sender.setDisableMessageTimestamp(false);
            sender.setDisableMessageID(false);
            Message jmsMessage = this.createJMSMessageByType((Session)session, object, properties);
            sender.send(jmsMessage);
        }
        catch (MessageFormatException e) {
            try {
                throw new JMSServiceException("Invalid meessage format.", e);
                catch (InvalidDestinationException e2) {
                    throw new JMSServiceException("Invalid message queue.", e2);
                }
                catch (JMSException e3) {
                    throw new JMSServiceException("Failed to send a meessage.", e3);
                }
                catch (UnsupportedOperationException e4) {
                    throw new JMSServiceException("Missing a valid queue.", e4);
                }
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageProducer((MessageProducer)sender);
                sender = null;
                this.close((Session)session);
                session = null;
                JmsUtils.closeConnection((Connection)connection);
                connection = null;
                throw throwable;
            }
        }
        JmsUtils.closeMessageProducer((MessageProducer)sender);
        sender = null;
        this.close((Session)session);
        session = null;
        JmsUtils.closeConnection((Connection)connection);
    }
}

