/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.jms;

import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.jms.MessageProducer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public abstract class AbstractMessageProducerService
extends AbstractComponent
implements MessageProducer {
    private static final long serialVersionUID = 2808696406833332275L;
    private boolean supportsDistributedTransactions = true;
    private int sessionAcknowledgeMode = 1;

    @Override
    public void close(Session session) {
        IllegalStateException methodException = null;
        if (session != null) {
            try {
                if (session.getTransacted()) {
                    session.commit();
                }
            }
            catch (JMSException e) {
                this.logger.error((Object)"Failed to commit JMSSession", (Throwable)e);
                methodException = new IllegalStateException("Failed to commit JMSSession");
                methodException.initCause(e);
                throw methodException;
            }
            finally {
                block12: {
                    try {
                        session.close();
                    }
                    catch (Exception e2) {
                        this.logger.error((Object)"Failed to close JMSSession", (Throwable)e2);
                        if (methodException != null) break block12;
                        methodException = new IllegalStateException("Failed to close JMSSession");
                        methodException.initCause(e2);
                        throw methodException;
                    }
                }
            }
        }
    }

    protected javax.jms.Message createJMSMessageByType(Session session, Object data, Properties properties) throws JMSException {
        BytesMessage jmsMessage = null;
        if (data instanceof byte[]) {
            jmsMessage = session.createBytesMessage();
            jmsMessage.writeBytes((byte[])data);
        } else if (data instanceof String) {
            jmsMessage = session.createTextMessage();
            ((TextMessage)jmsMessage).setText((String)data);
        } else if (data instanceof Message) {
            jmsMessage = session.createTextMessage();
            ((TextMessage)jmsMessage).setText(((Message)data).getMessageData());
        } else if (data instanceof Map) {
            jmsMessage = session.createMapMessage();
            Map map = (Map)data;
            Set keys = map.keySet();
            for (Object key : keys) {
                ((MapMessage)jmsMessage).setObject(key.toString(), map.get(key));
            }
        } else if (data instanceof Serializable) {
            jmsMessage = session.createObjectMessage();
            ((ObjectMessage)jmsMessage).setObject((Serializable)data);
        } else {
            throw new MessageFormatException("Invalid object format.  Object must be serializable");
        }
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            jmsMessage.setStringProperty(key, properties.getProperty(key));
        }
        return jmsMessage;
    }

    public boolean isSupportsDistributedTransactions() {
        return this.supportsDistributedTransactions;
    }

    public void setSupportsDistributedTransactions(boolean supportsDistributedTransactions) {
        this.supportsDistributedTransactions = supportsDistributedTransactions;
    }

    public int getSessionAcknowledgeMode() {
        return this.sessionAcknowledgeMode;
    }

    public void setSessionAcknowledgeMode(int sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }
}

