/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security.jaas;

import gov.va.med.fw.security.SecurityService;
import gov.va.med.fw.security.jaas.AbstractUserPasswordLoginModule;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.config.SingletonApplicationContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class LoginModuleImpl
extends AbstractUserPasswordLoginModule {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private static final String OPTION_SERVICE_TARGET = "serviceTarget";
    private static final String DEFAULT_SECURITY_SERVICE_TARGET = "securityService";

    @Override
    protected List authenticate(String username, char[] password) throws LoginException {
        SecurityService ss;
        try {
            ss = this.getSecurityService();
        }
        catch (ServiceException e) {
            throw new LoginException("Unable to get a reference to Security Service. Reason: " + e.toString());
        }
        ArrayList<Principal> principals = new ArrayList<Principal>();
        Subject subject = ss.authenticate(username, new String(password));
        principals.addAll(subject.getPrincipals());
        return principals;
    }

    private SecurityService getSecurityService() throws ServiceException {
        try {
            String serviceName = this.getSecurityServiceBeanTargetName();
            this.debugIfOn("Using service target " + serviceName);
            SingletonApplicationContext locator = SingletonApplicationContext.getInstance();
            ApplicationContext ctx = locator.getSingletonContext();
            return (SecurityService)ctx.getBean(serviceName);
        }
        catch (BeansException e) {
            throw new ServiceException("Failed to get a security service", e);
        }
    }

    protected String getSecurityServiceBeanTargetName() {
        Object serviceTarget = this.getOption(OPTION_SERVICE_TARGET);
        String serviceTargetName = serviceTarget != null ? serviceTarget.toString() : DEFAULT_SECURITY_SERVICE_TARGET;
        return serviceTargetName;
    }

    @Override
    protected void logDebug(String msg) {
        this.logger.debug((Object)msg);
    }
}

