/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security;

import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.security.UserPrincipal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.ui.WebAuthenticationDetails;

public class SecurityContext
implements Serializable {
    public static final int AUDIT_ID_MAX_LENGTH = 30;
    private static final long serialVersionUID = -1823587167685741329L;
    private static final RolePrincipal[] EMPTY_ARRAY_ROLE_PRINCIPAL = new RolePrincipal[0];
    private UserPrincipal userPrincipal;
    private Object details = null;
    private List roles = new ArrayList();

    public SecurityContext(UserPrincipal userPrincipal) {
        if (userPrincipal == null) {
            throw new IllegalArgumentException("UserPrincipal can not be NULL.");
        }
        this.userPrincipal = userPrincipal;
    }

    public SecurityContext(UserPrincipal userPrincipal, GrantedAuthority[] authorities, Object details) {
        this.userPrincipal = userPrincipal;
        this.details = details;
        if (authorities != null) {
            for (int i = 0; i < authorities.length; ++i) {
                GrantedAuthority authority = authorities[i];
                this.roles.add(authority.getAuthority());
            }
        }
    }

    public UserPrincipal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getUserName(boolean standardizeName) {
        UserCredentials cred = this.getUserPrincipal().getUserCredentials();
        String id = cred.getLogicalID() != null ? cred.getLogicalID() : cred.getUserID();
        return standardizeName ? SecurityContext.standardizeAuditId(id) : id;
    }

    public String getUserName() {
        return this.getUserName(true);
    }

    public static String standardizeAuditId(String id) {
        if (id != null && id.length() > 30) {
            id = id.substring(0, 30);
        }
        return id;
    }

    public RolePrincipal[] getUserRoles() {
        if (this.userPrincipal == null || this.userPrincipal.getUserRoles() == null) {
            return EMPTY_ARRAY_ROLE_PRINCIPAL;
        }
        return this.userPrincipal.getUserRoles().toArray(EMPTY_ARRAY_ROLE_PRINCIPAL);
    }

    public String[] getRolesAsStrings() {
        return this.roles.toArray(new String[0]);
    }

    public boolean isUserInRole(String roleName) {
        if (roleName == null) {
            return false;
        }
        for (int i = 0; i < this.roles.size(); ++i) {
            if (!roleName.equals((String)this.roles.get(i))) continue;
            return true;
        }
        return false;
    }

    public WebAuthenticationDetails getWebAuthenticationDetails() {
        if (this.details != null && this.details instanceof WebAuthenticationDetails) {
            return (WebAuthenticationDetails)this.details;
        }
        return null;
    }

    public String getDetails() {
        if (this.details == null) {
            return null;
        }
        return this.details.toString();
    }

    public String toString() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return "";
    }

    public void setLogicalName(String name) {
        this.userPrincipal.getUserCredentials().setLogicalID(name);
    }
}

