/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security;

import gov.va.med.fw.model.RolePrincipalImpl;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.security.AuthenticationToken;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.security.UserCredentials;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.acegisecurity.userdetails.memory.UserAttribute;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class LoginManagerImpl
implements InitializingBean,
LoginManager {
    protected transient Log log = LogFactory.getLog(this.getClass());
    private AuthenticationManager authenticationManager;
    private String anonymousKey;
    private UserAttribute anonymousUserAttribute;
    private Class context;

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public Class getContext() {
        return this.context;
    }

    public void setContext(Class context) {
        this.context = context;
    }

    public String getAnonymousKey() {
        return this.anonymousKey;
    }

    public void setAnonymousKey(String anonymousKey) {
        this.anonymousKey = anonymousKey;
    }

    public UserAttribute getAnonymousUserAttribute() {
        return this.anonymousUserAttribute;
    }

    public void setAnonymousUserAttribute(UserAttribute anonymousUserAttribute) {
        this.anonymousUserAttribute = anonymousUserAttribute;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationManager == null) {
            throw new IllegalArgumentException("Missing required property - AuthenticationManager: Must be specified.");
        }
        if (this.context == null || !SecurityContext.class.isAssignableFrom(this.context)) {
            throw new IllegalArgumentException("context must be defined and implement Context (typically use net.sf.acegisecurity.context.security.SecureContextImpl)");
        }
    }

    @Override
    public void login(HttpServletRequest request, UserCredentials userCredentails) throws LoginException {
        Validate.notNull((Object)userCredentails, (String)"Null UserCredentails not allowed.");
        Validate.notNull((Object)userCredentails.getUserID(), (String)"Null username not allowed.");
        this.doAuthentication(request, userCredentails);
    }

    @Override
    public void login(UserCredentials userCredentails) throws LoginException {
        if (userCredentails.isVerified()) {
            this.initializeUser(userCredentails);
        } else {
            this.login(null, userCredentails);
        }
    }

    private void initializeUser(UserCredentials userCredentials) {
        String id = userCredentials.getLogicalID() != null ? userCredentials.getLogicalID() : userCredentials.getUserID();
        this.loginAnonymous(id);
    }

    @Override
    public void loginAnonymous() throws IllegalStateException {
        this.loginAnonymous(null);
    }

    @Override
    public void loginAnonymous(String logicalID) throws IllegalStateException {
        if (!this.allowAnonymous()) {
            throw new IllegalArgumentException("Anonymous login not allowed.");
        }
        this.doAnonymousAuthentication(logicalID);
    }

    private boolean allowAnonymous() {
        return this.anonymousKey != null && this.anonymousUserAttribute != null;
    }

    private AuthenticationToken doAuthentication(HttpServletRequest request, UserCredentials userCredentails) throws LoginException {
        AuthenticationToken authToken = new AuthenticationToken(userCredentails.getUserID(), userCredentails.getPassword());
        try {
            AuthenticationToken result = (AuthenticationToken)this.getAuthenticationManager().authenticate((Authentication)authToken);
            this.onSuccessfulAuthentication(request, result);
            return result;
        }
        catch (AuthenticationException e) {
            String errMsg = "Error while authenticating user " + userCredentails.getUserID();
            if (this.log.isErrorEnabled()) {
                String exClassName = e.getCause().getClass().getName();
                String aEx = LoginException.class.getName();
                if (aEx.equals(exClassName)) {
                    this.log.error((Object)errMsg, (Throwable)e);
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info((Object)errMsg, (Throwable)e);
            }
            this.onUnsuccessfulAuthentication(request, e);
            if (e.getCause() instanceof LoginException) {
                throw (LoginException)e.getCause();
            }
            throw new LoginException(e.toString());
        }
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, AuthenticationException ae) {
        this.setAcegiSecureContext(null);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, AuthenticationToken result) {
        if (request != null) {
            this.setDetails(request, result);
        }
        this.setAcegiSecureContext(result);
    }

    private Authentication doAnonymousAuthentication(String logicalID) {
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken(this.anonymousKey, (Object)this.anonymousUserAttribute.getPassword(), this.anonymousUserAttribute.getAuthorities());
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        UserPrincipalImpl anonPrin = new UserPrincipalImpl(result.getName(), (String)result.getCredentials());
        anonPrin.setAnonymous(true);
        anonPrin.setLogicalName(logicalID);
        GrantedAuthority[] authorities = result.getAuthorities();
        for (int a = 0; a < authorities.length; ++a) {
            GrantedAuthority authority = authorities[a];
            anonPrin.addUserRole(new RolePrincipalImpl(authority.getAuthority()));
        }
        result = new AnonymousAuthenticationToken(this.anonymousKey, (Object)anonPrin, result.getAuthorities());
        this.setAcegiSecureContext(result);
        return result;
    }

    @Override
    public void logout() {
        SecurityContext ctxt = SecurityContextHolder.getContext();
        if (ctxt != null && ctxt instanceof SecurityContext) {
            ctxt.setAuthentication(null);
        }
    }

    @Override
    public void logout(HttpServletRequest request) {
        this.logout();
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            httpSession.removeAttribute("ACEGI_SECURITY_CONTEXT");
        }
    }

    private void setAcegiSecureContext(Authentication auth) {
        if (SecurityContextHolder.getContext() == null) {
            try {
                SecurityContextHolder.setContext((SecurityContext)this.generateNewContext());
            }
            catch (Exception e) {
                IllegalStateException re = new IllegalStateException("Unable to generateNewContext");
                re.initCause(e);
                throw re;
            }
        }
        SecurityContext sc = SecurityContextHolder.getContext();
        sc.setAuthentication(auth);
        SecurityContextHolder.setContext((SecurityContext)sc);
    }

    protected void setDetails(HttpServletRequest request, AuthenticationToken authRequest) {
        authRequest.setDetails(new WebAuthenticationDetails(request));
    }

    private SecurityContext generateNewContext() throws Exception {
        return (SecurityContext)this.context.newInstance();
    }
}

