/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security;

import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.security.LDAPService;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.MultipleRecordsFoundException;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPServiceImpl
extends AbstractComponent
implements LDAPService {
    public static final String LDAP_ATTR_USER_PRINCIPAL_NAME = "userPrincipalName";
    public static final String LDAP_ATTR_USER_ACCOUNT_NAME = "sAMAccountName";
    public static final String LDAP_ATTR_USER_FIRST_NAME = "givenName";
    public static final String LDAP_ATTR_USER_LAST_NAME = "sn";
    public static final String LDAP_ATTR_USER_JOB_TITLE = "title";
    public static final String LDAP_ATTR_USER_MIDDLE_INITIALS = "initials";
    public static final String LDAP_DISTINGUISHED_NAME = "distinguishedName";
    private String domainContext = "DC=vha,DC=med,DC=va,DC=gov";
    private String ldapInitialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String authentication = "simple";
    private String securityRealm = null;
    private String ldapSASLqopMode = null;
    private String adminUserId = null;
    private String adminPassword = null;
    private List ldapServers = new ArrayList();
    private int timeOutMilliSeconds = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPrincipal authenticate(String userName, String password) throws ServiceException {
        UserPrincipal user = null;
        DirContext connection = this.getConnection(userName, password);
        try {
            user = this.getUserInfo(connection, userName, null, null, null);
        }
        finally {
            this.closeConnection(connection);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPrincipal getUserInfo(String userName) throws ServiceException {
        DirContext connection = this.getConnection();
        UserPrincipal user = null;
        try {
            user = this.getUserInfo(connection, userName, null, null, null);
        }
        finally {
            this.closeConnection(connection);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPrincipal getUserInfo(String firstName, String lastName, String middleName) throws ServiceException {
        DirContext connection = this.getConnection();
        UserPrincipal user = null;
        try {
            user = this.getUserInfo(connection, null, firstName, lastName, middleName);
        }
        finally {
            this.closeConnection(connection);
        }
        return user;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getDomainContext() {
        return this.domainContext;
    }

    public void setDomainContext(String domainContext) {
        this.domainContext = domainContext;
    }

    public String getLdapInitialContextFactory() {
        return this.ldapInitialContextFactory;
    }

    public void setLdapInitialContextFactory(String ldapInitialContextFactory) {
        this.ldapInitialContextFactory = ldapInitialContextFactory;
    }

    public String getLdapSASLqopMode() {
        return this.ldapSASLqopMode;
    }

    public void setLdapSASLqopMode(String ldapSASLqopMode) {
        this.ldapSASLqopMode = ldapSASLqopMode;
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public void setSecurityRealm(String securityRealm) {
        this.securityRealm = securityRealm;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getAdminUserId() {
        return this.adminUserId;
    }

    public void setAdminUserId(String adminUserId) {
        this.adminUserId = adminUserId;
    }

    public List getLdapServers() {
        return this.ldapServers;
    }

    public void setLdapServers(List ldapServers) {
        if (ldapServers != null && ldapServers.size() > 0) {
            this.ldapServers = ldapServers;
        }
    }

    public int getTimeOutMilliSeconds() {
        return this.timeOutMilliSeconds;
    }

    public void setTimeOutMilliSeconds(int timeOutMilliSeconds) {
        if (timeOutMilliSeconds > 0) {
            this.timeOutMilliSeconds = timeOutMilliSeconds;
        }
    }

    private UserPrincipal getUserInfo(DirContext connection, String userName, String firstName, String lastName, String middleName) throws ServiceException {
        UserPrincipal user = null;
        try {
            SearchControls searchCtls = new SearchControls(2, 0L, this.getTimeOutMilliSeconds(), new String[]{LDAP_ATTR_USER_PRINCIPAL_NAME, LDAP_ATTR_USER_ACCOUNT_NAME, LDAP_ATTR_USER_FIRST_NAME, LDAP_ATTR_USER_LAST_NAME, LDAP_ATTR_USER_JOB_TITLE, LDAP_ATTR_USER_MIDDLE_INITIALS, LDAP_DISTINGUISHED_NAME}, false, false);
            StringBuffer searchFilter = new StringBuffer("(&(objectclass=User)");
            if (userName != null) {
                if (userName.indexOf(64) > 0) {
                    searchFilter.append("(userPrincipalName=" + userName + ")");
                } else {
                    searchFilter.append("(sAMAccountName=" + userName + ")");
                }
            }
            if (firstName != null) {
                searchFilter.append("(givenName=" + firstName + ")");
            }
            if (lastName != null) {
                searchFilter.append("(sn=sn)");
            }
            if (middleName != null) {
                searchFilter.append("(initials=initials)");
            }
            searchFilter.append(")");
            NamingEnumeration<SearchResult> results = connection.search(this.getDomainContext(), searchFilter.toString(), searchCtls);
            if (results.hasMoreElements()) {
                SearchResult sr = results.next();
                if (results.hasMoreElements()) {
                    throw new MultipleRecordsFoundException("Multiple Records found");
                }
                Attributes attrs = sr.getAttributes();
                if (attrs != null) {
                    HashMap properties = new HashMap();
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMore()) {
                        Attribute attr = ae.next();
                        String attributeName = attr.getID();
                        NamingEnumeration<?> e = attr.getAll();
                        if (!e.hasMoreElements()) continue;
                        properties.put(attributeName, e.nextElement());
                    }
                    user = this.buildUserPrincipal(properties);
                }
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new ServiceException("LDAP Query failed", ex);
        }
        return user;
    }

    protected UserPrincipal buildUserPrincipal(Map properties) {
        String userName = (String)properties.get(LDAP_ATTR_USER_PRINCIPAL_NAME);
        userName = userName.substring(0, userName.indexOf(64));
        UserPrincipalImpl user = new UserPrincipalImpl(userName);
        return user;
    }

    private void closeConnection(DirContext connection) {
        try {
            connection.close();
        }
        catch (Exception ex) {
            this.logger.error((Object)"LDAP Connection could not be closed", (Throwable)ex);
        }
    }

    private DirContext getConnection() throws ServiceException {
        return this.getConnection(this.getAdminUserId(), this.getAdminPassword());
    }

    private DirContext getConnection(String userName, String password) throws ServiceException {
        List servers = this.getLdapServers();
        ServiceException prevEx = null;
        for (int i = 0; i < servers.size(); ++i) {
            try {
                DirContext context = this.getConnection((String)servers.get(i), userName, password);
                if (i > 0) {
                    String newPrimary = (String)servers.get(i);
                    String oldPrimary = (String)servers.get(0);
                    servers.set(0, newPrimary);
                    servers.set(i, oldPrimary);
                    this.setLdapServers(servers);
                }
                return context;
            }
            catch (ServiceException e) {
                prevEx = e;
                this.logger.error((Object)("LDAP Connection attempt with server " + (String)servers.get(i) + " Failed"));
                continue;
            }
        }
        if (prevEx == null) {
            throw new ServiceException("LADP Connextion failed");
        }
        throw prevEx;
    }

    private DirContext getConnection(String ldapServer, String userName, String password) throws ServiceException {
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>(10);
            env.put("java.naming.provider.url", ldapServer);
            env.put("java.naming.factory.initial", this.getLdapInitialContextFactory());
            env.put("java.naming.security.authentication", this.getAuthentication());
            env.put("java.naming.security.principal", userName);
            byte[] pwdBytes = password.getBytes("UTF-8");
            env.put("java.naming.security.credentials", pwdBytes);
            if (this.getSecurityRealm() != null) {
                env.put("java.naming.security.sasl.realm", this.getSecurityRealm());
            }
            if (this.getLdapSASLqopMode() != null) {
                env.put("javax.security.sasl.qop", this.getLdapSASLqopMode());
            }
            InitialDirContext connection = new InitialDirContext(env);
            return connection;
        }
        catch (Exception ex) {
            throw new ServiceException("LDAP Connection Failed", ex);
        }
    }
}

