/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security;

import gov.va.med.fw.security.EncryptionService;
import gov.va.med.fw.security.EncryptionServiceException;
import gov.va.med.fw.security.KeyCache;
import gov.va.med.fw.security.KeyManager;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.StringUtils;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptionServiceImpl
extends AbstractComponent
implements EncryptionService {
    public static final String AES_PREFIX = "{AES}";
    public static final String ENCRYPTION_ALOGORITHM_AES = "AES/ECB/PKCS5Padding";
    private static final byte[] key = new byte[]{82, 50, 50, 36, 114, 86, 35, 2, 19, 118, 57, 24, 82, 100, 88, 22};
    private String encryptionKey = null;
    private SecretKeySpec skeySpec = null;
    private String encryptionPrefix = "{AES}";
    protected String algorithm;
    protected String keyAlgorithm;
    protected int keySize;
    protected boolean encryptionFlag;
    protected String defaultCharacterEncoding;
    protected KeyManager keyManager;

    @Override
    public String encrypt(SecretKey key, String characterEncoding, String clearText) throws EncryptionServiceException {
        return this.encrypt(key, characterEncoding, clearText, "CRYPTO");
    }

    @Override
    public String encrypt(SecretKey key, String characterEncoding, String clearText, String cryptoSuffix) throws EncryptionServiceException {
        String encrypted = clearText;
        if (key != null && clearText != null && clearText.length() > 0) {
            try {
                Cipher cipher = Cipher.getInstance(this.getAlgorithm());
                cipher.init(1, key);
                if (!StringUtils.isEmpty((String)cryptoSuffix)) {
                    clearText = clearText + cryptoSuffix;
                }
                if (StringUtils.isEmpty((String)characterEncoding)) {
                    characterEncoding = this.defaultCharacterEncoding;
                }
                byte[] utf8 = clearText.getBytes(characterEncoding);
                byte[] enc = cipher.doFinal(utf8);
                encrypted = new BASE64Encoder().encode(enc);
            }
            catch (Exception ex) {
                throw new EncryptionServiceException("error while encrypting" + ex);
            }
        }
        return encrypted;
    }

    @Override
    public String decrypt(SecretKey key, String characterEncoding, String encryptedText) throws EncryptionServiceException {
        return this.decrypt(key, characterEncoding, encryptedText, "CRYPTO");
    }

    @Override
    public String decrypt(SecretKey key, String characterEncoding, String encryptedText, String cryptoSuffix) throws EncryptionServiceException {
        String decryptedText = encryptedText;
        if (key != null && encryptedText != null && encryptedText.length() > 0) {
            try {
                Cipher cipher = Cipher.getInstance(this.getAlgorithm());
                cipher.init(2, key);
                byte[] dec = new BASE64Decoder().decodeBuffer(encryptedText);
                byte[] utf8 = cipher.doFinal(dec);
                if (StringUtils.isEmpty((String)characterEncoding)) {
                    characterEncoding = this.defaultCharacterEncoding;
                }
                String clearText = new String(utf8, characterEncoding);
                if (!StringUtils.isEmpty((String)cryptoSuffix)) {
                    if (!clearText.endsWith(cryptoSuffix)) {
                        throw new EncryptionServiceException("decryption error.");
                    }
                    decryptedText = clearText.substring(0, clearText.lastIndexOf(cryptoSuffix));
                } else {
                    decryptedText = clearText;
                }
            }
            catch (Exception ex) {
                throw new EncryptionServiceException("error while decrypting the text", ex);
            }
        }
        return decryptedText;
    }

    protected SecretKey getSecretKey(KeyCache keyCache, boolean createSecretKey) throws EncryptionServiceException {
        if (this.keyManager == null) {
            throw new EncryptionServiceException("keyManager is null");
        }
        SecretKey secretKey = this.keyManager.getKey(keyCache);
        if (secretKey == null && createSecretKey) {
            secretKey = this.getSkeySpec();
            keyCache.setKey(secretKey);
        }
        return secretKey;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @Override
    public boolean isEncryptionEnabled() {
        return this.encryptionFlag;
    }

    @Override
    public void setEncryptionFlag(boolean encryptionFlag) {
        this.encryptionFlag = encryptionFlag;
    }

    @Override
    public String getDefaultCharacterEncoding() {
        return this.defaultCharacterEncoding;
    }

    @Override
    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }

    @Override
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    @Override
    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public SecretKeySpec getSkeySpec() {
        return this.skeySpec;
    }

    public void setSkeySpec(SecretKeySpec skeySpec) {
        this.skeySpec = skeySpec;
    }

    public String getEncryptionPrefix() {
        return this.encryptionPrefix;
    }

    public void setEncryptionPrefix(String encryptionPrefix) {
        this.encryptionPrefix = encryptionPrefix;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty((String)this.algorithm)) {
            throw new EncryptionServiceException("encryption algorithm is not set.");
        }
        if (this.keyManager == null) {
            throw new EncryptionServiceException("key manager is not set.");
        }
        if (StringUtils.isEmpty((String)this.defaultCharacterEncoding)) {
            throw new EncryptionServiceException("default character encoding is not set.");
        }
        this.setSkeySpec(new SecretKeySpec(key, this.getKeyAlgorithm()));
        if (this.getAlgorithm().startsWith(ENCRYPTION_ALOGORITHM_AES)) {
            this.encryptionPrefix = AES_PREFIX;
        }
    }
}

