/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.batchprocess.BatchProcessInvoker;
import gov.va.med.fw.batchprocess.BatchProcessService;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.util.ReflectionException;
import gov.va.med.fw.util.Reflector;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class StatelessScheduledService
extends QuartzJobBean
implements Serializable,
InterruptableJob {
    public static final String ARGUMENTS_METHOD = "methodArguments";
    private static final String INVOKE_METHOD = "invoke";
    private static final String INTERRUPT_METHOD = "interrupt";
    private static final long serialVersionUID = -5611593072858343064L;
    private String serviceName = null;
    private String methodName = "invoke";
    private ApplicationContext applicationContext = null;
    private Object[] methodArguments = null;
    private String interruptMethod = "interrupt";
    private BatchProcessInvoker batchProcessInvoker;
    private BatchProcessService batchProcessService;
    private LoginManager loginManager;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setMethodArguments(Object[] methodArguments) {
        this.methodArguments = methodArguments;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInterruptMethod() {
        return this.interruptMethod;
    }

    public void setInterruptMethod(String interruptMethod) {
        this.interruptMethod = interruptMethod;
    }

    public void interrupt() throws UnableToInterruptJobException {
        try {
            Object service = this.getApplicationContext().getBean(this.getServiceName());
            Reflector.invoke(service, this.interruptMethod, null);
        }
        catch (NoSuchMethodException e) {
            UnableToInterruptJobException ex = new UnableToInterruptJobException("A interrupt method to run is missing");
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (ReflectionException e) {
            UnableToInterruptJobException ex = new UnableToInterruptJobException("A interrupt method to run is in accessible");
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            UnableToInterruptJobException ex = new UnableToInterruptJobException("Exception thrown in a interrupt method " + this.interruptMethod);
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (Exception e) {
            UnableToInterruptJobException ex = new UnableToInterruptJobException("Exception thrown in a interrupt method " + this.interruptMethod);
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (Error e) {
            UnableToInterruptJobException ex = new UnableToInterruptJobException("Exception thrown in a interrupt method " + this.interruptMethod);
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (this.applicationContext == null || this.methodName == null || this.serviceName == null) {
            throw new JobExecutionException("Missing required properties to run a job");
        }
        Object[] currentArguments = this.methodArguments;
        Object[] contextArguments = null;
        if (context.getMergedJobDataMap().containsKey((Object)ARGUMENTS_METHOD)) {
            contextArguments = context.getMergedJobDataMap().get((Object)ARGUMENTS_METHOD) instanceof List ? ((List)context.getMergedJobDataMap().get((Object)ARGUMENTS_METHOD)).toArray() : (Object[])context.getMergedJobDataMap().get((Object)ARGUMENTS_METHOD);
            if (this.methodArguments == null) {
                currentArguments = contextArguments;
            } else if (this.isNotJobData(contextArguments)) {
                currentArguments = ArrayUtils.addAll((Object[])this.methodArguments, (Object[])contextArguments);
            }
        }
        try {
            String executionContext;
            ScheduledProcessInvocationContext invContext = new ScheduledProcessInvocationContext();
            if (currentArguments != null) {
                invContext.setInvocationArguments(currentArguments.length == 1 ? currentArguments[0] : currentArguments);
            }
            if (StringUtils.isNotBlank((String)(executionContext = (String)context.getMergedJobDataMap().get((Object)"executionContext")))) {
                invContext.setExecutionContext(executionContext);
            }
            invContext.setServiceName(this.serviceName);
            invContext.setMethodName(this.methodName);
            invContext.setJobName(context.getJobDetail().getName());
            invContext.setJobGroup(context.getJobDetail().getGroup());
            this.doExecuteJob(invContext);
        }
        catch (NoSuchMethodException e) {
            throw new JobExecutionException("A service method to run is missing", (Exception)e, false);
        }
        catch (ReflectionException e) {
            throw new JobExecutionException("A service method to run is in accessible", (Exception)e, false);
        }
        catch (InvocationTargetException e) {
            throw new JobExecutionException("Failed to run a job in: " + this.methodName, (Exception)e, false);
        }
        catch (Exception e) {
            throw new JobExecutionException("Failed to run a job in: " + this.methodName, e, false);
        }
        catch (Error e) {
            JobExecutionException je = new JobExecutionException("Failed to run a job in: " + this.methodName, null, false);
            je.initCause((Throwable)e);
            throw je;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecuteJob(ScheduledProcessInvocationContext invContext) throws Exception {
        if (!this.containsBatchProcessInvoker()) {
            if (!this.containsBatchProcessService()) {
                throw new IllegalStateException("Missing BatchProcessService to execute job");
            }
            this.getBatchProcessService().executeJob(invContext);
        } else {
            String jobName = invContext.getJobName();
            BatchProcessDetail detail = this.getBatchProcessInvoker().getBatchProcessDetail(jobName);
            if (detail == null) {
                detail = new BatchProcessDetail();
                detail.setJobName(invContext.getJobName());
                detail.setGroupName(invContext.getJobGroup());
            }
            try {
                this.getLoginManager().loginAnonymous(Thread.currentThread().getName());
                this.getBatchProcessInvoker().invokeBatchProcessWithEvent(detail, invContext);
            }
            finally {
                this.getLoginManager().logout();
            }
        }
    }

    private boolean isNotJobData(Object[] args) {
        if (this.methodArguments.length != args.length) {
            return true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(this.methodArguments[i])) continue;
            return true;
        }
        return false;
    }

    private boolean containsBatchProcessInvoker() {
        try {
            this.getBatchProcessInvoker();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean containsBatchProcessService() {
        try {
            this.getBatchProcessService();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private BatchProcessInvoker getBatchProcessInvoker() {
        if (this.batchProcessInvoker == null) {
            try {
                this.batchProcessInvoker = (BatchProcessInvoker)((Object)this.getApplicationContext().getBean(ClassUtils.getShortClassName(BatchProcessInvoker.class), BatchProcessInvoker.class));
            }
            catch (IllegalStateException e) {
                if (this.getApplicationContext() instanceof ConfigurableApplicationContext) {
                    ((ConfigurableApplicationContext)this.getApplicationContext()).refresh();
                    this.batchProcessInvoker = (BatchProcessInvoker)((Object)this.getApplicationContext().getBean(ClassUtils.getShortClassName(BatchProcessInvoker.class), BatchProcessInvoker.class));
                }
                throw e;
            }
        }
        return this.batchProcessInvoker;
    }

    private BatchProcessService getBatchProcessService() {
        if (this.batchProcessService == null) {
            try {
                this.batchProcessService = (BatchProcessService)this.getApplicationContext().getBean(ClassUtils.getShortClassName(BatchProcessService.class), BatchProcessService.class);
            }
            catch (IllegalStateException e) {
                if (this.getApplicationContext() instanceof ConfigurableApplicationContext) {
                    ((ConfigurableApplicationContext)this.getApplicationContext()).refresh();
                    this.batchProcessService = (BatchProcessService)this.getApplicationContext().getBean(ClassUtils.getShortClassName(BatchProcessService.class), BatchProcessService.class);
                }
                throw e;
            }
        }
        return this.batchProcessService;
    }

    private LoginManager getLoginManager() {
        if (this.loginManager == null) {
            try {
                this.loginManager = (LoginManager)this.getApplicationContext().getBean(ClassUtils.getShortClassName(LoginManager.class), LoginManager.class);
            }
            catch (IllegalStateException e) {
                if (this.getApplicationContext() instanceof ConfigurableApplicationContext) {
                    ((ConfigurableApplicationContext)this.getApplicationContext()).refresh();
                    this.loginManager = (LoginManager)this.getApplicationContext().getBean(ClassUtils.getShortClassName(LoginManager.class), LoginManager.class);
                }
                throw e;
            }
        }
        return this.loginManager;
    }
}

