/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.cache.CacheStrategy;
import gov.va.med.fw.rule.RuleConfigurationException;
import gov.va.med.fw.rule.RuleEvent;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleExceptionHandler;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.rule.RuleState;
import gov.va.med.fw.rule.RuleValidationException;
import gov.va.med.fw.service.AbstractListenerService;
import gov.va.med.fw.service.event.ServiceEvent;
import ilog.rules.debug.IlrBuilderToolFactory;
import ilog.rules.debug.IlrLocalTracerToolFactory;
import ilog.rules.engine.IlrContext;
import ilog.rules.engine.IlrExceptionHandler;
import ilog.rules.engine.IlrParameterMap;
import ilog.rules.engine.IlrRuleset;
import ilog.rules.engine.IlrToolConnectionException;
import ilog.rules.engine.IlrToolFactory;
import ilog.rules.engine.IlrUserRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.ClassPathResource;

public class RuleFlowManager
extends AbstractListenerService {
    private Map rulesets = null;
    private CacheStrategy ruleSetsCache = null;

    public void setRulesets(Map rulesets) {
        this.rulesets = rulesets;
    }

    public void setRuleSetsCache(CacheStrategy cache) {
        this.ruleSetsCache = cache;
    }

    public Object fireRule(String ruleflow, RuleParameter parameter) throws RuleException {
        HashMap result = null;
        StringWriter errorWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(errorWriter);
        IlrContext engine = this.getRuleContext(ruleflow);
        Throwable error = null;
        try {
            block14: {
                IlrParameterMap inParams = new IlrParameterMap();
                inParams.setParameter(parameter.getInputName(), (Object)parameter);
                RuleState state = parameter.getState();
                state.setRuleExecuted(false);
                inParams.setParameter(state.getName(), (Object)state);
                engine.setParameters(inParams);
                RuleExceptionHandler handler = parameter.getExceptionHandler();
                handler.setRuleFlowName(ruleflow);
                engine.setExceptionHandler((IlrExceptionHandler)handler);
                if (parameter.isDebugEnabled()) {
                    try {
                        engine.connectTool((IlrToolFactory)new IlrBuilderToolFactory(10));
                    }
                    catch (IlrToolConnectionException e) {
                        if (!this.logger.isErrorEnabled()) break block14;
                        this.logger.error((Object)"Failed to connect to a rule engine ", (Throwable)e);
                    }
                }
            }
            engine.connectTool((IlrToolFactory)new IlrLocalTracerToolFactory((Writer)printWriter));
            parameter.getState().setInSession(true);
            IlrParameterMap outParams = engine.execute();
            result = outParams.getMap();
        }
        catch (IlrUserRuntimeException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("ILog Exception for target member: " + e.getTargetMember()));
                this.logger.error((Object)("ILog Exception caused by: " + e.getTargetException()));
            }
            error = e;
            if (e.getTargetException() instanceof RuleValidationException) {
                throw new RuleException(e.getMessage(), e.getTargetException(), ruleflow, parameter);
            }
            throw new RuleConfigurationException("An un-expected error occured in rule flow: " + ruleflow, (Throwable)e, ruleflow, parameter);
        }
        catch (Exception e) {
            error = e;
            throw new RuleConfigurationException("Failed to obtain a rule flow named" + ruleflow, (Throwable)e, ruleflow, parameter);
        }
        finally {
            if (error != null) {
                this.logger.error((Object)("Invoked rule flow: " + ruleflow));
                this.logger.error((Object)"Start Rule Trace Info:");
                this.logger.error((Object)errorWriter.toString());
                this.logger.error((Object)"End Rule Trace Info:");
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoked rule flow: " + ruleflow));
                this.logger.debug((Object)"Start Rule Trace Info:");
                this.logger.debug((Object)errorWriter.toString());
                this.logger.debug((Object)"End Rule Trace Info:");
            }
            parameter.getState().setInSession(false);
            engine.reset();
            engine.resetForPool();
            engine.end();
        }
        return result;
    }

    public Object fireRule(String ruleflow, RuleParameters parameters) throws RuleException {
        HashMap result = null;
        StringWriter errorWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(errorWriter);
        Throwable error = null;
        IlrContext engine = this.getRuleContext(ruleflow);
        try {
            block15: {
                IlrParameterMap inParams = new IlrParameterMap();
                Collection params = parameters.getRuleParameters().values();
                for (RuleParameter param : params) {
                    inParams.setParameter(param.getInputName(), (Object)param);
                }
                RuleState state = parameters.getState();
                state.setRuleExecuted(false);
                inParams.setParameter(state.getName(), (Object)state);
                engine.setParameters(inParams);
                RuleExceptionHandler handler = parameters.getExceptionHandler();
                handler.setRuleFlowName(ruleflow);
                engine.setExceptionHandler((IlrExceptionHandler)handler);
                if (parameters.isDebugEnabled()) {
                    try {
                        engine.connectTool((IlrToolFactory)new IlrBuilderToolFactory(10));
                    }
                    catch (IlrToolConnectionException e) {
                        if (!this.logger.isErrorEnabled()) break block15;
                        this.logger.error((Object)"Failed to connect to a rule engine ", (Throwable)e);
                    }
                }
            }
            engine.connectTool((IlrToolFactory)new IlrLocalTracerToolFactory((Writer)printWriter));
            this.setRuleParametersInSession(parameters, true);
            IlrParameterMap outParams = engine.execute();
            result = outParams.getMap();
        }
        catch (IlrUserRuntimeException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("ILog Exception for target member: " + e.getTargetMember()));
                this.logger.error((Object)("ILog Exception caused by: " + e.getTargetException()));
            }
            error = e;
            if (e.getTargetException() instanceof RuleValidationException) {
                throw new RuleException(e.getMessage(), e.getTargetException(), ruleflow, parameters.getRuleParameters().values().toArray(new RuleParameter[0]));
            }
            throw new RuleConfigurationException("An un-expected error occured in rule flow: " + ruleflow, (Throwable)e, ruleflow, parameters.getRuleParameters().values().toArray(new RuleParameter[0]));
        }
        catch (Exception e) {
            error = e;
            throw new RuleConfigurationException("Failed to obtain a rule flow named: " + ruleflow, (Throwable)e, ruleflow, parameters.getRuleParameters().values().toArray(new RuleParameter[0]));
        }
        finally {
            if (error != null) {
                this.logger.error((Object)("Invoked rule flow: " + ruleflow));
                this.logger.error((Object)"Start Rule Trace Info:");
                this.logger.error((Object)errorWriter.toString());
                this.logger.error((Object)"End Rule Trace Info:");
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoked rule flow: " + ruleflow));
                this.logger.debug((Object)"Start Rule Trace Info:");
                this.logger.debug((Object)errorWriter.toString());
                this.logger.debug((Object)"End Rule Trace Info:");
            }
            this.setRuleParametersInSession(parameters, false);
            engine.reset();
            engine.resetForPool();
            engine.end();
        }
        return result;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Validate.notEmpty((Map)this.rulesets, (String)"A ruleset to rule file mapping map must be configured");
        Validate.notNull((Object)this.ruleSetsCache, (String)"A ruleset cache must be configured");
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.rulesets = null;
        this.ruleSetsCache = null;
    }

    @Override
    protected void processServiceEvent(ServiceEvent event) {
        if (event instanceof RuleEvent) {
            RuleEvent ruleEvent = (RuleEvent)event;
            try {
                RuleParameter param = ruleEvent.getRuleParameter();
                if (param != null) {
                    this.fireRule(ruleEvent.getRuleflow(), param);
                } else {
                    RuleParameters params = ruleEvent.getRuleParameters();
                    if (params != null) {
                        this.fireRule(ruleEvent.getRuleflow(), params);
                    }
                }
            }
            catch (RuleException e) {
                this.processException(e, event.getSource());
            }
        }
    }

    private void setRuleParametersInSession(RuleParameters parameters, boolean flag) {
        Collection params = parameters.getRuleParameters().values();
        for (RuleParameter param : params) {
            param.getState().setInSession(flag);
        }
        parameters.getState().setInSession(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IlrContext getRuleContext(String ruleFlow) throws RuleConfigurationException {
        IlrRuleset ruleset;
        Object item = this.ruleSetsCache.getItem(ruleFlow);
        IlrRuleset ilrRuleset = ruleset = item instanceof IlrRuleset ? (IlrRuleset)item : null;
        if (ruleset == null) {
            CacheStrategy cacheStrategy = this.ruleSetsCache;
            synchronized (cacheStrategy) {
                block8: {
                    try {
                        String ruleFile = (String)this.rulesets.get(ruleFlow);
                        ruleset = new IlrRuleset();
                        ClassPathResource resource = new ClassPathResource(ruleFile);
                        InputStream stream = resource.getInputStream();
                        StringWriter errorWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(errorWriter);
                        ruleset.setMessageWriter(printWriter);
                        boolean parsed = ruleset.parseStream(stream);
                        if (parsed) {
                            this.ruleSetsCache.cacheItem(ruleFlow, ruleset);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Rule set " + ruleFlow + " was parsed successfully"));
                            }
                            break block8;
                        }
                        throw new RuleConfigurationException(errorWriter.toString());
                    }
                    catch (IOException e) {
                        throw new RuleConfigurationException("Failed to load a rule file", e);
                    }
                }
            }
        }
        return new IlrContext(ruleset);
    }
}

