/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleValidationException;

public class RuleException
extends Exception {
    private static final long serialVersionUID = 6789630754747451866L;
    private String messageID = null;
    private Object originator = null;
    private String ruleFlowName = null;
    private RuleParameter[] ruleWrappers = null;
    private Object contextInfo;

    public RuleException() {
    }

    public RuleException(String msg) {
        super(msg);
    }

    public RuleException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public RuleException(String msg, Throwable cause, String ruleFlow, RuleParameter wrapper) {
        this(msg, cause, ruleFlow, new RuleParameter[]{wrapper});
    }

    public RuleException(String msgID, Object originator, String ruleFlow, RuleParameter wrapper) {
        this.ruleFlowName = ruleFlow;
        this.ruleWrappers = new RuleParameter[]{wrapper};
        this.messageID = msgID;
        this.originator = originator;
    }

    public RuleException(String msg, Throwable cause, String ruleFlow, RuleParameter[] wrappers) {
        super(msg, cause);
        this.ruleFlowName = ruleFlow;
        this.ruleWrappers = wrappers;
        this.messageID = cause instanceof RuleValidationException ? ((RuleValidationException)cause).getMessageID() : null;
        this.originator = cause instanceof RuleValidationException ? ((RuleValidationException)cause).getOriginator() : null;
    }

    public String getRuleFlowName() {
        return this.ruleFlowName;
    }

    public RuleParameter getRuleWrapper() {
        return this.ruleWrappers != null && this.ruleWrappers.length == 1 ? this.ruleWrappers[0] : null;
    }

    public RuleParameter[] getRuleWrappers() {
        return this.ruleWrappers;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public Object getOriginator() {
        return this.originator;
    }

    public Object getContextInfo() {
        return this.contextInfo;
    }

    public void setContextInfo(Object contextInfo) {
        this.contextInfo = contextInfo;
    }
}

