/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.rule.AbstractRuleParameters;
import gov.va.med.fw.rule.RuleConfigurationException;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ConfigurableRuleParameters
extends AbstractRuleParameters {
    private static final long serialVersionUID = 6450370654925439842L;

    @Override
    public void initializeRuleParmeters(RuleDataAware data) throws RuleConfigurationException {
        Map params = this.getRuleParameters();
        if (params != null && !params.isEmpty()) {
            Collection values = params.values();
            for (Object value : values) {
                if (!(value instanceof RuleParameter)) continue;
                ((RuleParameter)value).setRuleDataAware(data);
            }
        }
    }

    @Override
    public void initializeRuleParmeters(Map ruleData) throws RuleConfigurationException {
        Validate.notEmpty((Map)ruleData, (String)"A rule data map must not be null or empty");
        Map params = this.getRuleParameters();
        if (params != null && !params.isEmpty()) {
            Collection values = params.values();
            for (Object value : values) {
                RuleParameter param;
                Object data;
                if (!(value instanceof RuleParameter) || (data = ruleData.get(((AbstractComponent)((Object)(param = (RuleParameter)value))).getBeanName())) == null) continue;
                param.setRuleDataAware((RuleDataAware)data);
            }
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.getRuleFlowName(), (String)"A rule flow name must not be null");
    }
}

