/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleExceptionHandler;
import gov.va.med.fw.rule.RuleFlowNameAware;
import gov.va.med.fw.rule.RuleMethod;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleParameterNameAware;
import gov.va.med.fw.rule.RuleSession;
import gov.va.med.fw.rule.RuleState;
import gov.va.med.fw.rule.SimpleRuleDataAware;
import gov.va.med.fw.rule.SimpleRuleFlowNameAware;
import gov.va.med.fw.rule.SimpleRuleMethod;
import gov.va.med.fw.rule.SimpleRuleParameterNameAware;
import gov.va.med.fw.rule.SimpleRuleSession;
import gov.va.med.fw.service.AbstractComponent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRuleParameter
extends AbstractComponent
implements RuleParameter {
    private static final long serialVersionUID = -1370346746640850300L;
    private RuleFlowNameAware ruleFlowNameAware = null;
    private RuleParameterNameAware ruleParameterNameAware = null;
    private RuleMethod ruleMethod = null;
    private RuleSession ruleSession = null;
    private RuleDataAware ruleDataAware = null;

    protected AbstractRuleParameter() {
        this.initialize();
    }

    @Override
    public AbstractEntity getIncomingData() {
        return this.ruleDataAware.getIncomingData();
    }

    @Override
    public AbstractEntity getPristineData() {
        return this.ruleDataAware.getPristineData();
    }

    @Override
    public AbstractEntity getResultData() {
        return this.ruleDataAware.getResultData();
    }

    @Override
    public void setIncomingData(AbstractEntity incoming) {
        this.ruleDataAware.setIncomingData(incoming);
    }

    @Override
    public void setPristineData(AbstractEntity pristine) {
        this.ruleDataAware.setPristineData(pristine);
    }

    @Override
    public void setResultData(AbstractEntity result) {
        this.ruleDataAware.setResultData(result);
    }

    @Override
    public boolean isDateBetween(Date dateToCheck, Date lowerDate, Date upperDate) {
        return this.ruleMethod.isDateBetween(dateToCheck, lowerDate, upperDate);
    }

    @Override
    public BigDecimal percentageOf(BigDecimal a, double percentage) {
        return this.ruleMethod.percentageOf(a, percentage);
    }

    @Override
    public boolean isLessThan(BigDecimal value, BigDecimal upper) {
        return this.ruleMethod.isLessThan(value, upper);
    }

    @Override
    public boolean isSameDay(Date date1, Date date2) {
        return this.ruleMethod.isSameDay(date1, date2);
    }

    @Override
    public boolean isAfter(Date value, Date lower) {
        return this.ruleMethod.isAfter(value, lower);
    }

    @Override
    public boolean isNull(Object obj) {
        return this.ruleMethod.isNull(obj);
    }

    @Override
    public boolean isBefore(Date value, Date upper) {
        return this.ruleMethod.isBefore(value, upper);
    }

    @Override
    public BigDecimal add(BigDecimal a, BigDecimal b) {
        return this.ruleMethod.add(a, b);
    }

    @Override
    public boolean isCalendarEqual(Calendar arg1, Calendar arg2, int field) throws RuleException {
        return this.ruleMethod.isCalendarEqual(arg1, arg2, field);
    }

    @Override
    public boolean isEmpty(Collection collection) {
        return this.ruleMethod.isEmpty(collection);
    }

    @Override
    public boolean isEqual(Object arg1, Object arg2) {
        return this.ruleMethod.isEqual(arg1, arg2);
    }

    @Override
    public boolean isGreaterThan(Integer value, int lower) {
        return this.ruleMethod.isGreaterThan(value, lower);
    }

    @Override
    public boolean isGreaterThan(BigDecimal value, Integer lower) {
        return this.ruleMethod.isGreaterThan(value, lower);
    }

    @Override
    public boolean isGreaterThan(Integer value, Integer lower) {
        return this.ruleMethod.isGreaterThan(value, lower);
    }

    @Override
    public boolean isGreaterThan(Integer value, BigDecimal lower) {
        return this.ruleMethod.isGreaterThan(value, lower);
    }

    @Override
    public boolean isInRange(Integer value, int lower, int upper) {
        return this.ruleMethod.isInRange(value, lower, upper);
    }

    @Override
    public boolean isInRange(BigDecimal value, double lower, double upper) {
        return this.ruleMethod.isInRange(value, lower, upper);
    }

    @Override
    public boolean isLessThan(Integer value, int upper) {
        return this.ruleMethod.isLessThan(value, upper);
    }

    @Override
    public boolean isPartOf(String value, String pattern) {
        return this.ruleMethod.isPartOf(value, pattern);
    }

    @Override
    public Calendar toCalendar(Date date) {
        return this.ruleMethod.toCalendar(date);
    }

    @Override
    public Calendar toCalendar(Date date, TimeZone timezone) {
        return this.ruleMethod.toCalendar(date, timezone);
    }

    @Override
    public Integer toInteger(Number value) {
        return this.ruleMethod.toInteger(value);
    }

    @Override
    public RuleExceptionHandler getExceptionHandler() {
        return this.ruleSession.getExceptionHandler();
    }

    @Override
    public RuleState getState() {
        return this.ruleSession.getState();
    }

    @Override
    public boolean isContinueOnFail() {
        return this.ruleSession.isContinueOnFail();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.ruleSession.isDebugEnabled();
    }

    @Override
    public void setContinueOnFail(boolean flag) {
        this.ruleSession.setContinueOnFail(flag);
    }

    @Override
    public void setExceptionHandler(RuleExceptionHandler handler) {
        this.ruleSession.setExceptionHandler(handler);
    }

    @Override
    public void setState(RuleState state) {
        this.ruleSession.setState(state);
    }

    @Override
    public RuleDataAware getRuleDataAware() {
        return this.ruleDataAware;
    }

    @Override
    public void setRuleDataAware(RuleDataAware ruleData) {
        this.ruleDataAware = ruleData;
    }

    @Override
    public RuleMethod getRuleMethod() {
        return this.ruleMethod;
    }

    @Override
    public void setRuleMethod(RuleMethod ruleMethod) {
        this.ruleMethod = ruleMethod;
    }

    @Override
    public RuleParameterNameAware getRuleParameterNameAware() {
        return this.ruleParameterNameAware;
    }

    @Override
    public void setRuleParameterNameAware(RuleParameterNameAware ruleParameterName) {
        this.ruleParameterNameAware = ruleParameterName;
    }

    @Override
    public RuleSession getRuleSession() {
        return this.ruleSession;
    }

    @Override
    public void setRuleSession(RuleSession ruleSession) {
        this.ruleSession = ruleSession;
    }

    @Override
    public RuleFlowNameAware getRuleFlowNameAware() {
        return this.ruleFlowNameAware;
    }

    @Override
    public void setRuleFlowNameAware(RuleFlowNameAware ruleFlowNameAware) {
        this.ruleFlowNameAware = ruleFlowNameAware;
    }

    @Override
    public String getRuleFlowName() {
        return this.ruleFlowNameAware.getRuleFlowName();
    }

    @Override
    public void setRuleFlowName(String name) {
        this.ruleFlowNameAware.setRuleFlowName(name);
    }

    @Override
    public String getInputName() {
        String name = this.ruleParameterNameAware.getInputName();
        return name == null ? this.getDefaultInputName() : name;
    }

    @Override
    public String getOutputName() {
        return this.ruleParameterNameAware.getOutputName();
    }

    @Override
    public void setInputName(String name) {
        this.ruleParameterNameAware.setInputName(name);
    }

    @Override
    public void setOutputName(String name) {
        this.ruleParameterNameAware.setOutputName(name);
    }

    @Override
    public Date getCurrentDate() {
        return this.ruleMethod.getCurrentDate();
    }

    @Override
    public String getLoggedInUser() {
        return this.ruleMethod.getLoggedInUser();
    }

    @Override
    public int getSize(Collection collection) {
        return this.ruleMethod.getSize(collection);
    }

    @Override
    public boolean isEqual(BigDecimal arg1, int arg2) {
        return this.ruleMethod.isEqual(arg1, arg2);
    }

    @Override
    public Date toDate(String value) throws ParseException {
        return this.ruleMethod.toDate(value);
    }

    @Override
    public Date toDate(String value, int pattern) throws ParseException {
        return this.ruleMethod.toDate(value, pattern);
    }

    @Override
    public Integer toInteger(int value) {
        return this.ruleMethod.toInteger(value);
    }

    @Override
    public boolean isGreaterThan(BigDecimal value, BigDecimal lower) {
        return this.ruleMethod.isGreaterThan(value, lower);
    }

    protected void initialize() {
        this.setRuleDataAware(new SimpleRuleDataAware());
        this.setRuleMethod(new SimpleRuleMethod());
        this.setRuleFlowNameAware(new SimpleRuleFlowNameAware());
        this.setRuleParameterNameAware(new SimpleRuleParameterNameAware());
        this.setRuleSession(new SimpleRuleSession());
        RuleState state = this.getRuleSession().getState();
        state.setRuleFlowNameAware(this.getRuleFlowNameAware());
        state.setRuleParameter(this);
    }

    protected String getDefaultInputName() {
        String name = ClassUtils.getShortClassName(this.getClass());
        List interfaces = ClassUtils.getAllInterfaces(this.getClass());
        if (interfaces != null && interfaces.size() > 0) {
            name = ClassUtils.getShortClassName((Class)((Class)interfaces.get(0)));
        }
        return StringUtils.uncapitalize((String)name);
    }
}

