/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report.jasperreport;

import gov.va.med.fw.report.AbstractReportTemplate;
import gov.va.med.fw.report.InvalidTemplateException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.ClassPathResource;

public class JasperReportTemplate
extends AbstractReportTemplate {
    private static final String REPORT_TEMPLATE_EXTENTION = ".jrxml";
    private static final String COMPILED_REPORT_EXTENTION = ".jasper";
    private static final long serialVersionUID = 2415040386874612549L;

    @Override
    protected void compileTemplates(Map templates) throws InvalidTemplateException {
        Set entries = templates.entrySet();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            String tplName = value != null && value instanceof String ? (String)value : null;
            this.getTemplateCache().cacheItem(key, this.loadJasperReportTemplate(tplName));
        }
    }

    protected JasperReport loadJasperReportTemplate(String name) throws InvalidTemplateException {
        JasperReport template = null;
        try {
            this.validateTemplateName(name);
            InputStream inStream = this.getTemplateStream(name);
            if (name.endsWith(REPORT_TEMPLATE_EXTENTION)) {
                JasperDesign design = JRXmlLoader.load((InputStream)inStream);
                template = JasperCompileManager.compileReport((JasperDesign)design);
            } else {
                Object compiled = JRLoader.loadObject((InputStream)inStream);
                template = compiled instanceof JasperReport ? (JasperReport)compiled : null;
            }
        }
        catch (JRException e) {
            throw new InvalidTemplateException("Failed to compile a report template [" + name + "]", e);
        }
        return template;
    }

    protected InputStream getTemplateStream(String name) throws InvalidTemplateException {
        BufferedInputStream stream = null;
        try {
            ClassPathResource resource = new ClassPathResource(name);
            stream = new BufferedInputStream(resource.getInputStream());
        }
        catch (IOException e) {
            throw new InvalidTemplateException("Template file not found ", e);
        }
        catch (SecurityException e) {
            throw new InvalidTemplateException("Access not granted to a template file ", e);
        }
        return stream;
    }

    protected void validateTemplateName(String name) {
        Validate.notNull((Object)name, (String)"A template name must not be NULL");
        Validate.isTrue((name.endsWith(REPORT_TEMPLATE_EXTENTION) || name.endsWith(COMPILED_REPORT_EXTENTION) ? 1 : 0) != 0, (String)"Invalid report template file");
    }
}

