/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportPersister;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.Validate;

public class FileSystemReportPersister
extends AbstractComponent
implements ReportPersister {
    private static final long serialVersionUID = -878185413664735720L;

    @Override
    public void persist(ReportConfiguration config, ByteArrayOutputStream stream) throws ReportException {
        Validate.notNull((Object)config, (String)"A report configuration must not be NULL");
        Validate.notNull((Object)stream, (String)"A report stream must not be NULL");
        try {
            String outputFile = config.getReportOutputName();
            BufferedOutputStream output = new BufferedOutputStream(FileUtils.getOutputStream(outputFile));
            stream.writeTo(output);
            stream.flush();
            stream.close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            throw new ReportException("Failed to write a report to a stream ", e);
        }
    }
}

